/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.data.MaryHeader;

public class VocalizationIntonationReader {
    private MaryHeader hdr = null;
    private int numberOfUnits = 0;
    private double windowSize = 0.0;
    private double skipSize = 0.0;
    private double[][] contours;
    private double[][] coeffs;
    private boolean[][] voiced;

    public VocalizationIntonationReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    public void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File [" + fileName + "] was not found.");
        }
        try {
            this.hdr = new MaryHeader(dis);
            if (this.hdr.getType() != 325) {
                throw new RuntimeException("File [" + fileName + "] is not a valid Mary Units file.");
            }
            this.windowSize = dis.readFloat();
            if (this.windowSize <= 0.0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number for window size. Aborting.");
            }
            this.skipSize = dis.readFloat();
            if (this.skipSize <= 0.0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number for window size. Aborting.");
            }
            this.numberOfUnits = dis.readInt();
            if (this.numberOfUnits < 0) {
                throw new RuntimeException("File [" + fileName + "] has a negative number of units. Aborting.");
            }
            this.contours = new double[this.numberOfUnits][];
            this.coeffs = new double[this.numberOfUnits][];
            this.voiced = new boolean[this.numberOfUnits][];
            for (int i = 0; i < this.numberOfUnits; ++i) {
                int polyOrder = dis.readInt();
                this.coeffs[i] = new double[polyOrder];
                for (int j = 0; j < polyOrder; ++j) {
                    this.coeffs[i][j] = dis.readFloat();
                }
                int f0ContourLength = dis.readInt();
                this.contours[i] = new double[f0ContourLength];
                this.voiced[i] = new boolean[f0ContourLength];
                Arrays.fill(this.voiced[i], false);
                for (int j = 0; j < f0ContourLength; ++j) {
                    this.contours[i][j] = dis.readFloat();
                    if (!(this.contours[i][j] > 0.0)) continue;
                    this.voiced[i][j] = true;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Reading the Mary header from file [" + fileName + "] failed.", e);
        }
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public double[] getContour(int unitIndexNumber) {
        return this.contours[unitIndexNumber];
    }

    public boolean[] getVoicings(int unitIndexNumber) {
        return this.voiced[unitIndexNumber];
    }

    public double getWindowSizeInSeconds() {
        return this.windowSize;
    }

    public double getSkipSizeInSeconds() {
        return this.skipSize;
    }

    public double[] getIntonationCoeffs(int unitIndexNumber) {
        return this.coeffs[unitIndexNumber];
    }

    public static void main(String[] args) throws Exception {
        String fileName = "/home/sathish/Work/phd/voices/listener/vocalizations/timelines/vocalization_intonation_timeline.mry";
        VocalizationIntonationReader bcUfr = new VocalizationIntonationReader(fileName);
    }
}

