/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.Socket;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import marytts.util.MaryUtils;
import marytts.util.io.FileFilter;
import marytts.util.string.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;

public class FileUtils {
    public static void close(Socket socket, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log(Level.WARN, "Couldn't close Closeable.", ex);
            }
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log(Level.WARN, "Couldn't close Socket.", ex);
            }
        }
    }

    public static void close(PreparedStatement ps, ResultSet ... rs) {
        for (ResultSet c : rs) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log(Level.WARN, "Couldn't close ResultSet.", ex);
            }
        }
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log(Level.WARN, "Couldn't close PreparedStatement.", ex);
            }
        }
    }

    public static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (Exception ex) {
                MaryUtils.getLogger(FileUtils.class.getName()).log(Level.WARN, "Couldn't close Closeable.", ex);
            }
        }
    }

    public static String[] listBasenames(File directory, String suffix) {
        final String theSuffix = suffix;
        Object[] filenames = directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(theSuffix);
            }
        });
        Arrays.sort(filenames);
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = ((String)filenames[i]).substring(0, ((String)filenames[i]).length() - suffix.length());
        }
        return filenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getFileAsString(File file, String encoding) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = FileUtils.getStreamAsString(fis, encoding);
            return string;
        }
    }

    @Deprecated
    public static String getStreamAsString(InputStream inputStream, String encoding) throws IOException {
        return FileUtils.getReaderAsString(new InputStreamReader(inputStream, encoding));
    }

    public static String getReaderAsString(Reader reader) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        BufferedReader in = new BufferedReader(reader);
        char[] buf = new char[8192];
        while ((n = in.read(buf)) > 0) {
            sw.write(buf, 0, n);
        }
        return sw.toString();
    }

    public static byte[] getFileAsBytes(String filename) throws IOException {
        return FileUtils.getFileAsBytes(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileAsBytes(File file) throws IOException {
        byte[] byArray;
        long length;
        FileInputStream is;
        block5: {
            is = null;
            is = new FileInputStream(file);
            length = file.length();
            if (length <= Integer.MAX_VALUE) break block5;
            byte[] byArray2 = null;
            FileUtils.close(is);
            return byArray2;
        }
        try {
            int offset;
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not read file " + file.getName());
            }
            byArray = bytes;
        }
        catch (Throwable throwable) {
            FileUtils.close(is);
            throw throwable;
        }
        FileUtils.close(is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToTextFile(double[] array, String textFile) {
        FileWriter outFile = null;
        PrintWriter out = null;
        try {
            outFile = new FileWriter(textFile);
            out = new PrintWriter(outFile);
            for (int i = 0; i < array.length; ++i) {
                out.println(String.valueOf(array[i]));
            }
        }
        catch (IOException e) {
            try {
                System.out.println("Error! Cannot create file: " + textFile);
            }
            catch (Throwable throwable) {
                FileUtils.close(outFile, out);
                throw throwable;
            }
            FileUtils.close(outFile, out);
        }
        FileUtils.close(outFile, out);
    }

    public static void writeBinaryFile(short[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(short[] x, DataOutputStream d) throws IOException {
        for (int i = 0; i < x.length; ++i) {
            d.writeShort(x[i]);
        }
    }

    public static void writeBinaryFile(float[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(float[] x, DataOutputStream d) throws IOException {
        for (int i = 0; i < x.length; ++i) {
            d.writeFloat(x[i]);
        }
    }

    public static void writeBinaryFile(double[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(double[] x, DataOutputStream d) throws IOException {
        for (int i = 0; i < x.length; ++i) {
            d.writeDouble(x[i]);
        }
    }

    public static void writeBinaryFile(int[] x, String filename) throws IOException {
        DataOutputStream d = new DataOutputStream(new FileOutputStream(new File(filename)));
        d.writeInt(x.length);
        FileUtils.writeBinaryFile(x, d);
    }

    public static void writeBinaryFile(int[] x, DataOutputStream d) throws IOException {
        for (int i = 0; i < x.length; ++i) {
            d.writeInt(x[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readFromBinaryFile(String filename) throws IOException {
        int[] nArray;
        DataInputStream d = null;
        try {
            d = new DataInputStream(new FileInputStream(new File(filename)));
            int[] x = null;
            int len = d.readInt();
            if (len > 0) {
                x = new int[len];
                for (int i = 0; i < len; ++i) {
                    x[i] = d.readInt();
                }
            }
            nArray = x;
        }
        catch (Throwable throwable) {
            FileUtils.close(d);
            throw throwable;
        }
        FileUtils.close(d);
        return nArray;
    }

    public static boolean exists(String file) {
        File f;
        boolean bRet = false;
        if (file != null && (f = new File(file)).exists()) {
            bRet = true;
        }
        return bRet;
    }

    public static void delete(String file, boolean bDisplayInfo) {
        boolean bRet = false;
        File f = new File(file);
        if (f.exists()) {
            bRet = f.delete();
        }
        if (!bRet) {
            System.out.println("Unable to delete file: " + file);
        } else if (bDisplayInfo) {
            System.out.println("Deleted: " + file);
        }
    }

    public static void delete(String file) {
        if (FileUtils.exists(file)) {
            FileUtils.delete(file, false);
        }
    }

    public static void delete(String[] files, boolean bDisplayInfo) {
        for (int i = 0; i < files.length; ++i) {
            FileUtils.delete(files[i], bDisplayInfo);
        }
    }

    public static void delete(String[] files) {
        FileUtils.delete(files, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String sourceFile, String destinationFile) throws IOException {
        File dir;
        File fromFile = new File(sourceFile);
        File toFile = new File(destinationFile);
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + sourceFile);
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + sourceFile);
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + sourceFile);
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists() && !toFile.canWrite()) {
            throw new IOException("FileCopy: destination file cannot be written: " + destinationFile);
        }
        String parent = toFile.getParent();
        if (parent == null) {
            parent = System.getProperty("user.dir");
        }
        if (!(dir = new File(parent)).exists()) {
            throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
        }
        if (dir.isFile()) {
            throw new IOException("FileCopy: destination is not a directory: " + parent);
        }
        if (!dir.canWrite()) {
            throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(from, to);
            throw throwable;
        }
        FileUtils.close(from, to);
    }

    public static void copy(File source, File dest) throws IOException {
        FileChannel in = null;
        FileChannel out = null;
        try {
            System.out.println("copying: " + source + "\n    --> " + dest);
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(dest).getChannel();
            MappedByteBuffer buf = in.map(FileChannel.MapMode.READ_ONLY, 0L, in.size());
            out.write(buf);
        }
        catch (Exception e) {
            try {
                System.out.println("Error copying file " + source.getAbsolutePath() + " to " + dest.getAbsolutePath() + " : " + e.getMessage());
                throw new IOException();
            }
            catch (Throwable throwable) {
                FileUtils.close(in, out);
                throw throwable;
            }
        }
        FileUtils.close(in, out);
    }

    public static void copyFolder(String sourceFolder, String targetFolder) throws IOException {
        FileUtils.copyFolder(sourceFolder, targetFolder, false);
    }

    public static void copyFolder(String sourceFolder, String targetFolder, boolean bForceDeleteTarget) throws IOException {
        if (FileUtils.exists(sourceFolder)) {
            if (FileUtils.exists(targetFolder) && bForceDeleteTarget) {
                FileUtils.delete(targetFolder);
            }
            FileUtils.createDirectory(targetFolder);
            if (FileUtils.exists(targetFolder)) {
                String[] fileList = FileUtils.getFileList(sourceFolder, "*.*");
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        String targetFile = StringUtils.checkLastSlash(targetFolder) + StringUtils.getFileName(fileList[i], false);
                        FileUtils.copy(fileList[i], targetFile);
                    }
                }
            } else {
                System.out.println("Could not create target folder!");
            }
        } else {
            System.out.println("Source folder does not exist!");
        }
    }

    public static void copyFolderRecursive(String sourceFolder, String targetFolder, boolean bForceDeleteTarget) throws IOException {
        String fileSeparator = System.getProperty("file.separator");
        if (FileUtils.exists(sourceFolder)) {
            if (FileUtils.exists(targetFolder) && bForceDeleteTarget) {
                FileUtils.delete(targetFolder);
            }
            FileUtils.createDirectory(targetFolder);
            if (FileUtils.exists(targetFolder)) {
                String[] fileList = new File(sourceFolder).list();
                if (fileList != null) {
                    for (int i = 0; i < fileList.length; ++i) {
                        if (fileList[i].startsWith(".")) continue;
                        String source = StringUtils.checkLastSlash(sourceFolder) + fileList[i];
                        if (new File(source).isDirectory()) {
                            String newTargetFolder = StringUtils.checkLastSlash(targetFolder) + fileList[i];
                            FileUtils.copyFolderRecursive(source, newTargetFolder, bForceDeleteTarget);
                            continue;
                        }
                        String targetFile = StringUtils.checkLastSlash(targetFolder) + fileList[i];
                        FileUtils.copy(source, targetFile);
                    }
                }
            } else {
                System.out.println("Could not create target folder!");
            }
        } else {
            System.out.println("Source folder does not exist!");
        }
    }

    public static void createDirectory(String trainingBaseFolder) {
        File f = new File(trainingBaseFolder);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static boolean isDirectory(String dirName) {
        File f = new File(dirName);
        return f.isDirectory();
    }

    public static void rename(String existingFile, String newFilename) {
        if (FileUtils.exists(existingFile)) {
            File oldFile = new File(existingFile);
            oldFile.renameTo(new File(newFilename));
        }
    }

    public static void changeFileExtensions(String folder, String oldExt, String newExt) {
        String[] files = FileUtils.getFileNameList(folder, oldExt);
        folder = StringUtils.checkLastSlash(folder);
        newExt = StringUtils.checkFirstDot(newExt);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                int ind = files[i].lastIndexOf(oldExt);
                String newFile = folder + files[i].substring(0, ind) + newExt;
                FileUtils.rename(files[i], newFile);
                System.out.println("Changed extension " + String.valueOf(i + 1) + " of " + String.valueOf(files.length));
            }
        }
    }

    public static String getFileName(String fileNameWithPath) {
        int i = fileNameWithPath.lastIndexOf("/");
        String str = fileNameWithPath.substring(i + 1);
        return str;
    }

    public static String[] getFileNameList(String directory, String extension) {
        return FileUtils.getFileNameList(directory, extension, true);
    }

    public static String[] getFileNameList(String directory, String extension, boolean recurse) {
        File[] files = FileUtils.listFilesAsArray(new File(directory), new FileFilter(extension), recurse);
        String[] fileList = null;
        if (files != null && files.length > 0) {
            fileList = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileList[i] = files[i].getName();
            }
        }
        return fileList;
    }

    public static String[] getFileList(String directory, String extension) {
        return FileUtils.getFileList(directory, extension, true);
    }

    public static String[] getFileList(String directory, String extension, boolean recurse) {
        File[] files = FileUtils.listFilesAsArray(new File(directory), new FileFilter(extension), recurse);
        String[] fileList = null;
        if (files != null && files.length > 0) {
            fileList = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileList[i] = files[i].getAbsolutePath();
            }
        }
        return fileList;
    }

    public static File[] listFilesAsArray(File directory, FilenameFilter filter, boolean recurse) {
        Collection<File> files = FileUtils.listFiles(directory, filter, recurse);
        File[] arr = new File[files.size()];
        return files.toArray(arr);
    }

    public static Collection<File> listFiles(File directory, FilenameFilter filter, boolean recurse) {
        File[] entries;
        Vector<File> files = new Vector<File>();
        for (File entry : entries = directory.listFiles()) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(FileUtils.listFiles(entry, filter, recurse));
        }
        return files;
    }

    public static void writeTextFile(String[][] textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            for (int n = 0; n < textInRows.length; ++n) {
                String line = "";
                for (int i = 0; i < textInRows[n].length; ++i) {
                    line = line + textInRows[n][i] + " ";
                }
                out.println(line);
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(String[] textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            for (int i = 0; i < textInRows.length; ++i) {
                out.println(textInRows[i]);
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(Vector<String> textInRows, String textFile) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(textFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out != null) {
            for (int i = 0; i < textInRows.size(); ++i) {
                out.println(textInRows.get(i));
            }
            out.close();
        } else {
            System.out.println("Error! Cannot create file: " + textFile);
        }
    }

    public static void writeTextFile(float[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void writeTextFile(double[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void writeTextFile(double[][] x, String filename) {
        String[][] lines = new String[x.length][];
        for (int i = 0; i < x.length; ++i) {
            lines[i] = StringUtils.toStringLines(x[i]);
        }
        FileUtils.writeTextFile(lines, filename);
    }

    public static void writeTextFile(int[] x, String filename) {
        FileUtils.writeTextFile(StringUtils.toStringLines(x), filename);
    }

    public static void unzipArchive(File archive, File outputDir) throws IOException {
        ZipFile zipfile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> e = zipfile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            FileUtils.unzipEntry(zipfile, entry, outputDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            FileUtils.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            FileUtils.createDir(outputFile.getParentFile());
        }
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDir(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException("Can not create dir " + dir);
        }
    }
}

