/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class WavWriter {
    private byte[] buf = null;
    private int nBytesPerSample = 0;

    private static int byteswap(int val) {
        return ((val & 0xFF000000) >>> 24) + ((val & 0xFF0000) >>> 8) + ((val & 0xFF00) << 8) + ((val & 0xFF) << 24);
    }

    private static short byteswap(short val) {
        return (short)(((val & 0xFF00) >>> 8) + ((val & 0xFF) << 8));
    }

    private void doWrite(String fileName, int sampleRate) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        dos.writeBytes("RIFF");
        dos.writeInt(WavWriter.byteswap(36 + this.buf.length));
        dos.writeBytes("WAVEfmt ");
        dos.writeInt(WavWriter.byteswap(16));
        dos.writeShort(WavWriter.byteswap((short)1));
        dos.writeShort(WavWriter.byteswap((short)1));
        dos.writeInt(WavWriter.byteswap(sampleRate));
        dos.writeInt(WavWriter.byteswap(sampleRate * this.nBytesPerSample));
        dos.writeShort(WavWriter.byteswap((short)this.nBytesPerSample));
        dos.writeShort(WavWriter.byteswap((short)(this.nBytesPerSample * 8)));
        dos.writeBytes("data");
        dos.writeInt(WavWriter.byteswap(this.buf.length));
        dos.write(this.buf);
        dos.close();
    }

    public void export(String fileName, int sampleRate, short[] samples) throws IOException {
        this.nBytesPerSample = 2;
        this.buf = new byte[samples.length * 2];
        for (int i = 0; i < samples.length; ++i) {
            this.buf[2 * i] = (byte)((samples[i] & 0xFF00) >>> 8);
            this.buf[2 * i + 1] = (byte)(samples[i] & 0xFF);
        }
        this.doWrite(fileName, sampleRate);
    }

    public void export(String fileName, int sampleRate, byte[] samples) throws IOException {
        this.nBytesPerSample = 2;
        this.buf = new byte[samples.length];
        System.arraycopy(samples, 0, this.buf, 0, samples.length);
        byte b = 0;
        for (int j = 0; j < this.buf.length; j += 2) {
            b = this.buf[j];
            this.buf[j] = this.buf[j + 1];
            this.buf[j + 1] = b;
        }
        this.doWrite(fileName, sampleRate);
    }
}

