/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import marytts.signalproc.display.FunctionGraph;
import marytts.util.MaryUtils;

public class AudioDestination {
    private OutputStream os;
    private File f;
    private boolean ram;

    public AudioDestination(boolean isInRam) throws IOException {
        this.ram = isInRam;
        if (this.ram) {
            this.os = new ByteArrayOutputStream();
            this.f = null;
        } else {
            this.f = MaryUtils.createSelfDeletingTempFile(3600);
            this.os = new FileOutputStream(this.f);
        }
    }

    public boolean isInRam() {
        return this.ram;
    }

    public boolean isFile() {
        return !this.ram;
    }

    public void write(byte[] b) throws IOException {
        this.os.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.os.write(b, off, len);
    }

    public AudioInputStream convertToAudioInputStream(AudioFormat audioFormat) throws IOException {
        if (this.ram) {
            assert (this.os instanceof ByteArrayOutputStream);
            assert (this.f == null);
            byte[] audioData = ((ByteArrayOutputStream)this.os).toByteArray();
            return new AudioInputStream(new ByteArrayInputStream(audioData), audioFormat, audioData.length / audioFormat.getFrameSize());
        }
        assert (this.os instanceof FileOutputStream);
        assert (this.f != null);
        this.os.close();
        long byteLength = this.f.length();
        return new AudioInputStream(new FileInputStream(this.f), audioFormat, byteLength / (long)audioFormat.getFrameSize());
    }

    public AudioInputStream convertToAudioInputStream() throws IOException, UnsupportedAudioFileException {
        if (this.ram) {
            assert (this.os instanceof ByteArrayOutputStream);
            assert (this.f == null);
            byte[] audioData = ((ByteArrayOutputStream)this.os).toByteArray();
            return AudioSystem.getAudioInputStream(new ByteArrayInputStream(audioData));
        }
        assert (this.os instanceof FileOutputStream);
        assert (this.f != null);
        this.os.close();
        long byteLength = this.f.length();
        return AudioSystem.getAudioInputStream(this.f);
    }

    public static void plot(double[] x) {
        AudioDestination.plot(x, false);
    }

    public static void plot(double[] x, boolean bAutoClose) {
        AudioDestination.plot(x, bAutoClose, 3000);
    }

    public static void plot(double[] x, boolean bAutoClose, int milliSecondsToClose) {
        FunctionGraph graph = new FunctionGraph(400, 200, 0.0, 1.0, x);
        JFrame frame = graph.showInJFrame("wgt2", 500, 300, true, false);
        if (bAutoClose) {
            try {
                Thread.sleep(milliSecondsToClose);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            frame.dispose();
        }
    }
}

