/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.LinkedList;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.DoubleDataSource;

public class DatagramDoubleDataSource
extends BufferedDoubleDataSource {
    protected LinkedList<Datagram> datagrams;

    public DatagramDoubleDataSource(Datagram[] datagrams) {
        super((DoubleDataSource)null);
        this.datagrams = new LinkedList();
        this.dataLength = 0L;
        for (int i = 0; i < datagrams.length; ++i) {
            this.dataLength += datagrams[i].getDuration();
            this.datagrams.add(datagrams[i]);
        }
    }

    public DatagramDoubleDataSource(LinkedList<Datagram> datagrams) {
        super((DoubleDataSource)null);
        this.datagrams = datagrams;
        this.dataLength = 0L;
        for (Datagram d : datagrams) {
            this.dataLength += d.getDuration();
        }
    }

    @Override
    public boolean hasMoreData() {
        return this.currentlyInBuffer() > 0 || !this.datagrams.isEmpty();
    }

    @Override
    public int available() {
        int available = this.currentlyInBuffer();
        for (Datagram d : this.datagrams) {
            available = (int)((long)available + d.getDuration());
        }
        return available;
    }

    @Override
    protected boolean readIntoBuffer(int minLength) {
        int readSum;
        int read;
        if (this.bufferSpaceLeft() < minLength) {
            this.increaseBufferSize(minLength + this.currentlyInBuffer());
        } else if (this.buf.length - this.writePos < minLength) {
            this.compact();
        }
        for (readSum = 0; readSum < minLength && !this.datagrams.isEmpty(); readSum += read) {
            Datagram next = this.datagrams.removeFirst();
            int length = (int)next.getDuration();
            if (this.buf.length < this.writePos + length) {
                this.increaseBufferSize(this.writePos + length);
            }
            read = this.readDatagram(next, this.buf, this.writePos);
            this.writePos += read;
        }
        if (this.dataProcessor != null) {
            this.dataProcessor.applyInline(this.buf, this.writePos - readSum, readSum);
        }
        return readSum >= minLength;
    }

    protected int readDatagram(Datagram d, double[] target, int pos) {
        int dur = (int)d.getDuration();
        byte[] frameAudio = d.getData();
        assert (frameAudio.length / 2 == dur) : "expected datagram data length to be " + dur * 2 + ", found " + frameAudio.length;
        int i = 0;
        while (i < frameAudio.length) {
            byte lobyte = frameAudio[i + 1];
            byte hibyte = frameAudio[i];
            int sample = hibyte << 8 | lobyte & 0xFF;
            target[pos] = (double)sample / 32768.0;
            i += 2;
            ++pos;
        }
        return dur;
    }
}

