/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;
import marytts.exceptions.MaryConfigurationException;
import marytts.unitselection.data.LPCDatagram;
import marytts.unitselection.data.TimelineReader;
import marytts.util.data.Datagram;

public class LPCTimelineReader
extends TimelineReader {
    protected int lpcOrder;
    protected float lpcMin;
    protected float lpcRange;

    public LPCTimelineReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    @Override
    protected void load(String fileName) throws IOException, MaryConfigurationException {
        super.load(fileName);
        Properties props = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(this.procHdr.getString().getBytes("latin1"));
        props.load(bais);
        this.ensurePresent(props, "lpc.order");
        this.lpcOrder = Integer.parseInt(props.getProperty("lpc.order"));
        this.ensurePresent(props, "lpc.min");
        this.lpcMin = Float.parseFloat(props.getProperty("lpc.min"));
        this.ensurePresent(props, "lpc.range");
        this.lpcRange = Float.parseFloat(props.getProperty("lpc.range"));
    }

    private void ensurePresent(Properties props, String key) throws IOException {
        if (!props.containsKey(key)) {
            throw new IOException("Processing header does not contain required field '" + key + "'");
        }
    }

    public int getLPCOrder() {
        return this.lpcOrder;
    }

    public float getLPCMin() {
        return this.lpcMin;
    }

    public float getLPCRange() {
        return this.lpcRange;
    }

    @Override
    protected Datagram getNextDatagram(ByteBuffer bb) {
        LPCDatagram d = null;
        if (bb.position() == this.timeIdxBytePos) {
            return null;
        }
        try {
            d = new LPCDatagram(bb, this.lpcOrder);
        }
        catch (IOException e) {
            return null;
        }
        return d;
    }
}

