/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.tools.emospeak.JFeeltraceCircle;
import marytts.tools.emospeak.TwoDimensionalModel;

public class JFeeltracePanel
extends JPanel {
    private boolean showPower = true;
    private BoundedRangeModel powerModel = new DefaultBoundedRangeModel(0, 0, -100, 100);
    private JLabel lMinActivation;
    private JLabel lMaxEvaluation;
    private JSlider slPower;
    private JLabel lMinEvaluation;
    private JLabel lMinPower;
    private JLabel lMaxActivation;
    private JLabel lMaxPower;
    private JFeeltraceCircle jFeeltraceCircle1;

    public boolean showPower() {
        return this.showPower;
    }

    public void setShowPower(boolean showPower) {
        this.showPower = showPower;
    }

    public TwoDimensionalModel feeltraceModel() {
        return this.jFeeltraceCircle1.getNormalizedModel();
    }

    public BoundedRangeModel powerModel() {
        return this.powerModel;
    }

    public JFeeltracePanel(boolean showPower) {
        this.showPower = showPower;
        this.initComponents();
        this.customInitComponents();
    }

    public JFeeltracePanel() {
        this.initComponents();
        this.customInitComponents();
    }

    private void initComponents() {
        this.slPower = new JSlider();
        this.lMaxPower = new JLabel();
        this.lMinPower = new JLabel();
        this.lMaxActivation = new JLabel();
        this.lMinEvaluation = new JLabel();
        this.lMaxEvaluation = new JLabel();
        this.lMinActivation = new JLabel();
        this.jFeeltraceCircle1 = new JFeeltraceCircle();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 350));
        this.slPower.setMinimum(-100);
        this.slPower.setOrientation(1);
        this.slPower.setValue(0);
        this.slPower.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JFeeltracePanel.this.slPowerStateChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.slPower, gridBagConstraints);
        this.lMaxPower.setText("very dominant");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.lMaxPower, gridBagConstraints);
        this.lMinPower.setText("very submissive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.lMinPower, gridBagConstraints);
        this.lMaxActivation.setHorizontalAlignment(0);
        this.lMaxActivation.setText("very active");
        this.lMaxActivation.setVerticalAlignment(3);
        this.lMaxActivation.setAlignmentX(0.5f);
        this.lMaxActivation.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.lMaxActivation, gridBagConstraints);
        this.lMinEvaluation.setText("<html>very<br>negative</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.lMinEvaluation, gridBagConstraints);
        this.lMaxEvaluation.setText("<html>very<br>positive</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.lMaxEvaluation, gridBagConstraints);
        this.lMinActivation.setHorizontalAlignment(0);
        this.lMinActivation.setText("very passive");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 15;
        this.add((Component)this.lMinActivation, gridBagConstraints);
        this.jFeeltraceCircle1.setFont(new Font("Dialog", 0, 11));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jFeeltraceCircle1, gridBagConstraints);
    }

    private void slPowerStateChanged(ChangeEvent evt) {
        this.powerModel.setValue(this.slPower.getValue());
    }

    private void customInitComponents() {
        this.verifyPowerVisible();
        this.feeltraceModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JFeeltracePanel.this.updateFeeltraceDisplays();
            }
        });
        if (this.showPower) {
            this.powerModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JFeeltracePanel.this.updatePowerDisplays();
                }
            });
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.verifyPowerVisible();
        super.paintComponent(graphics);
    }

    public void verifyPowerVisible() {
        this.lMaxPower.setVisible(this.showPower);
        this.lMinPower.setVisible(this.showPower);
        this.slPower.setVisible(this.showPower);
    }

    private void updateFeeltraceDisplays() {
    }

    private void updatePowerDisplays() {
        this.slPower.setValue(this.powerModel.getValue());
    }
}

