/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.signalproc.sinusoidal.Sinusoid;
import marytts.signalproc.sinusoidal.SinusoidalTrack;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.util.signal.SignalProcUtils;

public class TrackGenerator {
    public static float ZERO_AMP_SHIFT_IN_SECONDS = 0.001f;
    public static int MEAN_FILTER_FREQ_AXIS = 3;
    public static int MEAN_FILTER_AMP_AXIS = 3;

    public SinusoidalTracks generateTracks(NonharmonicSinusoidalSpeechSignal sinSignal, float deltaInHz, int samplingRate) {
        int i;
        int numFrames = sinSignal.framesSins.length;
        float deltaInRadians = SignalProcUtils.hz2radian(deltaInHz, samplingRate);
        SinusoidalTracks tr = null;
        if (numFrames > 0) {
            boolean[] bSinAssigneds = null;
            for (i = 0; i < numFrames; ++i) {
                Sinusoid zeroAmpSin;
                int j;
                if (tr == null) {
                    tr = new SinusoidalTracks(sinSignal.framesSins[i].sinusoids.length, samplingRate);
                    tr.setSysAmpsAndTimes(sinSignal.framesSins);
                    for (j = 0; j < sinSignal.framesSins[i].sinusoids.length; ++j) {
                        zeroAmpSin = new Sinusoid(0.0f, sinSignal.framesSins[i].sinusoids[j].freq, 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                        tr.add(new SinusoidalTrack(sinSignal.framesSins[i].time - ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.TURNED_ON));
                        tr.tracks[tr.currentIndex].add(sinSignal.framesSins[i].time, sinSignal.framesSins[i].sinusoids[j], sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.ACTIVE);
                    }
                } else {
                    int k;
                    for (j = 0; j < tr.currentIndex + 1; ++j) {
                        if (tr.tracks[j] == null) continue;
                        tr.tracks[j].resetCandidate();
                    }
                    bSinAssigneds = new boolean[sinSignal.framesSins[i].sinusoids.length];
                    for (k = 0; k < sinSignal.framesSins[i].sinusoids.length; ++k) {
                        float minDist = Math.abs(sinSignal.framesSins[i].sinusoids[k].freq - tr.tracks[0].freqs[tr.tracks[0].currentIndex]);
                        int trackInd = minDist < deltaInRadians ? 0 : -1;
                        for (j = 1; j < tr.currentIndex + 1; ++j) {
                            float tmpDist = Math.abs(sinSignal.framesSins[i].sinusoids[k].freq - tr.tracks[j].freqs[tr.tracks[j].currentIndex]);
                            if (!(tmpDist < deltaInRadians) || trackInd != -1 && !(tmpDist < minDist)) continue;
                            minDist = tmpDist;
                            trackInd = j;
                        }
                        if (trackInd > -1) {
                            if (tr.tracks[trackInd].newCandidateInd > -1) {
                                bSinAssigneds[tr.tracks[trackInd].newCandidateInd] = false;
                            }
                            tr.tracks[trackInd].newCandidate = new Sinusoid(sinSignal.framesSins[i].sinusoids[k]);
                            tr.tracks[trackInd].newCandidateInd = k;
                            bSinAssigneds[k] = true;
                            continue;
                        }
                        bSinAssigneds[k] = false;
                    }
                    for (j = 0; j < tr.currentIndex + 1; ++j) {
                        if (tr.tracks[j].newCandidate != null) {
                            Sinusoid tmpSin = new Sinusoid(tr.tracks[j].newCandidate);
                            if (tr.tracks[j].states[tr.tracks[j].currentIndex] != SinusoidalTrack.ACTIVE) {
                                zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                                tr.tracks[j].add(sinSignal.framesSins[i].time - ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.TURNED_ON);
                            }
                            tr.tracks[j].add(sinSignal.framesSins[i].time, tmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.ACTIVE);
                            continue;
                        }
                        if (tr.tracks[j].states[tr.tracks[j].currentIndex] == SinusoidalTrack.TURNED_OFF) continue;
                        zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                        tr.tracks[j].add(sinSignal.framesSins[i].time + ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.TURNED_OFF);
                    }
                    for (k = 0; k < bSinAssigneds.length; ++k) {
                        if (bSinAssigneds[k]) continue;
                        zeroAmpSin = new Sinusoid(0.0f, sinSignal.framesSins[i].sinusoids[k].freq, 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                        tr.add(new SinusoidalTrack(sinSignal.framesSins[i].time - ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.TURNED_ON));
                        tr.tracks[tr.currentIndex].add(sinSignal.framesSins[i].time, sinSignal.framesSins[i].sinusoids[k], sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.ACTIVE);
                    }
                    System.out.println("Track generation using frame " + String.valueOf(i + 1) + " of " + String.valueOf(numFrames));
                }
                if (i != numFrames - 1) continue;
                for (j = 0; j < tr.currentIndex + 1; ++j) {
                    if (!(Math.abs(sinSignal.framesSins[i].time - tr.tracks[j].times[tr.tracks[j].totalSins - 1]) < ZERO_AMP_SHIFT_IN_SECONDS) || tr.tracks[j].states[tr.tracks[j].currentIndex] != SinusoidalTrack.ACTIVE) continue;
                    zeroAmpSin = new Sinusoid(0.0f, tr.tracks[j].freqs[tr.tracks[j].totalSins - 1], 0.0f, Sinusoid.NON_EXISTING_FRAME_INDEX);
                    tr.tracks[j].add(sinSignal.framesSins[i].time + ZERO_AMP_SHIFT_IN_SECONDS, zeroAmpSin, sinSignal.framesSins[i].maxFreqOfVoicing, SinusoidalTrack.TURNED_OFF);
                }
            }
        }
        for (i = 0; i <= tr.currentIndex; ++i) {
            tr.tracks[i].correctTrack();
        }
        tr.setOriginalDurationManual(sinSignal.originalDurationInSeconds);
        SinusoidalTracks trOut = new SinusoidalTracks(tr, 0, tr.currentIndex);
        trOut = TrackGenerator.postProcess(trOut);
        return trOut;
    }

    public static SinusoidalTracks postProcess(SinusoidalTracks st) {
        for (int i = 0; i < st.totalTracks; ++i) {
            if (st.tracks[i].totalSins <= 20) continue;
            st.tracks[i].freqs = SignalProcUtils.meanFilter(st.tracks[i].freqs, MEAN_FILTER_FREQ_AXIS);
            st.tracks[i].amps = SignalProcUtils.meanFilter(st.tracks[i].amps, MEAN_FILTER_AMP_AXIS);
        }
        return st;
    }
}

