/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.effects;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.htsengine.HMMVoice;
import marytts.modules.synthesis.Voice;
import marytts.signalproc.effects.AudioEffect;
import marytts.signalproc.effects.AudioEffects;
import marytts.signalproc.effects.BaseAudioEffect;
import marytts.signalproc.effects.ChorusEffectBase;
import marytts.signalproc.effects.FilterEffectBase;
import marytts.signalproc.effects.HMMDurationScaleEffect;
import marytts.signalproc.effects.HMMF0AddEffect;
import marytts.signalproc.effects.HMMF0ScaleEffect;
import marytts.signalproc.effects.JetPilotEffect;
import marytts.signalproc.effects.LpcWhisperiserEffect;
import marytts.signalproc.effects.RobotiserEffect;
import marytts.signalproc.effects.StadiumEffect;
import marytts.signalproc.effects.VocalTractLinearScalerEffect;
import marytts.signalproc.effects.VolumeEffect;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;
import marytts.util.string.StringUtils;

public class EffectsApplier {
    public BaseAudioEffect[] audioEffects;
    public int[] optimumEffectIndices;
    public static char chEffectSeparator = (char)43;
    private ArrayList<String> optimumOrderedEffectNames;

    public EffectsApplier() {
        this.getOptimizedEffectOrdering();
    }

    public AudioInputStream apply(AudioInputStream input, String param) {
        AudioFormat audioformat = input.getFormat();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(input);
        DoubleDataSource tmpSignal = null;
        this.parseEffectsAndParams(param, (int)audioformat.getSampleRate());
        boolean bFirstEffect = true;
        if (this.audioEffects != null) {
            for (int i = 0; i < this.audioEffects.length; ++i) {
                int index = this.optimumEffectIndices != null && this.optimumEffectIndices[i] >= 0 && this.optimumEffectIndices[i] < this.audioEffects.length ? this.optimumEffectIndices[i] : i;
                if (this.audioEffects[index] == null) continue;
                if (bFirstEffect) {
                    if (this.audioEffects[index] == null) continue;
                    tmpSignal = this.audioEffects[index].apply(signal);
                    bFirstEffect = false;
                    continue;
                }
                if (this.audioEffects[index] == null) continue;
                tmpSignal = this.audioEffects[index].apply(tmpSignal);
            }
            if (tmpSignal != null) {
                if (tmpSignal.getDataLength() == -1L) {
                    double[] data = tmpSignal.getAllData();
                    tmpSignal = new BufferedDoubleDataSource(data);
                }
                assert (tmpSignal.getDataLength() != -1L);
                return new DDSAudioInputStream(tmpSignal, audioformat);
            }
            return input;
        }
        return input;
    }

    public void parseEffectsAndParams(String param) {
        this.parseEffectsAndParams(param, 16000);
    }

    public void parseEffectsAndParams(String param, int samplingRate) {
        this.audioEffects = null;
        this.optimumEffectIndices = null;
        if (param != null && param.length() > 0) {
            param = StringUtils.deblank(param);
            int[] effectInds = StringUtils.find(param, chEffectSeparator);
            int numEffects = 0;
            if (effectInds != null) {
                numEffects = effectInds.length;
                if (effectInds[effectInds.length - 1] != param.length()) {
                    ++numEffects;
                }
            } else if (param.length() != 0) {
                numEffects = 1;
            }
            if (numEffects > 0) {
                int i;
                int totalNonEmptyEffects = 0;
                String[] strEffectNames = new String[numEffects];
                String[] strParamsAlls = new String[numEffects];
                for (i = 0; i < numEffects; ++i) {
                    String strParams;
                    String strEffectName = i == 0 ? (numEffects == 1 || effectInds == null ? param : param.substring(0, effectInds[0])) : (effectInds == null ? param : (i < effectInds.length ? param.substring(effectInds[i - 1] + 1, effectInds[i]) : param.substring(effectInds[i - 1] + 1, param.length())));
                    strEffectName = StringUtils.deblank(strEffectName);
                    if (strEffectName != null && strEffectName != "") {
                        int[] paramInds = StringUtils.find(strEffectName, BaseAudioEffect.chEffectParamStart);
                        if (paramInds != null) {
                            int stParam = MathUtils.max(paramInds);
                            paramInds = StringUtils.find(strEffectName, BaseAudioEffect.chEffectParamEnd);
                            if (paramInds != null) {
                                int enParam = MathUtils.min(paramInds);
                                strParams = strEffectName.substring(stParam + 1, enParam);
                                strParams = StringUtils.deblank(strParams);
                            } else {
                                strParams = "";
                            }
                            strEffectName = strEffectName.substring(0, stParam);
                            strEffectName = StringUtils.deblank(strEffectName);
                        } else {
                            strParams = "";
                        }
                    } else {
                        strParams = "";
                    }
                    if (strEffectName == null || strEffectName == "") continue;
                    strEffectNames[i] = strEffectName;
                    strParamsAlls[i] = strParams;
                    ++totalNonEmptyEffects;
                }
                int index = 0;
                if (totalNonEmptyEffects > 0) {
                    this.audioEffects = new BaseAudioEffect[totalNonEmptyEffects];
                    for (i = 0; i < numEffects; ++i) {
                        if (!this.isEffectAvailable(strEffectNames[i])) continue;
                        if (index >= totalNonEmptyEffects) break;
                        this.audioEffects[index] = this.string2AudioEffect(strEffectNames[i], samplingRate);
                        this.audioEffects[index].setName(strEffectNames[i]);
                        this.audioEffects[index].setParams(strParamsAlls[i]);
                        ++index;
                    }
                    this.optimizeEffectsOrdering();
                } else {
                    this.audioEffects = null;
                    this.optimumEffectIndices = null;
                }
            } else {
                this.audioEffects = null;
                this.optimumEffectIndices = null;
            }
        }
    }

    public BaseAudioEffect string2AudioEffect(String strEffectName, int samplingRate) {
        if (strEffectName.compareToIgnoreCase("Volume") == 0) {
            return new VolumeEffect();
        }
        if (strEffectName.compareToIgnoreCase("Robot") == 0) {
            return new RobotiserEffect(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("Chorus") == 0) {
            return new ChorusEffectBase(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("Stadium") == 0) {
            return new StadiumEffect(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("FIRFilter") == 0) {
            return new FilterEffectBase(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("JetPilot") == 0) {
            return new JetPilotEffect(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("Whisper") == 0) {
            return new LpcWhisperiserEffect(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("TractScaler") == 0) {
            return new VocalTractLinearScalerEffect(samplingRate);
        }
        if (strEffectName.compareToIgnoreCase("F0Add") == 0) {
            return new HMMF0AddEffect();
        }
        if (strEffectName.compareToIgnoreCase("F0Scale") == 0) {
            return new HMMF0ScaleEffect();
        }
        if (strEffectName.compareToIgnoreCase("Rate") == 0) {
            return new HMMDurationScaleEffect();
        }
        return null;
    }

    public boolean isEffectAvailable(String effectName) {
        boolean returnVal = false;
        if (effectName != null && effectName != "") {
            if (this.optimumOrderedEffectNames != null) {
                Iterator<String> it = this.optimumOrderedEffectNames.iterator();
                while (it.hasNext()) {
                    if (effectName.compareToIgnoreCase(it.next()) != 0) continue;
                    returnVal = true;
                    break;
                }
            } else {
                returnVal = true;
            }
        }
        return returnVal;
    }

    public void getOptimizedEffectOrdering() {
        this.optimumOrderedEffectNames = new ArrayList();
        for (AudioEffect effect : AudioEffects.getEffects()) {
            this.optimumOrderedEffectNames.add(effect.getName());
        }
    }

    public void optimizeEffectsOrdering() {
        if (this.optimumOrderedEffectNames != null && this.optimumOrderedEffectNames.size() > 0 && this.audioEffects != null && this.audioEffects.length > 0) {
            this.optimumEffectIndices = new int[this.audioEffects.length];
            int index = -1;
            boolean bBroke = false;
            block0: for (String tmpName : this.optimumOrderedEffectNames) {
                for (int i = 0; i < this.audioEffects.length; ++i) {
                    if (this.audioEffects[i] == null || this.audioEffects[i].getName() != tmpName) continue;
                    if (++index > this.audioEffects.length - 1) {
                        bBroke = true;
                        continue block0;
                    }
                    this.optimumEffectIndices[index] = i;
                }
            }
        } else {
            this.optimumEffectIndices = null;
        }
    }

    public void setHMMEffectParameters(Voice voice, String currentEffect) {
        if (voice instanceof HMMVoice) {
            HMMF0AddEffect dummy1 = new HMMF0AddEffect();
            HMMF0ScaleEffect dummy2 = new HMMF0ScaleEffect();
            HMMDurationScaleEffect dummy3 = new HMMDurationScaleEffect();
            ((HMMVoice)voice).setF0Mean(HMMF0AddEffect.NO_MODIFICATION);
            ((HMMVoice)voice).setF0Std(HMMF0ScaleEffect.NO_MODIFICATION);
            ((HMMVoice)voice).setDurationScale(HMMDurationScaleEffect.NO_MODIFICATION);
            this.parseEffectsAndParams(currentEffect);
            if (this.audioEffects != null) {
                for (int i = 0; i < this.audioEffects.length; ++i) {
                    if (this.audioEffects[i] instanceof HMMF0AddEffect) {
                        ((HMMVoice)voice).setF0Mean(((HMMF0AddEffect)this.audioEffects[i]).f0Add);
                        continue;
                    }
                    if (this.audioEffects[i] instanceof HMMF0ScaleEffect) {
                        ((HMMVoice)voice).setF0Std(((HMMF0ScaleEffect)this.audioEffects[i]).f0Scale);
                        continue;
                    }
                    if (!(this.audioEffects[i] instanceof HMMDurationScaleEffect)) continue;
                    ((HMMVoice)voice).setDurationScale(((HMMDurationScaleEffect)this.audioEffects[i]).durScale);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        EffectsApplier e = new EffectsApplier();
        String strEffectsAndParams = "Robot(amount=100)+Chorus(delay1=866, amp1=0.24, delay2=300, amp2=-0.40,)";
        AudioInputStream input = AudioSystem.getAudioInputStream(new File(args[0]));
        AudioInputStream output = e.apply(input, strEffectsAndParams);
        AudioSystem.write(output, AudioFileFormat.Type.WAVE, new File(args[1]));
    }
}

