/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.signalproc.analysis.RegularizedCepstrumEstimator;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class RegularizedPreWarpedCepstrumEstimator
extends RegularizedCepstrumEstimator {
    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, double[] weights, double lambda) {
        return RegularizedPreWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, true, weights, lambda);
    }

    public static float[] freqsLinearAmps2cepstrum(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder) {
        return RegularizedPreWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, true, null, 5.0E-4);
    }

    public static double[] cepstrum2logAmpHalfSpectrum(float[] ceps, int fftSize, int samplingRateInHz) {
        return RegularizedPreWarpedCepstrumEstimator.cepstrum2logAmpHalfSpectrum(ceps, fftSize, samplingRateInHz, true);
    }

    public static double cepstrum2linearSpectrumValue(float[] ceps, double freqInHz, int samplingRateInHz) {
        return MathUtils.db2amp(RegularizedPreWarpedCepstrumEstimator.cepstrum2dbSpectrumValue(ceps, freqInHz, samplingRateInHz));
    }

    public static double cepstrum2dbSpectrumValue(float[] ceps, double freqInHz, int samplingRateInHz) {
        int p = ceps.length - 1;
        double denum = 2.0 * SignalProcUtils.freq2barkNew(0.5 * (double)samplingRateInHz);
        double f = SignalProcUtils.freq2barkNew(freqInHz) / denum;
        double val = ceps[0];
        for (int i = 1; i <= p; ++i) {
            val += 2.0 * (double)ceps[i] * Math.cos(Math.PI * 2 * f * (double)i);
        }
        return val;
    }

    public static double[] cepstrum2dbSpectrumValues(float[] ceps, int maxFreqIndex, int samplingRateInHz) {
        double[] freqsInHz = new double[maxFreqIndex + 1];
        for (int i = 0; i <= maxFreqIndex; ++i) {
            freqsInHz[i] = SignalProcUtils.index2freq(i, samplingRateInHz, maxFreqIndex);
        }
        return RegularizedPreWarpedCepstrumEstimator.cepstrum2dbSpectrumValues(ceps, freqsInHz, samplingRateInHz);
    }

    public static double[] cepstrum2dbSpectrumValues(float[] ceps, double[] freqsInHz, int samplingRateInHz) {
        double[] vals = new double[freqsInHz.length];
        for (int i = 0; i < freqsInHz.length; ++i) {
            vals[i] = RegularizedPreWarpedCepstrumEstimator.cepstrum2dbSpectrumValue(ceps, freqsInHz[i], samplingRateInHz);
        }
        return vals;
    }

    public static double[][] precomputeM(double[] freqsInHz, int samplingRateInHz, int cepsOrder) {
        return RegularizedPreWarpedCepstrumEstimator.precomputeM(freqsInHz, samplingRateInHz, cepsOrder, true);
    }

    public static double[] spectralEnvelopeLinear(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder) {
        return RegularizedPreWarpedCepstrumEstimator.spectralEnvelopeLinear(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, SignalProcUtils.getDFTSize(samplingRateInHz));
    }

    public static double[] spectralEnvelopeLinear(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, int fftSize) {
        return MathUtils.db2amp(RegularizedPreWarpedCepstrumEstimator.spectralEnvelopeDB(linearAmps, freqsInHz, samplingRateInHz, cepsOrder, fftSize));
    }

    public static double[] spectralEnvelopeDB(double[] linearAmps, double[] freqsInHz, int samplingRateInHz, int cepsOrder, int fftSize) {
        float[] ceps = RegularizedPreWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, cepsOrder);
        return RegularizedPreWarpedCepstrumEstimator.cepstrum2logAmpHalfSpectrum(ceps, fftSize, samplingRateInHz);
    }
}

