/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.Defaults;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.window.DynamicWindow;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.StreamUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class LsfAnalyser {
    static int mpy = 0;
    static int add = 0;
    static int ptr = 0;

    public static double[] lpc2lsfInHz(double[] oneMinusA, int samplingRate) {
        return LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate, 4);
    }

    public static double[] lpc2lsfInHz(double[] oneMinusA, int samplingRate, int type) {
        double[] lsp = LsfAnalyser.lpc2lsf(oneMinusA, type);
        int i = 0;
        while (i < lsp.length) {
            int n = i++;
            lsp[n] = lsp[n] * (double)samplingRate;
        }
        return lsp;
    }

    public static double[] lpc2lsfInBark(double[] oneMinusA, int samplingRate) {
        return SignalProcUtils.freq2bark(LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate));
    }

    public static double[] lpc2lsfInBark(double[] oneMinusA, int samplingRate, int type) {
        return SignalProcUtils.freq2bark(LsfAnalyser.lpc2lsfInHz(oneMinusA, samplingRate, type));
    }

    public static double[] lpc2lsf(double[] oneMinusA, int type) {
        double Factor;
        int i;
        int g2_order;
        boolean even;
        int order = oneMinusA.length - 1;
        double[] g1 = new double[100];
        double[] g2 = new double[100];
        double[] g1r = new double[100];
        double[] g2r = new double[100];
        boolean bl = even = (order & 1) == 0;
        if (!even) {
            int g1_order = (order + 1) / 2;
            int g2_order2 = g1_order - 1;
            throw new IllegalArgumentException("Odd order not implemented yet");
        }
        int g1_order = g2_order = order / 2;
        int orderd2 = (order + 1) / 2;
        g1[orderd2] = oneMinusA[0];
        for (i = 1; i <= orderd2; ++i) {
            g1[g1_order - i] = oneMinusA[i] + oneMinusA[order + 1 - i];
        }
        g2[orderd2] = oneMinusA[0];
        for (i = 1; i <= orderd2; ++i) {
            g2[orderd2 - i] = oneMinusA[i] - oneMinusA[order + 1 - i];
        }
        if (even) {
            for (i = 1; i <= orderd2; ++i) {
                int n = orderd2 - i;
                g1[n] = g1[n] - g1[orderd2 - i + 1];
            }
            for (i = 1; i <= orderd2; ++i) {
                int n = orderd2 - i;
                g2[n] = g2[n] + g2[orderd2 - i + 1];
            }
        } else {
            for (i = 2; i <= orderd2; ++i) {
                int n = orderd2 - i;
                g2[n] = g2[n] + g2[orderd2 - i + 2];
            }
        }
        if (type == 1) {
            LsfAnalyser.cheby1(g1, g1_order);
            LsfAnalyser.cheby1(g2, g2_order);
            Factor = 0.5;
        } else if (type == 2) {
            LsfAnalyser.cheby2(g1, g1_order);
            LsfAnalyser.cheby2(g2, g2_order);
            Factor = 0.5;
        } else if (type == 3) {
            LsfAnalyser.cheby3(g1, g1_order);
            LsfAnalyser.cheby3(g2, g2_order);
            Factor = 1.0;
        } else if (type == 4) {
            LsfAnalyser.kw(g1, g1_order);
            LsfAnalyser.kw(g2, g2_order);
            Factor = 0.5;
        } else {
            throw new IllegalArgumentException("valid type values are 1 to 4.\n");
        }
        LsfAnalyser.cacm283(g1, g1_order, g1r);
        LsfAnalyser.cacm283(g2, g2_order, g2r);
        double[] lsp = new double[order];
        i = 0;
        int j = 0;
        while (true) {
            lsp[j++] = Math.acos(Factor * g1r[i]) / (Math.PI * 2);
            if (j >= order) break;
            lsp[j++] = Math.acos(Factor * g2r[i]) / (Math.PI * 2);
            if (j >= order) break;
            ++i;
        }
        return lsp;
    }

    static void cheby1(double[] g, int ord) {
        for (int i = 2; i <= ord; ++i) {
            int j;
            for (j = ord; j > i; --j) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
            }
            int n = j - 2;
            g[n] = g[n] - 2.0 * g[j];
            ++mpy;
            ++add;
        }
    }

    static void cheby2(double[] g, int ord) {
        g[0] = g[0] * 0.5;
        ++mpy;
        for (int i = 2; i <= ord; ++i) {
            for (int j = ord; j >= i; --j) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
            }
            int n = i - 1;
            g[n] = g[n] * 0.5;
            ++mpy;
        }
        int n = ord;
        g[n] = g[n] * 0.5;
        ++mpy;
    }

    static void cheby3(double[] g, int ord) {
        g[0] = g[0] * 0.5;
        ++mpy;
        for (int i = 2; i <= ord; ++i) {
            for (int j = ord; j >= i; --j) {
                int n = j - 2;
                g[n] = g[n] - g[j];
                ++add;
                int n2 = j;
                g[n2] = g[n2] + g[j];
                ++add;
            }
        }
    }

    static void kw(double[] r, int n) {
        int k;
        int i;
        double[] s = new double[100];
        double[] c = new double[100];
        s[0] = 1.0;
        s[1] = -2.0;
        s[2] = 2.0;
        for (i = 3; i <= n / 2; ++i) {
            s[i] = s[i - 2];
        }
        for (k = 0; k <= n; ++k) {
            c[k] = r[k];
            int j = 1;
            for (i = k + 2; i <= n; i += 2) {
                int n2 = k;
                c[n2] = c[n2] + s[j] * r[i];
                ++mpy;
                ++add;
                int n3 = j;
                s[n3] = s[n3] - s[j - 1];
                ++add;
                ++j;
                ++ptr;
            }
        }
        for (k = 0; k <= n; ++k) {
            r[k] = c[k];
        }
    }

    static void cacm283(double[] a, int ord, double[] r) {
        int swap;
        int i;
        for (i = 0; i < ord; ++i) {
            r[i] = 2.0 * ((double)i + 0.5) / (double)ord - 1.0;
        }
        double error = 1.0;
        while (error > 1.0E-12) {
            error = 0.0;
            i = 0;
            while (i < ord) {
                double rooti = r[i];
                double val = a[ord];
                double p = a[ord];
                for (int k = ord - 1; k >= 0; --k) {
                    val = val * rooti + a[k];
                    if (k == i) continue;
                    p *= rooti - r[k];
                }
                double delta = val / p;
                int n = i++;
                r[n] = r[n] - delta;
                error += delta * delta;
            }
        }
        do {
            swap = 0;
            for (i = 0; i < ord - 1; ++i) {
                if (!(r[i] < r[i + 1])) continue;
                double tmplsp = r[i];
                r[i] = r[i + 1];
                r[i + 1] = tmplsp;
                ++swap;
            }
        } while (swap > 0);
    }

    public static void main2(String[] argv) {
        int i;
        double[] awc = new double[]{1.0, 0.1077, -0.0424, 0.1737, -0.0278, 0.1759, -0.199, -0.0333, -0.1904, 0.0759, 0.0278, -0.0568, -0.1325, 0.001, -0.001, 0.001, -0.001, 0.001, -5.0E-4, 0.001, -0.001, 0.001, -0.001, 0.001, 2.0E-4};
        double[] a = new double[25];
        double[] lsp = new double[24];
        int type = 0;
        int ord = 12;
        if (argv.length < 1) {
            System.err.println("command: al2sp type order\n");
            System.err.println("type is 1 to 4\n");
            System.err.println("order is 2 to 24\n");
            System.exit(2);
        }
        if (argv.length >= 1) {
            type = Integer.parseInt(argv[0]);
        }
        if (argv.length >= 2) {
            ord = Integer.parseInt(argv[1]);
        }
        if (ord > 24) {
            throw new IllegalArgumentException("Model order is 24 max.\n");
        }
        a[0] = 1.0;
        for (i = 1; i <= ord; ++i) {
            a[i] = -awc[i];
        }
        lsp = LsfAnalyser.lpc2lsf(a, type);
        for (i = 0; i < ord; ++i) {
            System.out.println(i + ": " + lsp[i]);
        }
        System.out.println("mpy " + mpy + " add " + add + " ptr " + ptr);
    }

    public static double[] lsfInHz2lpc(double[] lsf, int samplingRate) {
        double[] normalised_lsf = new double[lsf.length];
        for (int i = 0; i < lsf.length; ++i) {
            normalised_lsf[i] = lsf[i] / (double)samplingRate;
            assert (0.0 <= normalised_lsf[i]);
            assert (normalised_lsf[i] <= 0.5);
        }
        return LsfAnalyser.lsf2lpc(normalised_lsf);
    }

    public static double[] lsfInBark2lpc(double[] lsfsInBark, int samplingRate) {
        return LsfAnalyser.lsfInHz2lpc(SignalProcUtils.bark2freq(lsfsInBark, samplingRate), samplingRate);
    }

    public static double[] lsf2lpc(double[] lsf) {
        int i;
        MathUtils.quickSort(lsf);
        int P = lsf.length;
        int half_order = P / 2;
        double[] a = new double[P / 2 + 1];
        double[] a1 = new double[P / 2 + 1];
        double[] a2 = new double[P / 2 + 1];
        double[] b = new double[P / 2 + 1];
        double[] b1 = new double[P / 2 + 1];
        double[] b2 = new double[P / 2 + 1];
        double[] p = new double[P / 2];
        double[] q = new double[P / 2];
        double[] oneMinusA = new double[P + 1];
        oneMinusA[0] = 1.0;
        if (lsf[0] <= 0.0 || lsf[0] >= 0.5) {
            throw new IllegalArgumentException("LSFs out of bounds; lsf[0] = " + lsf[0]);
        }
        for (i = 1; i < P; ++i) {
            if (lsf[i] <= lsf[i - 1]) {
                throw new IllegalArgumentException("nonmonotonic LSFs");
            }
            if (!(lsf[i] <= 0.0) && !(lsf[i] >= 0.5)) continue;
            throw new IllegalArgumentException("LSFs out of bounds; lsf[" + i + "] = " + lsf[i]);
        }
        for (i = 0; i < half_order; ++i) {
            p[i] = -2.0 * Math.cos(Math.PI * 2 * lsf[2 * i]);
            q[i] = -2.0 * Math.cos(Math.PI * 2 * lsf[2 * i + 1]);
        }
        double xf = 0.0;
        for (i = 0; i <= P; ++i) {
            double xx = i == 0 ? 1.0 : 0.0;
            a[0] = xx + xf;
            b[0] = xx - xf;
            xf = xx;
            for (int j = 0; j < half_order; ++j) {
                a[j + 1] = a[j] + p[j] * a1[j] + a2[j];
                b[j + 1] = b[j] + q[j] * b1[j] + b2[j];
                a2[j] = a1[j];
                a1[j] = a[j];
                b2[j] = b1[j];
                b1[j] = b[j];
            }
            if (i <= 0) continue;
            oneMinusA[i] = 0.5 * (a[half_order] + b[half_order]);
        }
        return oneMinusA;
    }

    public static double[][] lsfAnalyzeWavFile(String wavFile, LsfFileHeader params) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(wavFile));
        params.samplingRate = (int)inputAudio.getFormat().getSampleRate();
        int ws = (int)Math.floor((double)(params.winsize * (float)params.samplingRate) + 0.5);
        int ss = (int)Math.floor((double)(params.skipsize * (float)params.samplingRate) + 0.5);
        if (params.dimension < 1) {
            params.dimension = SignalProcUtils.getLPOrder(params.samplingRate);
        }
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        double[] frm = new double[ws];
        int numfrm = (int)Math.floor((double)(x.length - ws) / (double)ss + 0.5);
        params.numfrm = numfrm > 0 ? numfrm : 0;
        double[][] lsfs = new double[params.numfrm][params.dimension];
        for (int i = 0; i < params.numfrm; ++i) {
            Arrays.fill(frm, 0.0);
            System.arraycopy(x, i * ss, frm, 0, Math.min(ws, x.length - i * ss));
            lsfs[i] = LsfAnalyser.nonPreemphasizedFrame2LsfsInHz(frm, params.dimension, params.samplingRate, params.windowType, params.preCoef);
            if (!params.isBarkScaled) continue;
            lsfs[i] = SignalProcUtils.freq2bark(lsfs[i]);
        }
        return lsfs;
    }

    public static double[] nonPreemphasizedFrame2Lpcs(double[] nonPreemphasizedFrame, int dimension, int samplingRate, int windowType, float preCoef) {
        double[] preemphasizedFrame = SignalProcUtils.applyPreemphasis(nonPreemphasizedFrame, preCoef);
        return LsfAnalyser.preemphasizedFrame2Lpcs(preemphasizedFrame, dimension, samplingRate, windowType);
    }

    public static double[] preemphasizedFrame2Lpcs(double[] preemphasizedFrame, int dimension, int samplingRate, int windowType) {
        DynamicWindow window = new DynamicWindow(windowType);
        double[] wgt = window.values(preemphasizedFrame.length);
        double[] windowedAndPreemphasizedFrame = new double[preemphasizedFrame.length];
        for (int j = 0; j < preemphasizedFrame.length; ++j) {
            windowedAndPreemphasizedFrame[j] = preemphasizedFrame[j] * wgt[j];
        }
        return LsfAnalyser.windowedAndPreemphasizedFrame2Lpcs(windowedAndPreemphasizedFrame, dimension, samplingRate);
    }

    public static double[] windowedAndPreemphasizedFrame2Lpcs(double[] windowedAndPreemphasizedFrame, int dimension, int samplingRate) {
        LpcAnalyser.LpCoeffs l = LpcAnalyser.calcLPC(windowedAndPreemphasizedFrame, dimension);
        return l.getOneMinusA();
    }

    public static double[] nonPreemphasizedFrame2LsfsInHz(double[] nonPreemphasizedFrame, int dimension, int samplingRate, int windowType, float preCoef) {
        double[] preemphasizedFrame = SignalProcUtils.applyPreemphasis(nonPreemphasizedFrame, preCoef);
        return LsfAnalyser.preemphasizedFrame2LsfsInHz(preemphasizedFrame, dimension, samplingRate, windowType);
    }

    public static double[] preemphasizedFrame2LsfsInHz(double[] preemphasizedFrame, int dimension, int samplingRate, int windowType) {
        DynamicWindow window = new DynamicWindow(windowType);
        double[] wgt = window.values(preemphasizedFrame.length);
        double[] windowedAndPreemphasizedFrame = new double[preemphasizedFrame.length];
        for (int j = 0; j < windowedAndPreemphasizedFrame.length; ++j) {
            windowedAndPreemphasizedFrame[j] = preemphasizedFrame[j] * wgt[j];
        }
        return LsfAnalyser.windowedAndPreemphasizedFrame2LsfsInHz(windowedAndPreemphasizedFrame, dimension, samplingRate);
    }

    public static double[] windowedAndPreemphasizedFrame2LsfsInHz(double[] windowedAndPreemphasizedFrame, int dimension, int samplingRate) {
        double[] lpcs = LsfAnalyser.windowedAndPreemphasizedFrame2Lpcs(windowedAndPreemphasizedFrame, dimension, samplingRate);
        return LsfAnalyser.lpc2lsfInHz(lpcs, samplingRate);
    }

    public static void lsfAnalyzeWavFile(String wavFileIn, String lsfFileOut, LsfFileHeader params) throws IOException {
        double[][] lsfs = null;
        try {
            lsfs = LsfAnalyser.lsfAnalyzeWavFile(wavFileIn, params);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        if (lsfs != null) {
            params.numfrm = lsfs.length;
            LsfAnalyser.writeLsfFile(lsfs, lsfFileOut, params);
        } else {
            params.numfrm = 0;
        }
    }

    public static void writeLsfFile(double[][] lsfs, String lsfFileOut, LsfFileHeader params) throws IOException {
        params.numfrm = lsfs.length;
        DataOutputStream stream = params.writeHeader(lsfFileOut, true);
        LsfAnalyser.writeLsfs(stream, lsfs);
    }

    public static void writeLsfs(DataOutputStream stream, double[][] lsfs) throws IOException {
        if (stream != null && lsfs != null && lsfs.length > 0) {
            for (int i = 0; i < lsfs.length; ++i) {
                StreamUtils.writeDoubleArray(stream, lsfs[i]);
            }
            stream.close();
        }
    }

    public static double[][] readLsfFile(String lsfFile) throws IOException {
        LsfFileHeader params = new LsfFileHeader();
        DataInputStream stream = params.readHeader(lsfFile, true);
        return LsfAnalyser.readLsfs(stream, params);
    }

    public static double[][] readLsfs(DataInputStream stream, LsfFileHeader params) throws IOException {
        Object lsfs = null;
        if (stream != null && params.numfrm > 0 && params.dimension > 0) {
            lsfs = new double[params.numfrm][];
            for (int i = 0; i < ((double[][])lsfs).length; ++i) {
                lsfs[i] = StreamUtils.readDoubleArray(stream, params.dimension);
            }
            stream.close();
        }
        return lsfs;
    }

    public static void main(String[] args) throws Exception {
        int p;
        int windowSize = Defaults.getWindowSize();
        int windowType = Defaults.getWindowType();
        int fftSize = Defaults.getFFTSize();
        int frameShift = Defaults.getFrameShift();
        int pre = p = Integer.getInteger("signalproc.lpcorder", 24).intValue();
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        LpcAnalyser lpcAnalyser = new LpcAnalyser((DoubleDataSource)signal, windowSize, frameShift, samplingRate);
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = lpcAnalyser.analyseAllFrames();
        for (int i = 0; i < results.length; ++i) {
            System.out.println("Line spectral frequencies for frame " + i + ":");
            double[] lpc = ((LpcAnalyser.LpCoeffs)results[i].get()).getOneMinusA();
            double[] lsf = LsfAnalyser.lpc2lsf(lpc, 4);
            for (int j = 0; j < lsf.length; ++j) {
                System.out.println(j + ": " + lsf[j] + " = " + lsf[j] * (double)samplingRate);
            }
            double[] lpc_reconstructed = LsfAnalyser.lsf2lpc(lsf);
            System.out.println("LPC coefficients (orig/reconstructed from LSF):");
            for (int j = 0; j < lpc.length; ++j) {
                System.out.println(lpc[j] + " " + lpc_reconstructed[j]);
            }
        }
    }
}

