/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.ReflectionCoefficients;
import marytts.util.data.ESTTrackReader;
import marytts.util.data.ESTTrackWriter;

public class Lprefc2Lpc {
    private static float[][] convertData(float[][] lprefc) {
        int lpcOrder = lprefc[0].length;
        double[] k = new double[lpcOrder];
        double[] a = new double[lpcOrder + 1];
        float[][] lpc = new float[lprefc.length][lpcOrder + 1];
        for (int i = 0; i < lprefc.length; ++i) {
            int j;
            for (j = 0; j < lpcOrder; ++j) {
                k[j] = lprefc[i][j];
            }
            a = ReflectionCoefficients.lprefc2lpc(k);
            lpc[i][0] = 1.0f;
            for (j = 1; j <= lpcOrder; ++j) {
                lpc[i][j] = (float)a[j];
            }
        }
        return lpc;
    }

    public static void convert(String inFileName, String outFileName) throws IOException {
        ESTTrackReader etr = new ESTTrackReader(inFileName);
        float[][] lpc = Lprefc2Lpc.convertData(etr.getFrames());
        ESTTrackWriter etw = new ESTTrackWriter(etr.getTimes(), lpc, "lpc");
        etw.doWriteAndClose(outFileName, etr.isBinary(), etr.isBigEndian());
    }

    public static void main(String[] args) throws IOException {
        Lprefc2Lpc.convert(args[0], args[1]);
    }
}

