/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import marytts.signalproc.adaptation.BaselineParams;
import marytts.signalproc.adaptation.prosody.ProsodyTransformerParams;
import marytts.signalproc.analysis.EnergyFileHeader;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.signalproc.analysis.PitchFileHeader;

public class BaselineTransformerParams
extends BaselineParams {
    public String inputFolder;
    public String outputBaseFolder;
    public String outputFolder;
    public String outputFolderInfoString;
    public boolean isSourceToTarget;
    public boolean isDisplayProcessingFrameCount;
    public ProsodyTransformerParams prosodyParams;
    public LsfFileHeader lsfParams;
    public PitchFileHeader ptcParams;
    public EnergyFileHeader energyParams;
    public MfccFileHeader mfccParams;
    public boolean isForcedAnalysis;
    public boolean isVocalTractTransformation;
    public boolean isSeparateProsody;
    public boolean isSaveVocalTractOnlyVersion;
    public boolean isFixedRateVocalTractConversion;
    public boolean isTemporalSmoothing;
    public int smoothingMethod;
    public int smoothingNumNeighbours;
    public int smoothingState;
    public String smoothedVocalTractFile;
    public boolean isSourceVocalTractSpectrumFromModel;
    public boolean isResynthesizeVocalTractFromSourceModel;
    public boolean isVocalTractMatchUsingTargetModel;
    public boolean isLsfsFromTargetFile;
    public String pitchMappingFile;
    public boolean isPitchFromTargetFile;
    public int pitchFromTargetMethod;
    public boolean isDurationFromTargetFile;
    public int durationFromTargetMethod;
    public boolean isEnergyFromTargetFile;
    public int targetAlignmentFileType;
    public static final int LABELS = 1;
    public static final int FESTIVAL_UTT = 2;
    public static final double MINIMUM_ALLOWED_PITCH_SCALE = 0.6;
    public static final double MAXIMUM_ALLOWED_PITCH_SCALE = 2.5;
    public static final double MINIMUM_ALLOWED_TIME_SCALE = 0.6;
    public static final double MAXIMUM_ALLOWED_TIME_SCALE = 2.5;

    public BaselineTransformerParams() {
        this.inputFolder = "";
        this.outputBaseFolder = "";
        this.outputFolder = "";
        this.outputFolderInfoString = "";
        this.isSourceToTarget = true;
        this.isDisplayProcessingFrameCount = false;
        this.prosodyParams = new ProsodyTransformerParams();
        this.lsfParams = new LsfFileHeader();
        this.ptcParams = new PitchFileHeader();
        this.energyParams = new EnergyFileHeader();
        this.mfccParams = new MfccFileHeader();
        this.isForcedAnalysis = false;
        this.isSourceVocalTractSpectrumFromModel = true;
        this.isVocalTractTransformation = true;
        this.isResynthesizeVocalTractFromSourceModel = false;
        this.isVocalTractMatchUsingTargetModel = false;
        this.isSeparateProsody = true;
        this.isSaveVocalTractOnlyVersion = true;
        this.isFixedRateVocalTractConversion = true;
        this.isTemporalSmoothing = false;
        this.smoothingMethod = 0;
        this.smoothingNumNeighbours = 5;
        this.smoothingState = 0;
        this.smoothedVocalTractFile = "";
        this.isSourceVocalTractSpectrumFromModel = false;
        this.isResynthesizeVocalTractFromSourceModel = false;
        this.isVocalTractMatchUsingTargetModel = false;
        this.pitchMappingFile = "";
        this.isPitchFromTargetFile = false;
        this.pitchFromTargetMethod = 26;
        this.isDurationFromTargetFile = false;
        this.durationFromTargetMethod = 3;
        this.isEnergyFromTargetFile = false;
        this.isLsfsFromTargetFile = false;
        this.targetAlignmentFileType = 1;
    }

    public BaselineTransformerParams(BaselineTransformerParams existing) {
        this.inputFolder = existing.inputFolder;
        this.outputBaseFolder = existing.outputBaseFolder;
        this.outputFolder = existing.outputFolder;
        this.outputFolderInfoString = existing.outputFolderInfoString;
        this.isSourceToTarget = existing.isSourceToTarget;
        this.isDisplayProcessingFrameCount = existing.isDisplayProcessingFrameCount;
        this.prosodyParams = new ProsodyTransformerParams(existing.prosodyParams);
        this.lsfParams = new LsfFileHeader(existing.lsfParams);
        this.ptcParams = new PitchFileHeader(existing.ptcParams);
        this.energyParams = new EnergyFileHeader(existing.energyParams);
        this.mfccParams = new MfccFileHeader(existing.mfccParams);
        this.isForcedAnalysis = existing.isForcedAnalysis;
        this.isVocalTractTransformation = existing.isVocalTractTransformation;
        this.isSeparateProsody = existing.isSeparateProsody;
        this.isSaveVocalTractOnlyVersion = existing.isSaveVocalTractOnlyVersion;
        this.isFixedRateVocalTractConversion = existing.isFixedRateVocalTractConversion;
        this.isTemporalSmoothing = existing.isTemporalSmoothing;
        this.smoothingMethod = existing.smoothingMethod;
        this.smoothingNumNeighbours = existing.smoothingNumNeighbours;
        this.smoothingState = existing.smoothingState;
        this.smoothedVocalTractFile = existing.smoothedVocalTractFile;
        this.isSourceVocalTractSpectrumFromModel = existing.isSourceVocalTractSpectrumFromModel;
        this.isResynthesizeVocalTractFromSourceModel = existing.isResynthesizeVocalTractFromSourceModel;
        this.isVocalTractMatchUsingTargetModel = existing.isVocalTractMatchUsingTargetModel;
        this.pitchMappingFile = existing.pitchMappingFile;
        this.isPitchFromTargetFile = existing.isPitchFromTargetFile;
        this.pitchFromTargetMethod = existing.pitchFromTargetMethod;
        this.isDurationFromTargetFile = existing.isDurationFromTargetFile;
        this.durationFromTargetMethod = existing.durationFromTargetMethod;
        this.isEnergyFromTargetFile = existing.isEnergyFromTargetFile;
        this.isLsfsFromTargetFile = existing.isLsfsFromTargetFile;
        this.targetAlignmentFileType = existing.targetAlignmentFileType;
    }
}

