/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.util.io.BasenameList;

public class BaselineAdaptationSet {
    public BaselineAdaptationItem[] items;
    public static final String WAV_EXTENSION_DEFAULT = ".wav";
    public static final String SINUSOID_EXTENSION_DEFAULT = ".sin";
    public static final String NOISE_EXTENSION_DEFAULT = ".noi";
    public static final String TRANSIENT_EXTENSION_DEFAULT = ".tra";
    public static final String RESIDUAL_EXTENSION_DEFAULT = ".res";
    public static final String LABEL_EXTENSION_DEFAULT = ".lab";
    public static final String PITCH_EXTENSION_DEFAULT = ".ptc";
    public static final String F0_EXTENSION_DEFAULT = ".f0";
    public static final String PITCHMARK_EXTENSION_DEFAULT = ".pm";
    public static final String ENERGY_EXTENSION_DEFAULT = ".ene";
    public static final String TEXT_EXTENSION_DEFAULT = ".txt";
    public static final String RAWMFCC_EXTENSION_DEFAULT = ".mgc";
    public static final String MFCC_EXTENSION_DEFAULT = ".mfc";
    public static final String LSF_EXTENSION_DEFAULT = ".lsf";
    public static final String LPC_EXTENSION_DEFAULT = ".lpc";
    public static final String LPRESIDUAL_EXTENSION_DEFAULT = ".lpr";
    public static final String CEPSTRUM_EXTENSION_DEFAULT = ".cep";
    public static final String EGG_EXTENSION_DEFAULT = ".egg";
    public static final String TARGETFESTIVALUTT_EXTENSION_DEFAULT = ".tutt";
    public static final String TARGETLABEL_EXTENSION_DEFAULT = ".tlab";
    public static final String TARGETPITCH_EXTENSION_DEFAULT = ".tptc";
    public static final String TARGETF0_EXTENSION_DEFAULT = ".tf0";
    public static final String TARGETENERGY_EXTENSION_DEFAULT = ".tene";
    public static final String TARGETWAV_EXTENSION_DEFAULT = ".twav";

    public BaselineAdaptationSet() {
        this.items = null;
    }

    public BaselineAdaptationSet(int numItems) {
        this.allocate(numItems);
    }

    public BaselineAdaptationSet(String folder) {
        this(folder, WAV_EXTENSION_DEFAULT);
    }

    public BaselineAdaptationSet(String folder, String referenceFileExt) {
        BasenameList b = new BasenameList(folder, referenceFileExt);
        this.allocate(b.getListAsVector().size());
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setFromWavFilename(folder + b.getName(i) + referenceFileExt);
        }
    }

    public void allocate(int numItems) {
        if (numItems > 0) {
            this.items = new BaselineAdaptationItem[numItems];
            for (int i = 0; i < numItems; ++i) {
                this.items[i] = new BaselineAdaptationItem();
            }
        } else {
            this.items = null;
        }
    }

    public String[] getLabelFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].labelFile;
            }
        }
        return fileList;
    }

    public String[] getLsfFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].lsfFile;
            }
        }
        return fileList;
    }

    public String[] getAudioFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].audioFile;
            }
        }
        return fileList;
    }

    public String[] getCepsFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].cepsFile;
            }
        }
        return fileList;
    }

    public String[] getEggFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].eggFile;
            }
        }
        return fileList;
    }

    public String[] getPitchFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].pitchFile;
            }
        }
        return fileList;
    }

    public String[] getLpcFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].lpcFile;
            }
        }
        return fileList;
    }

    public String[] getLpResidualFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].lpResidualFile;
            }
        }
        return fileList;
    }

    public String[] getRawMfccFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].rawMfccFile;
            }
        }
        return fileList;
    }

    public String[] getMfccFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].mfccFile;
            }
        }
        return fileList;
    }

    public String[] getNoiseFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].noiseFile;
            }
        }
        return fileList;
    }

    public String[] getPitchMarkFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].pitchMarkFile;
            }
        }
        return fileList;
    }

    public String[] getResidualFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].residualFile;
            }
        }
        return fileList;
    }

    public String[] getSinesFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].sinesFile;
            }
        }
        return fileList;
    }

    public String[] getTextFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].textFile;
            }
        }
        return fileList;
    }

    public String[] getTransientsFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].transientsFile;
            }
        }
        return fileList;
    }

    public String[] getEnergyFiles() {
        String[] fileList = null;
        if (this.items != null && this.items.length > 0) {
            fileList = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                fileList[i] = this.items[i].energyFile;
            }
        }
        return fileList;
    }
}

