/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules.synthesis;

import java.util.Locale;
import marytts.modules.synthesis.Voice;
import marytts.modules.synthesis.VoiceSection;
import marytts.modules.synthesis.VoiceSectioner;

public class MbrolaVoiceSectioner
extends VoiceSectioner {
    public MbrolaVoiceSectioner(String s, Voice defaultVoice) {
        super(s, defaultVoice);
    }

    @Override
    public VoiceSection nextSection() {
        if (this.pos >= this.s.length()) {
            return null;
        }
        int n = this.pos;
        Voice newVoice = null;
        while (n < this.s.length() && newVoice == null) {
            int l1;
            if ((n = this.s.indexOf("voice ", n)) == -1) {
                n = this.s.length();
                continue;
            }
            String name = null;
            String gender = null;
            int l = this.s.indexOf("name=", n += 6);
            if (l != -1) {
                int m;
                for (m = l += 5; m < this.s.length() && Character.isLetterOrDigit(this.s.charAt(m)); ++m) {
                }
                name = this.s.substring(l, m);
                newVoice = Voice.getVoice(name);
            }
            if (newVoice == null && (l1 = this.s.indexOf("gender=", n)) != -1) {
                int m1;
                for (m1 = l1 += 7; m1 < this.s.length() && Character.isLetterOrDigit(this.s.charAt(m1)); ++m1) {
                }
                gender = this.s.substring(l1, m1);
                Locale locale = Locale.GERMAN;
                if (this.currentVoice != null) {
                    locale = this.currentVoice.getLocale();
                }
                if (gender.equals("female")) {
                    newVoice = Voice.getVoice(locale, Voice.FEMALE);
                } else if (gender.equals("male")) {
                    newVoice = Voice.getVoice(locale, Voice.MALE);
                }
            }
            if (newVoice == null) {
                this.logger.info("No known voice matches the description" + (name != null ? " name=`" + name + "'" : "") + (gender != null ? " gender=`" + gender + "'" : "") + ". Using previous voice instead.");
                continue;
            }
            if (newVoice != this.currentVoice) continue;
            newVoice = null;
        }
        if (newVoice == null || newVoice == this.currentVoice) {
            n = this.s.length();
        } else {
            n = this.s.lastIndexOf(System.getProperty("line.separator"), n);
            if (n == -1) {
                this.currentVoice = newVoice;
                return this.nextSection();
            }
            n += System.getProperty("line.separator").length();
        }
        String sec = this.s.substring(this.pos, n);
        this.pos = n;
        VoiceSection newSection = new VoiceSection(this.currentVoice, sec);
        this.currentVoice = newVoice;
        return newSection;
    }
}

