/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.MBROLAPhoneme;
import marytts.modules.synthesis.MbrolaVoice;
import marytts.modules.synthesis.Voice;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class MaryXMLToMbrola
extends InternalModule {
    public MaryXMLToMbrola() {
        super("MaryXMLToMbrola", MaryDataType.ACOUSTPARAMS, MaryDataType.MBROLA, null);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        NodeIterator it = ((DocumentTraversal)((Object)doc)).createNodeIterator(doc, 1, new NameNodeFilter("ph", "boundary"), false);
        ArrayList<Element> elements = new ArrayList<Element>();
        Element element = null;
        Voice currentVoice = d.getDefaultVoice();
        if (currentVoice == null) {
            Locale locale = MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
            currentVoice = Voice.getDefaultVoice(locale);
            this.logger.info("No default voice associated with data. Assuming locale " + locale + " default " + currentVoice.getName());
        }
        Element currentVoiceElement = null;
        StringBuilder buf = new StringBuilder();
        while ((element = (Element)it.nextNode()) != null) {
            Element v = (Element)MaryDomUtils.getAncestor((Node)element, "voice");
            if (v == null) {
                if (currentVoiceElement != null) {
                    if (!elements.isEmpty()) {
                        buf.append(this.convertToMbrola(elements, currentVoice));
                        elements.clear();
                    }
                    currentVoice = d.getDefaultVoice();
                    currentVoiceElement = null;
                }
            } else if (v != currentVoiceElement) {
                Voice newVoice;
                if (!elements.isEmpty()) {
                    buf.append(this.convertToMbrola(elements, currentVoice));
                    elements.clear();
                }
                if ((newVoice = Voice.getVoice(v)) != null && (buf.length() == 0 || newVoice != currentVoice)) {
                    buf.append("; voice name=");
                    buf.append(newVoice.getName());
                    buf.append("\n");
                    currentVoice = newVoice;
                }
                currentVoiceElement = v;
            }
            elements.add(element);
        }
        if (!elements.isEmpty()) {
            buf.append(this.convertToMbrola(elements, currentVoice));
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setPlainText(buf.toString());
        return result;
    }

    public String convertToMbrola(List<Element> phonesAndBoundaries, Voice voice) {
        if (!(voice instanceof MbrolaVoice)) {
            throw new IllegalArgumentException("Expected an MBROLA voice, but " + voice.getName() + " is a " + voice.getClass());
        }
        MbrolaVoice mbrolaVoice = (MbrolaVoice)voice;
        StringBuilder buf = new StringBuilder();
        LinkedList<MBROLAPhoneme> mbrolaPhonemes = new LinkedList<MBROLAPhoneme>();
        for (Element element : phonesAndBoundaries) {
            if (element.getTagName().equals("ph")) {
                String s = element.getAttribute("p");
                int dur = 0;
                try {
                    dur = Integer.parseInt(element.getAttribute("d"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                String f0string = element.getAttribute("f0");
                Vector<int[]> targets = new Vector<int[]>();
                int i = 0;
                while ((i = f0string.indexOf("(", i)) != -1) {
                    int j = f0string.indexOf(",", i);
                    int percent = 0;
                    try {
                        percent = Integer.parseInt(f0string.substring(i + 1, j));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    int k = f0string.indexOf(")", j);
                    int f0 = 0;
                    try {
                        f0 = Integer.parseInt(f0string.substring(j + 1, k));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    int[] target = new int[]{percent, f0};
                    targets.add(target);
                    i = k;
                }
                String vq = element.getAttribute("vq");
                if (vq.equals("") || !mbrolaVoice.hasVoiceQuality(vq)) {
                    vq = null;
                }
                MBROLAPhoneme newP = new MBROLAPhoneme(s, dur, targets, vq);
                Vector<MBROLAPhoneme> p2vect = mbrolaVoice.convertSampa(newP);
                mbrolaPhonemes.addAll(p2vect);
                while (mbrolaPhonemes.size() > 1) {
                    MBROLAPhoneme p1;
                    if (!mbrolaVoice.hasDiphone((MBROLAPhoneme)mbrolaPhonemes.get(0), (MBROLAPhoneme)mbrolaPhonemes.get(1))) {
                        p1 = (MBROLAPhoneme)mbrolaPhonemes.removeFirst();
                        MBROLAPhoneme p2 = (MBROLAPhoneme)mbrolaPhonemes.removeFirst();
                        Vector<MBROLAPhoneme> newPhones = mbrolaVoice.replaceDiphone(p1, p2);
                        for (int l = newPhones.size() - 1; l >= 0; --l) {
                            MBROLAPhoneme mph = newPhones.get(l);
                            mbrolaPhonemes.addFirst(mph);
                        }
                    }
                    p1 = (MBROLAPhoneme)mbrolaPhonemes.removeFirst();
                    buf.append(p1.toString());
                    buf.append("\n");
                }
                continue;
            }
            if (element.getTagName().equals("boundary")) {
                while (!mbrolaPhonemes.isEmpty()) {
                    MBROLAPhoneme p = (MBROLAPhoneme)mbrolaPhonemes.removeFirst();
                    buf.append(p.toString());
                    buf.append("\n");
                }
                String duration = element.getAttribute("duration");
                if (duration == null || duration.equals("")) continue;
                try {
                    Integer.parseInt(duration);
                    buf.append("_ ");
                    buf.append(duration);
                    buf.append("\n");
                    buf.append("#\n");
                }
                catch (NumberFormatException nfe) {
                    this.logger.debug("Unexpected value for duration: '" + duration + "' -- ignoring boundary");
                }
                continue;
            }
            throw new IllegalArgumentException("Expected only <ph> and <boundary> elements, got <" + element.getTagName() + ">");
        }
        while (!mbrolaPhonemes.isEmpty()) {
            MBROLAPhoneme p = (MBROLAPhoneme)mbrolaPhonemes.removeFirst();
            buf.append(p.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    public void powerOnSelfTest() throws Error {
    }
}

