/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Utterance;
import com.sun.speech.freetts.UtteranceProcessor;
import com.sun.speech.freetts.cart.CARTImpl;
import com.sun.speech.freetts.en.us.CMUVoice;
import com.sun.speech.freetts.en.us.PrefixFSM;
import com.sun.speech.freetts.en.us.SuffixFSM;
import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.en.TokenToWords;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;

public class FreeTTSTokenToWords
extends InternalModule {
    private UtteranceProcessor processor;

    public FreeTTSTokenToWords() {
        super("TokenToWords", USEnglishDataTypes.FREETTS_TOKENS, USEnglishDataTypes.FREETTS_WORDS, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        FreeTTSVoices.load();
        CARTImpl numbersCart = new CARTImpl(CMUVoice.class.getResource("nums_cart.txt"));
        PrefixFSM prefixFSM = new PrefixFSM(CMUVoice.class.getResource("prefix_fsm.txt"));
        SuffixFSM suffixFSM = new SuffixFSM(CMUVoice.class.getResource("suffix_fsm.txt"));
        this.processor = new TokenToWords(numbersCart, prefixFSM, suffixFSM);
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processor.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }
}

