/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.Utterance;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import marytts.datatypes.MaryData;
import marytts.language.en_US.datatypes.USEnglishDataTypes;
import marytts.modules.InternalModule;
import marytts.modules.synthesis.FreeTTSVoices;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class FreeTTSPartOfSpeechTagger
extends InternalModule {
    private Logger logger;
    private Map posMap;

    public FreeTTSPartOfSpeechTagger() {
        super("PartOfSpeechTagger", USEnglishDataTypes.FREETTS_WORDS, USEnglishDataTypes.FREETTS_POS, Locale.ENGLISH);
    }

    @Override
    public void startup() throws Exception {
        super.startup();
        this.logger = MaryUtils.getLogger("FreeTTSPOSTagger");
        this.buildPosMap();
        FreeTTSVoices.load();
    }

    @Override
    public MaryData process(MaryData d) throws Exception {
        List<Utterance> utterances = d.getUtterances();
        for (Utterance utterance : utterances) {
            this.processUtterance(utterance);
        }
        MaryData output = new MaryData(this.outputType(), d.getLocale());
        output.setUtterances(utterances);
        return output;
    }

    private void buildPosMap() {
        this.posMap = new HashMap();
        try {
            String posFile = MaryProperties.getFilename("english.freetts.posfile");
            BufferedReader reader = new BufferedReader(new FileReader(new File(posFile)));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("***")) {
                    StringTokenizer st = new StringTokenizer(line, " ");
                    String word = st.nextToken();
                    String pos = st.nextToken();
                    this.posMap.put(word, pos);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Unable to build PoS-Map");
        }
    }

    private void processUtterance(Utterance utt) {
        this.logger.debug("Tagging part of speech...");
        for (Item word = utt.getRelation("Word").getHead(); word != null; word = word.getNext()) {
            String pos = null;
            if (this.posMap.containsKey(word.toString())) {
                pos = (String)this.posMap.get(word.toString());
                this.logger.debug("Assigning pos \"" + pos + "\" to word \"" + word.toString() + "\"");
            } else {
                pos = "content";
            }
            word.getFeatures().setString("pos", pos);
        }
    }
}

