/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.Vector;
import marytts.config.MaryConfig;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.htsengine.CartTreeSet;
import marytts.htsengine.GVModelSet;
import marytts.htsengine.PhoneTranslator;
import marytts.util.FeatureUtils;
import marytts.util.MaryUtils;
import marytts.util.io.PropertiesAccessor;
import org.apache.log4j.Logger;

public class HMMData {
    public static final int HTS_NUMMTYPE = 5;
    private Logger logger = MaryUtils.getLogger("HMMData");
    private int rate = 16000;
    private int fperiod = 80;
    private double rho = 0.0;
    private int stage = 0;
    private double alpha = 0.55;
    private double beta = 0.0;
    private boolean useLogGain = false;
    private double uv = 0.5;
    private boolean algnst = false;
    private boolean algnph = false;
    private boolean useMixExc = true;
    private boolean useFourierMag = false;
    private boolean useGV = false;
    private boolean useContextDependentGV = false;
    private boolean gvMethodGradient = true;
    private int maxMgcGvIter = 100;
    private int maxLf0GvIter = 100;
    private int maxStrGvIter = 100;
    private int maxMagGvIter = 100;
    private double gvWeightMgc = 1.0;
    private double gvWeightLf0 = 1.0;
    private double gvWeightStr = 1.0;
    private double gvWeightMag = 1.0;
    private boolean useAcousticModels = false;
    private double f0Std = 1.0;
    private double f0Mean = 0.0;
    private double length = 0.0;
    private double durationScale = 1.0;
    private InputStream treeDurStream;
    private InputStream treeLf0Stream;
    private InputStream treeMgcStream;
    private InputStream treeStrStream;
    private InputStream treeMagStream;
    private FeatureDefinition feaDef;
    private CartTreeSet cart = new CartTreeSet();
    private InputStream pdfDurStream;
    private InputStream pdfLf0Stream;
    private InputStream pdfMgcStream;
    private InputStream pdfStrStream;
    private InputStream pdfMagStream;
    private InputStream pdfLf0GVStream;
    private InputStream pdfMgcGVStream;
    private InputStream pdfStrGVStream;
    private InputStream pdfMagGVStream;
    private InputStream switchGVStream;
    private GVModelSet gv = new GVModelSet();
    private int numFilters;
    private int orderFilters;
    private double[][] mixFilters;
    private PhoneTranslator trickyPhones;

    public int getRate() {
        return this.rate;
    }

    public int getFperiod() {
        return this.fperiod;
    }

    public double getRho() {
        return this.rho;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public int getStage() {
        return this.stage;
    }

    public double getGamma() {
        return this.stage != 0 ? -1.0 / (double)this.stage : 0.0;
    }

    public boolean getUseLogGain() {
        return this.useLogGain;
    }

    public double getUV() {
        return this.uv;
    }

    public boolean getAlgnst() {
        return this.algnst;
    }

    public boolean getAlgnph() {
        return this.algnph;
    }

    public double getF0Std() {
        return this.f0Std;
    }

    public double getF0Mean() {
        return this.f0Mean;
    }

    public double getLength() {
        return this.length;
    }

    public double getDurationScale() {
        return this.durationScale;
    }

    public InputStream getTreeDurStream() {
        return this.treeDurStream;
    }

    public InputStream getTreeLf0Stream() {
        return this.treeLf0Stream;
    }

    public InputStream getTreeMgcStream() {
        return this.treeMgcStream;
    }

    public InputStream getTreeStrStream() {
        return this.treeStrStream;
    }

    public InputStream getTreeMagStream() {
        return this.treeMagStream;
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.feaDef;
    }

    public InputStream getPdfDurStream() {
        return this.pdfDurStream;
    }

    public InputStream getPdfLf0Stream() {
        return this.pdfLf0Stream;
    }

    public InputStream getPdfMgcStream() {
        return this.pdfMgcStream;
    }

    public InputStream getPdfStrStream() {
        return this.pdfStrStream;
    }

    public InputStream getPdfMagStream() {
        return this.pdfMagStream;
    }

    public boolean getUseAcousticModels() {
        return this.useAcousticModels;
    }

    public void setUseAcousticModels(boolean bval) {
        this.useAcousticModels = bval;
    }

    public boolean getUseMixExc() {
        return this.useMixExc;
    }

    public boolean getUseFourierMag() {
        return this.useFourierMag;
    }

    public boolean getUseGV() {
        return this.useGV;
    }

    public boolean getUseContextDependentGV() {
        return this.useContextDependentGV;
    }

    public boolean getGvMethodGradient() {
        return this.gvMethodGradient;
    }

    public int getMaxMgcGvIter() {
        return this.maxMgcGvIter;
    }

    public int getMaxLf0GvIter() {
        return this.maxLf0GvIter;
    }

    public int getMaxStrGvIter() {
        return this.maxStrGvIter;
    }

    public int getMaxMagGvIter() {
        return this.maxMagGvIter;
    }

    public double getGvWeightMgc() {
        return this.gvWeightMgc;
    }

    public double getGvWeightLf0() {
        return this.gvWeightLf0;
    }

    public double getGvWeightStr() {
        return this.gvWeightStr;
    }

    public double getGvWeightMag() {
        return this.gvWeightMag;
    }

    public InputStream getPdfLf0GVStream() {
        return this.pdfLf0GVStream;
    }

    public InputStream getPdfMgcGVStream() {
        return this.pdfMgcGVStream;
    }

    public InputStream getPdfStrGVStream() {
        return this.pdfStrGVStream;
    }

    public InputStream getPdfMagGVStream() {
        return this.pdfMagGVStream;
    }

    public InputStream getSwitchGVStream() {
        return this.switchGVStream;
    }

    public int getNumFilters() {
        return this.numFilters;
    }

    public int getOrderFilters() {
        return this.orderFilters;
    }

    public double[][] getMixFilters() {
        return this.mixFilters;
    }

    public void setRate(int ival) {
        this.rate = ival;
    }

    public void setFperiod(int ival) {
        this.fperiod = ival;
    }

    public void setAlpha(double dval) {
        this.alpha = dval;
    }

    public void setBeta(double dval) {
        this.beta = dval;
    }

    public void setStage(int ival) {
        this.stage = ival;
    }

    public void setUseLogGain(boolean bval) {
        this.useLogGain = bval;
    }

    public void setF0Std(double dval) {
        this.f0Std = dval >= 0.0 && dval <= 3.0 ? dval : 1.0;
    }

    public void setF0Mean(double dval) {
        this.f0Mean = dval >= -300.0 && dval <= 300.0 ? dval : 0.0;
    }

    public void setLength(double dval) {
        this.length = dval;
    }

    public void setDurationScale(double dval) {
        this.durationScale = dval >= 0.1 && dval <= 3.0 ? dval : 1.0;
    }

    public CartTreeSet getCartTreeSet() {
        return this.cart;
    }

    public GVModelSet getGVModelSet() {
        return this.gv;
    }

    public void setPdfStrStream(InputStream str) {
        this.pdfStrStream = str;
    }

    public void setPdfMagStream(InputStream mag) {
        this.pdfMagStream = mag;
    }

    public void setUseMixExc(boolean bval) {
        this.useMixExc = bval;
    }

    public void setUseFourierMag(boolean bval) {
        this.useFourierMag = bval;
    }

    public void setUseGV(boolean bval) {
        this.useGV = bval;
    }

    public void setUseContextDepenendentGV(boolean bval) {
        this.useContextDependentGV = bval;
    }

    public void setGvMethod(String sval) {
        this.gvMethodGradient = sval.contentEquals("gradient");
    }

    public void setMaxMgcGvIter(int val) {
        this.maxMgcGvIter = val;
    }

    public void setMaxLf0GvIter(int val) {
        this.maxLf0GvIter = val;
    }

    public void setMaxStrGvIter(int val) {
        this.maxStrGvIter = val;
    }

    public void setGvWeightMgc(double dval) {
        this.gvWeightMgc = dval;
    }

    public void setGvWeightLf0(double dval) {
        this.gvWeightLf0 = dval;
    }

    public void setGvWeightStr(double dval) {
        this.gvWeightStr = dval;
    }

    public void setNumFilters(int val) {
        this.numFilters = val;
    }

    public void setOrderFilters(int val) {
        this.orderFilters = val;
    }

    public void loadCartTreeSet() throws IOException, MaryConfigurationException {
        this.cart.loadTreeSet(this, this.feaDef, this.trickyPhones);
    }

    public void loadGVModelSet() throws IOException {
        this.gv.loadGVModelSet(this, this.feaDef);
    }

    public void initHMMData(PropertiesAccessor p, String voiceName) throws IOException, MaryConfigurationException {
        this.logger.debug("Reached new initHMMData");
        String prefix = "voice." + voiceName;
        this.rate = p.getInteger(prefix + ".samplingRate", this.rate);
        this.fperiod = p.getInteger(prefix + ".framePeriod", this.fperiod);
        this.alpha = p.getDouble(prefix + ".alpha", this.alpha);
        this.stage = p.getInteger(prefix + ".gamma", this.stage);
        this.useLogGain = p.getBoolean(prefix + ".logGain", this.useLogGain);
        this.beta = p.getDouble(prefix + ".beta", this.beta);
        this.treeDurStream = p.getStream(prefix + ".Ftd");
        this.treeLf0Stream = p.getStream(prefix + ".Ftf");
        this.treeMgcStream = p.getStream(prefix + ".Ftm");
        this.treeStrStream = p.getStream(prefix + ".Fts");
        this.treeMagStream = p.getStream(prefix + ".Fta");
        this.pdfDurStream = p.getStream(prefix + ".Fmd");
        this.pdfLf0Stream = p.getStream(prefix + ".Fmf");
        this.pdfMgcStream = p.getStream(prefix + ".Fmm");
        this.pdfStrStream = p.getStream(prefix + ".Fms");
        this.pdfMagStream = p.getStream(prefix + ".Fma");
        this.useAcousticModels = p.getBoolean(prefix + ".useAcousticModels");
        this.useMixExc = p.getBoolean(prefix + ".useMixExc");
        this.useFourierMag = p.getBoolean(prefix + ".useFourierMag");
        this.useGV = p.getBoolean(prefix + ".useGV");
        if (this.useGV) {
            this.useContextDependentGV = p.getBoolean(prefix + ".useContextDependentGV");
            String gvMethod = p.getProperty(prefix + ".gvMethod");
            if (gvMethod != null) {
                this.setGvMethod(gvMethod);
            }
            this.maxMgcGvIter = p.getInteger(prefix + ".maxMgcGvIter", this.maxMgcGvIter);
            this.maxLf0GvIter = p.getInteger(prefix + ".maxLf0GvIter", this.maxLf0GvIter);
            this.maxStrGvIter = p.getInteger(prefix + ".maxStrGvIter", this.maxStrGvIter);
            this.gvWeightMgc = p.getDouble(prefix + ".gvWeightMgc", this.gvWeightMgc);
            this.gvWeightLf0 = p.getDouble(prefix + ".gvWeightLf0", this.gvWeightLf0);
            this.gvWeightStr = p.getDouble(prefix + ".gvWeightStr", this.gvWeightStr);
            this.pdfLf0GVStream = p.getStream(prefix + ".Fgvf");
            this.pdfMgcGVStream = p.getStream(prefix + ".Fgvm");
            this.pdfStrGVStream = p.getStream(prefix + ".Fgvs");
            this.pdfMagGVStream = p.getStream(prefix + ".Fgva");
        }
        InputStream featureStream = p.getStream(prefix + ".FeaFile");
        this.feaDef = FeatureUtils.readFeatureDefinition(featureStream);
        this.trickyPhones = new PhoneTranslator(p.getStream(prefix + ".trickyPhonesFile"));
        InputStream mixFiltersStream = p.getStream(prefix + ".Fif");
        if (mixFiltersStream != null) {
            this.numFilters = p.getInteger(prefix + ".in");
            this.logger.debug("Loading Mixed Excitation Filters File:");
            this.readMixedExcitationFilters(mixFiltersStream);
        }
        this.logger.debug("Loading Tree Set in CARTs:");
        this.loadCartTreeSet();
        this.logger.debug("Loading GV Model Set:");
        this.loadGVModelSet();
        this.logger.debug("InitHMMData complete");
    }

    public void initHMMData(String voiceName, String marybase, String configFile) throws Exception {
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(marybase + configFile);
        props.load(fis);
        fis.close();
        HashMap<String, String> maryBaseReplacer = new HashMap<String, String>();
        maryBaseReplacer.put("jar:", marybase);
        this.initHMMData(new PropertiesAccessor(props, false, maryBaseReplacer), voiceName);
    }

    public void initHMMData(String voiceName) throws IOException, MaryConfigurationException {
        this.initHMMData(MaryConfig.getVoiceConfig(voiceName).getPropertiesAccessor(true), voiceName);
    }

    public void initHMMDataForHMMModel(String voiceName) throws IOException, MaryConfigurationException {
        PropertiesAccessor p = MaryConfig.getVoiceConfig(voiceName).getPropertiesAccessor(true);
        String prefix = "voice." + voiceName;
        this.treeDurStream = p.getStream(prefix + ".Ftd");
        this.pdfDurStream = p.getStream(prefix + ".Fmd");
        this.treeLf0Stream = p.getStream(prefix + ".Ftf");
        this.pdfLf0Stream = p.getStream(prefix + ".Fmf");
        this.useGV = p.getBoolean(prefix + ".useGV");
        if (this.useGV) {
            this.useContextDependentGV = p.getBoolean(prefix + ".useContextDependentGV", this.useContextDependentGV);
            if (p.getProperty(prefix + ".gvMethod") != null) {
                String sval = p.getProperty(prefix + ".gvMethod");
                this.setGvMethod(sval);
            }
            this.maxLf0GvIter = p.getInteger(prefix + ".maxLf0GvIter", this.maxLf0GvIter);
            this.gvWeightLf0 = p.getDouble(prefix + ".gvWeightLf0", this.gvWeightLf0);
            this.pdfLf0GVStream = p.getStream(prefix + ".Fgvf");
            this.maxLf0GvIter = p.getInteger(prefix + ".maxLf0GvIter", this.maxLf0GvIter);
        }
        InputStream feaStream = p.getStream(prefix + ".FeaFile");
        this.feaDef = FeatureUtils.readFeatureDefinition(feaStream);
        InputStream trickyPhonesStream = p.getStream(prefix + ".trickyPhonesFile");
        this.trickyPhones = new PhoneTranslator(trickyPhonesStream);
        this.logger.info("Loading Tree Set in CARTs:");
        this.cart.loadTreeSet(this, this.feaDef, this.trickyPhones);
        this.logger.info("Loading GV Model Set:");
        this.gv.loadGVModelSet(this, this.feaDef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMixedExcitationFilters(InputStream mixFiltersStream) throws IOException {
        Vector<Double> taps = new Vector<Double>();
        try (Scanner s = null;){
            s = new Scanner(new BufferedReader(new InputStreamReader(mixFiltersStream, "UTF-8")));
            s.useLocale(Locale.US);
            this.logger.debug("reading mixed excitation filters");
            while (s.hasNext("#")) {
                String line = s.nextLine();
            }
            while (s.hasNextDouble()) {
                taps.add(s.nextDouble());
            }
        }
        this.orderFilters = taps.size() / this.numFilters;
        this.mixFilters = new double[this.numFilters][this.orderFilters];
        int k = 0;
        for (int i = 0; i < this.numFilters; ++i) {
            for (int j = 0; j < this.orderFilters; ++j) {
                this.mixFilters[i][j] = (Double)taps.get(k++);
            }
        }
        this.logger.debug("initMixedExcitation: loaded filter taps");
        this.logger.debug("initMixedExcitation: numFilters = " + this.numFilters + "  orderFilters = " + this.orderFilters);
    }

    public Set<FeatureType> getFeatureSet() {
        EnumSet<FeatureType> featureTypes = EnumSet.noneOf(FeatureType.class);
        if (this.getPdfDurStream() != null) {
            featureTypes.add(FeatureType.DUR);
        }
        if (this.getPdfLf0Stream() != null) {
            featureTypes.add(FeatureType.LF0);
        }
        if (this.getPdfStrStream() != null) {
            featureTypes.add(FeatureType.STR);
        }
        if (this.getPdfMagStream() != null) {
            featureTypes.add(FeatureType.MAG);
        }
        if (this.getPdfMgcStream() != null) {
            featureTypes.add(FeatureType.MGC);
        }
        return featureTypes;
    }

    public static enum PdfFileFormat {
        dur,
        lf0,
        mgc,
        str,
        mag,
        join;

    }

    public static enum FeatureType {
        DUR,
        MGC,
        LF0,
        STR,
        MAG;

    }
}

