/*
 * Decompiled with CFR 0.152.
 */
package marytts.features;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import marytts.features.FeatureVector;
import marytts.util.io.StreamUtils;
import marytts.util.string.ByteStringTranslator;
import marytts.util.string.IntStringTranslator;
import marytts.util.string.ShortStringTranslator;

public class FeatureDefinition {
    public static final String BYTEFEATURES = "ByteValuedFeatureProcessors";
    public static final String SHORTFEATURES = "ShortValuedFeatureProcessors";
    public static final String CONTINUOUSFEATURES = "ContinuousFeatureProcessors";
    public static final String FEATURESIMILARITY = "FeatureSimilarity";
    public static final char WEIGHT_SEPARATOR = '|';
    public static final String EDGEFEATURE = "edge";
    public static final String EDGEFEATURE_START = "start";
    public static final String EDGEFEATURE_END = "end";
    public static final String NULLVALUE = "0";
    private int numByteFeatures;
    private int numShortFeatures;
    private int numContinuousFeatures;
    private float[] featureWeights;
    private IntStringTranslator featureNames;
    private ByteStringTranslator[] byteFeatureValues;
    private ShortStringTranslator[] shortFeatureValues;
    private String[] floatWeightFuncts;
    private float[][][] similarityMatrices = null;

    public FeatureDefinition(BufferedReader input, boolean readWeights) throws IOException {
        String[] nameAndValues;
        String featureDef;
        String weightDef;
        int i;
        String line = input.readLine();
        if (line == null) {
            throw new IOException("Could not read from input");
        }
        while (line.matches("^\\s*#.*") || line.matches("\\s*")) {
            line = input.readLine();
        }
        if (!line.trim().equals(BYTEFEATURES)) {
            throw new IOException("Unexpected input: expected 'ByteValuedFeatureProcessors', read '" + line + "'");
        }
        ArrayList<String> byteFeatureLines = new ArrayList<String>();
        while (true) {
            if ((line = input.readLine()) == null) {
                throw new IOException("Could not read from input");
            }
            if ((line = line.trim()).equals(SHORTFEATURES)) break;
            byteFeatureLines.add(line);
        }
        ArrayList<String> shortFeatureLines = new ArrayList<String>();
        while (true) {
            if ((line = input.readLine()) == null) {
                throw new IOException("Could not read from input");
            }
            if ((line = line.trim()).equals(CONTINUOUSFEATURES)) break;
            shortFeatureLines.add(line);
        }
        ArrayList<String> continuousFeatureLines = new ArrayList<String>();
        boolean readFeatureSimilarity = false;
        while ((line = input.readLine()) != null) {
            if ((line = line.trim()).equals(FEATURESIMILARITY)) {
                readFeatureSimilarity = true;
                break;
            }
            if (line.equals("")) break;
            continuousFeatureLines.add(line);
        }
        this.numByteFeatures = byteFeatureLines.size();
        this.numShortFeatures = shortFeatureLines.size();
        this.numContinuousFeatures = continuousFeatureLines.size();
        int total = this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures;
        this.featureNames = new IntStringTranslator(total);
        this.byteFeatureValues = new ByteStringTranslator[this.numByteFeatures];
        this.shortFeatureValues = new ShortStringTranslator[this.numShortFeatures];
        float sumOfWeights = 0.0f;
        if (readWeights) {
            this.featureWeights = new float[total];
            this.floatWeightFuncts = new String[this.numContinuousFeatures];
        }
        for (i = 0; i < this.numByteFeatures; ++i) {
            line = (String)byteFeatureLines.get(i);
            if (readWeights) {
                int seppos = line.indexOf(124);
                if (seppos == -1) {
                    throw new IOException("Weight separator '|' not found in line '" + line + "'");
                }
                weightDef = line.substring(0, seppos).trim();
                featureDef = line.substring(seppos + 1).trim();
                this.featureWeights[i] = Float.parseFloat(weightDef);
                sumOfWeights += this.featureWeights[i];
                if (this.featureWeights[i] < 0.0f) {
                    throw new IOException("Negative weight found in line '" + line + "'");
                }
            } else {
                featureDef = line;
            }
            nameAndValues = featureDef.split("\\s+", 2);
            this.featureNames.set(i, nameAndValues[0]);
            this.byteFeatureValues[i] = new ByteStringTranslator(nameAndValues[1].split("\\s+"));
        }
        for (i = 0; i < this.numShortFeatures; ++i) {
            line = (String)shortFeatureLines.get(i);
            if (readWeights) {
                int seppos = line.indexOf(124);
                if (seppos == -1) {
                    throw new IOException("Weight separator '|' not found in line '" + line + "'");
                }
                weightDef = line.substring(0, seppos).trim();
                featureDef = line.substring(seppos + 1).trim();
                this.featureWeights[this.numByteFeatures + i] = Float.parseFloat(weightDef);
                sumOfWeights += this.featureWeights[this.numByteFeatures + i];
                if (this.featureWeights[this.numByteFeatures + i] < 0.0f) {
                    throw new IOException("Negative weight found in line '" + line + "'");
                }
            } else {
                featureDef = line;
            }
            nameAndValues = featureDef.split("\\s+", 2);
            this.featureNames.set(this.numByteFeatures + i, nameAndValues[0]);
            this.shortFeatureValues[i] = new ShortStringTranslator(nameAndValues[1].split("\\s+"));
        }
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            line = (String)continuousFeatureLines.get(i);
            if (readWeights) {
                int seppos = line.indexOf(124);
                if (seppos == -1) {
                    throw new IOException("Weight separator '|' not found in line '" + line + "'");
                }
                weightDef = line.substring(0, seppos).trim();
                featureDef = line.substring(seppos + 1).trim();
                String[] weightAndFunction = weightDef.split("\\s+", 2);
                this.featureWeights[this.numByteFeatures + this.numShortFeatures + i] = Float.parseFloat(weightAndFunction[0]);
                sumOfWeights += this.featureWeights[this.numByteFeatures + this.numShortFeatures + i];
                if (this.featureWeights[this.numByteFeatures + this.numShortFeatures + i] < 0.0f) {
                    throw new IOException("Negative weight found in line '" + line + "'");
                }
                try {
                    this.floatWeightFuncts[i] = weightAndFunction[1];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new RuntimeException("The string [" + weightDef + "] appears to be a badly formed" + " weight plus weighting function definition.");
                }
            } else {
                featureDef = line;
            }
            if (featureDef.endsWith("float")) {
                String[] featureDefSplit = featureDef.split("\\s+", 2);
                this.featureNames.set(this.numByteFeatures + this.numShortFeatures + i, featureDefSplit[0]);
                continue;
            }
            this.featureNames.set(this.numByteFeatures + this.numShortFeatures + i, featureDef);
        }
        if (readWeights) {
            i = 0;
            while (i < total) {
                int n = i++;
                this.featureWeights[n] = this.featureWeights[n] / sumOfWeights;
            }
        }
        if (readFeatureSimilarity) {
            this.readFeatureSimilarityMatrices(input);
        }
    }

    private void readFeatureSimilarityMatrices(BufferedReader input) throws IOException {
        String line = null;
        this.similarityMatrices = new float[this.getNumberOfByteFeatures()][][];
        for (int i = 0; i < this.getNumberOfByteFeatures(); ++i) {
            this.similarityMatrices[i] = null;
        }
        while ((line = input.readLine()) != null) {
            if ("".equals(line)) {
                return;
            }
            String[] featureUniqueValues = line.trim().split("\\s+");
            String featureName = featureUniqueValues[0];
            if (!this.isByteFeature(featureName)) {
                throw new RuntimeException("Similarity matrix support is for bytefeatures only, but not for other feature types...");
            }
            int featureIndex = this.getFeatureIndex(featureName);
            int noUniqValues = featureUniqueValues.length - 1;
            this.similarityMatrices[featureIndex] = new float[noUniqValues][noUniqValues];
            for (int i = 1; i <= noUniqValues; ++i) {
                Arrays.fill(this.similarityMatrices[featureIndex][i - 1], 0.0f);
                String featureValue = featureUniqueValues[i];
                String matLine = input.readLine();
                if (matLine == null) {
                    throw new RuntimeException("Feature definition file is having unexpected format...");
                }
                String[] lines = matLine.trim().split("\\s+");
                if (!featureValue.equals(lines[0])) {
                    throw new RuntimeException("Feature definition file is having unexpected format...");
                }
                if (lines.length != i) {
                    throw new RuntimeException("Feature definition file is having unexpected format...");
                }
                for (int j = 1; j < i; ++j) {
                    float similarity;
                    this.similarityMatrices[featureIndex][i - 1][j - 1] = similarity = new Float(lines[j]).floatValue();
                    this.similarityMatrices[featureIndex][j - 1][i - 1] = similarity;
                }
            }
        }
    }

    public FeatureDefinition(DataInput input) throws IOException {
        String value;
        int numberOfValues;
        int i;
        this.numByteFeatures = input.readInt();
        this.byteFeatureValues = new ByteStringTranslator[this.numByteFeatures];
        this.featureNames = new IntStringTranslator(this.numByteFeatures);
        this.featureWeights = new float[this.numByteFeatures];
        for (i = 0; i < this.numByteFeatures; ++i) {
            this.featureWeights[i] = input.readFloat();
            String featureName = input.readUTF();
            this.featureNames.set(i, featureName);
            byte numberOfValuesEncoded = input.readByte();
            numberOfValues = numberOfValuesEncoded & 0xFF;
            this.byteFeatureValues[i] = new ByteStringTranslator(numberOfValues);
            for (int b = 0; b < numberOfValues; ++b) {
                value = input.readUTF();
                this.byteFeatureValues[i].set((byte)b, value);
            }
        }
        this.numShortFeatures = input.readInt();
        if (this.numShortFeatures > 0) {
            this.shortFeatureValues = new ShortStringTranslator[this.numShortFeatures];
            float[] newWeights = new float[this.numByteFeatures + this.numShortFeatures];
            System.arraycopy(this.featureWeights, 0, newWeights, 0, this.numByteFeatures);
            this.featureWeights = newWeights;
            for (int i2 = 0; i2 < this.numShortFeatures; ++i2) {
                this.featureWeights[this.numByteFeatures + i2] = input.readFloat();
                String featureName = input.readUTF();
                this.featureNames.set(this.numByteFeatures + i2, featureName);
                numberOfValues = input.readShort();
                this.shortFeatureValues[i2] = new ShortStringTranslator((short)numberOfValues);
                for (int s = 0; s < numberOfValues; s = (short)(s + 1)) {
                    value = input.readUTF();
                    this.shortFeatureValues[i2].set((short)s, value);
                }
            }
        }
        this.numContinuousFeatures = input.readInt();
        this.floatWeightFuncts = new String[this.numContinuousFeatures];
        if (this.numContinuousFeatures > 0) {
            float[] newWeights = new float[this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures];
            System.arraycopy(this.featureWeights, 0, newWeights, 0, this.numByteFeatures + this.numShortFeatures);
            this.featureWeights = newWeights;
        }
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            this.featureWeights[this.numByteFeatures + this.numShortFeatures + i] = input.readFloat();
            this.floatWeightFuncts[i] = input.readUTF();
            String featureName = input.readUTF();
            this.featureNames.set(this.numByteFeatures + this.numShortFeatures + i, featureName);
        }
    }

    public FeatureDefinition(ByteBuffer bb) throws IOException {
        String value;
        int numberOfValues;
        int i;
        this.numByteFeatures = bb.getInt();
        this.byteFeatureValues = new ByteStringTranslator[this.numByteFeatures];
        this.featureNames = new IntStringTranslator(this.numByteFeatures);
        this.featureWeights = new float[this.numByteFeatures];
        for (i = 0; i < this.numByteFeatures; ++i) {
            this.featureWeights[i] = bb.getFloat();
            String featureName = StreamUtils.readUTF(bb);
            this.featureNames.set(i, featureName);
            byte numberOfValuesEncoded = bb.get();
            numberOfValues = numberOfValuesEncoded & 0xFF;
            this.byteFeatureValues[i] = new ByteStringTranslator(numberOfValues);
            for (int b = 0; b < numberOfValues; ++b) {
                value = StreamUtils.readUTF(bb);
                this.byteFeatureValues[i].set((byte)b, value);
            }
        }
        this.numShortFeatures = bb.getInt();
        if (this.numShortFeatures > 0) {
            this.shortFeatureValues = new ShortStringTranslator[this.numShortFeatures];
            float[] newWeights = new float[this.numByteFeatures + this.numShortFeatures];
            System.arraycopy(this.featureWeights, 0, newWeights, 0, this.numByteFeatures);
            this.featureWeights = newWeights;
            for (int i2 = 0; i2 < this.numShortFeatures; ++i2) {
                this.featureWeights[this.numByteFeatures + i2] = bb.getFloat();
                String featureName = StreamUtils.readUTF(bb);
                this.featureNames.set(this.numByteFeatures + i2, featureName);
                numberOfValues = bb.getShort();
                this.shortFeatureValues[i2] = new ShortStringTranslator((short)numberOfValues);
                for (int s = 0; s < numberOfValues; s = (short)(s + 1)) {
                    value = StreamUtils.readUTF(bb);
                    this.shortFeatureValues[i2].set((short)s, value);
                }
            }
        }
        this.numContinuousFeatures = bb.getInt();
        this.floatWeightFuncts = new String[this.numContinuousFeatures];
        if (this.numContinuousFeatures > 0) {
            float[] newWeights = new float[this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures];
            System.arraycopy(this.featureWeights, 0, newWeights, 0, this.numByteFeatures + this.numShortFeatures);
            this.featureWeights = newWeights;
        }
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            this.featureWeights[this.numByteFeatures + this.numShortFeatures + i] = bb.getFloat();
            this.floatWeightFuncts[i] = StreamUtils.readUTF(bb);
            String featureName = StreamUtils.readUTF(bb);
            this.featureNames.set(this.numByteFeatures + this.numShortFeatures + i, featureName);
        }
    }

    public void writeBinaryTo(DataOutput out) throws IOException {
        int numValues;
        int i;
        out.writeInt(this.numByteFeatures);
        for (i = 0; i < this.numByteFeatures; ++i) {
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
            } else {
                out.writeFloat(0.0f);
            }
            out.writeUTF(this.getFeatureName(i));
            numValues = this.getNumberOfValues(i);
            byte numValuesEncoded = (byte)numValues;
            out.writeByte(numValuesEncoded);
            for (int b = 0; b < numValues; ++b) {
                String value = this.getFeatureValueAsString(i, b);
                out.writeUTF(value);
            }
        }
        out.writeInt(this.numShortFeatures);
        for (i = this.numByteFeatures; i < this.numByteFeatures + this.numShortFeatures; ++i) {
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
            } else {
                out.writeFloat(0.0f);
            }
            out.writeUTF(this.getFeatureName(i));
            numValues = (short)this.getNumberOfValues(i);
            out.writeShort(numValues);
            for (int b = 0; b < numValues; b = (int)((short)(b + 1))) {
                String value = this.getFeatureValueAsString(i, b);
                out.writeUTF(value);
            }
        }
        out.writeInt(this.numContinuousFeatures);
        for (i = this.numByteFeatures + this.numShortFeatures; i < this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures; ++i) {
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
                out.writeUTF(this.floatWeightFuncts[i - this.numByteFeatures - this.numShortFeatures]);
            } else {
                out.writeFloat(0.0f);
                out.writeUTF("");
            }
            out.writeUTF(this.getFeatureName(i));
        }
    }

    private void writeBinaryTo(DataOutput out, List<Integer> featuresToDrop) throws IOException {
        int numValues;
        int i;
        int droppedByteFeatures = 0;
        int droppedShortFeatures = 0;
        int droppedContinuousFeatures = 0;
        for (int f : featuresToDrop) {
            if (f < this.numByteFeatures) {
                ++droppedByteFeatures;
                continue;
            }
            if (f < this.numByteFeatures + this.numShortFeatures) {
                ++droppedShortFeatures;
                continue;
            }
            if (f >= this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures) continue;
            ++droppedContinuousFeatures;
        }
        out.writeInt(this.numByteFeatures - droppedByteFeatures);
        for (i = 0; i < this.numByteFeatures; ++i) {
            if (featuresToDrop.contains(i)) continue;
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
            } else {
                out.writeFloat(0.0f);
            }
            out.writeUTF(this.getFeatureName(i));
            numValues = this.getNumberOfValues(i);
            byte numValuesEncoded = (byte)numValues;
            out.writeByte(numValuesEncoded);
            for (int b = 0; b < numValues; ++b) {
                String value = this.getFeatureValueAsString(i, b);
                out.writeUTF(value);
            }
        }
        out.writeInt(this.numShortFeatures - droppedShortFeatures);
        for (i = this.numByteFeatures; i < this.numByteFeatures + this.numShortFeatures; ++i) {
            if (featuresToDrop.contains(i)) continue;
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
            } else {
                out.writeFloat(0.0f);
            }
            out.writeUTF(this.getFeatureName(i));
            numValues = (short)this.getNumberOfValues(i);
            out.writeShort(numValues);
            for (int b = 0; b < numValues; b = (int)((short)(b + 1))) {
                String value = this.getFeatureValueAsString(i, b);
                out.writeUTF(value);
            }
        }
        out.writeInt(this.numContinuousFeatures - droppedContinuousFeatures);
        for (i = this.numByteFeatures + this.numShortFeatures; i < this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures; ++i) {
            if (featuresToDrop.contains(i)) continue;
            if (this.featureWeights != null) {
                out.writeFloat(this.featureWeights[i]);
                out.writeUTF(this.floatWeightFuncts[i - this.numByteFeatures - this.numShortFeatures]);
            } else {
                out.writeFloat(0.0f);
                out.writeUTF("");
            }
            out.writeUTF(this.getFeatureName(i));
        }
    }

    public int getNumberOfFeatures() {
        return this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures;
    }

    public int getNumberOfByteFeatures() {
        return this.numByteFeatures;
    }

    public int getNumberOfShortFeatures() {
        return this.numShortFeatures;
    }

    public int getNumberOfContinuousFeatures() {
        return this.numContinuousFeatures;
    }

    public float getWeight(int featureIndex) {
        return this.featureWeights[featureIndex];
    }

    public float[] getFeatureWeights() {
        return this.featureWeights;
    }

    public String getWeightFunctionName(int featureIndex) {
        return this.floatWeightFuncts[featureIndex - this.numByteFeatures - this.numShortFeatures];
    }

    public String getFeatureName(int index) {
        return this.featureNames.get(index);
    }

    public String[] getFeatureNameArray(int[] index) {
        String[] ret = new String[index.length];
        for (int i = 0; i < index.length; ++i) {
            ret[i] = this.getFeatureName(index[i]);
        }
        return ret;
    }

    public String[] getFeatureNameArray() {
        String[] names = new String[this.getNumberOfFeatures()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getFeatureName(i);
        }
        return names;
    }

    public String[] getByteFeatureNameArray() {
        String[] byteFeatureNames = new String[this.numByteFeatures];
        for (int i = 0; i < this.numByteFeatures; ++i) {
            assert (this.isByteFeature(i));
            byteFeatureNames[i] = this.getFeatureName(i);
        }
        return byteFeatureNames;
    }

    public String[] getShortFeatureNameArray() {
        String[] shortFeatureNames = new String[this.numShortFeatures];
        for (int i = 0; i < this.numShortFeatures; ++i) {
            int shortFeatureIndex = this.numByteFeatures + i;
            assert (this.isShortFeature(shortFeatureIndex));
            shortFeatureNames[i] = this.getFeatureName(shortFeatureIndex);
        }
        return shortFeatureNames;
    }

    public String[] getContinuousFeatureNameArray() {
        String[] continuousFeatureNames = new String[this.numContinuousFeatures];
        for (int i = 0; i < this.numContinuousFeatures; ++i) {
            int continuousFeatureIndex = this.numByteFeatures + this.numShortFeatures + i;
            assert (this.isContinuousFeature(continuousFeatureIndex));
            continuousFeatureNames[i] = this.getFeatureName(continuousFeatureIndex);
        }
        return continuousFeatureNames;
    }

    public String getFeatureNames() {
        StringBuilder buf = new StringBuilder();
        int n = this.getNumberOfFeatures();
        for (int i = 0; i < n; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.featureNames.get(i));
        }
        return buf.toString();
    }

    public boolean hasFeature(String name) {
        return this.featureNames.contains(name);
    }

    public boolean hasFeatureValue(String featureName, String featureValue) {
        return this.hasFeatureValue(this.getFeatureIndex(featureName), featureValue);
    }

    public boolean hasFeatureValue(int featureIndex, String featureValue) {
        if (featureIndex < 0) {
            return false;
        }
        if (featureIndex < this.numByteFeatures) {
            return this.byteFeatureValues[featureIndex].contains(featureValue);
        }
        if (featureIndex < this.numByteFeatures + this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex - this.numByteFeatures].contains(featureValue);
        }
        return false;
    }

    public boolean isByteFeature(String featureName) {
        try {
            int index = this.getFeatureIndex(featureName);
            return this.isByteFeature(index);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isByteFeature(int index) {
        return 0 <= index && index < this.numByteFeatures;
    }

    public boolean isShortFeature(String featureName) {
        try {
            int index = this.getFeatureIndex(featureName);
            return this.isShortFeature(index);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isShortFeature(int index) {
        return 0 <= (index -= this.numByteFeatures) && index < this.numShortFeatures;
    }

    public boolean isContinuousFeature(String featureName) {
        try {
            int index = this.getFeatureIndex(featureName);
            return this.isContinuousFeature(index);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isContinuousFeature(int index) {
        index -= this.numByteFeatures;
        return 0 <= (index -= this.numShortFeatures) && index < this.numContinuousFeatures;
    }

    public boolean hasSimilarityMatrix(int featureIndex) {
        if (featureIndex >= this.getNumberOfByteFeatures()) {
            return false;
        }
        return this.similarityMatrices != null && this.similarityMatrices[featureIndex] != null;
    }

    public boolean hasSimilarityMatrix(String featureName) {
        return this.hasSimilarityMatrix(this.getFeatureIndex(featureName));
    }

    public float getSimilarity(int featureIndex, byte i, byte j) {
        if (!this.hasSimilarityMatrix(featureIndex)) {
            throw new RuntimeException("the given feature index  ");
        }
        return this.similarityMatrices[featureIndex][i][j];
    }

    public int getFeatureIndex(String featureName) {
        return this.featureNames.get(featureName);
    }

    public int[] getFeatureIndexArray(String[] featureName) {
        int[] ret = new int[featureName.length];
        for (int i = 0; i < featureName.length; ++i) {
            ret[i] = this.getFeatureIndex(featureName[i]);
        }
        return ret;
    }

    public int getNumberOfValues(int featureIndex) {
        if (featureIndex < this.numByteFeatures) {
            return this.byteFeatureValues[featureIndex].getNumberOfValues();
        }
        if ((featureIndex -= this.numByteFeatures) < this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex].getNumberOfValues();
        }
        throw new IndexOutOfBoundsException("Feature no. " + featureIndex + " is not a byte-valued or short-valued feature");
    }

    public String[] getPossibleValues(int featureIndex) {
        if (featureIndex < this.numByteFeatures) {
            return this.byteFeatureValues[featureIndex].getStringValues();
        }
        if ((featureIndex -= this.numByteFeatures) < this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex].getStringValues();
        }
        throw new IndexOutOfBoundsException("Feature no. " + featureIndex + " is not a byte-valued or short-valued feature");
    }

    public String getFeatureValueAsString(int featureIndex, int value) {
        if (featureIndex < this.numByteFeatures) {
            return this.byteFeatureValues[featureIndex].get((byte)value);
        }
        if ((featureIndex -= this.numByteFeatures) < this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex].get((short)value);
        }
        throw new IndexOutOfBoundsException("Feature no. " + featureIndex + " is not a byte-valued or short-valued feature");
    }

    public String getFeatureValueAsString(String featureName, FeatureVector fv) {
        int i = this.getFeatureIndex(featureName);
        return this.getFeatureValueAsString(i, fv.getFeatureAsInt(i));
    }

    public byte getFeatureValueAsByte(String featureName, String value) {
        int featureIndex = this.getFeatureIndex(featureName);
        return this.getFeatureValueAsByte(featureIndex, value);
    }

    public byte getFeatureValueAsByte(int featureIndex, String value) {
        if (featureIndex >= this.numByteFeatures) {
            throw new IndexOutOfBoundsException("Feature no. " + featureIndex + " is not a byte-valued feature");
        }
        try {
            return this.byteFeatureValues[featureIndex].get(value);
        }
        catch (IllegalArgumentException iae) {
            StringBuilder message = new StringBuilder("Illegal value '" + value + "' for feature " + this.getFeatureName(featureIndex) + "; Legal values are:\n");
            for (String v : this.getPossibleValues(featureIndex)) {
                message.append(" " + v);
            }
            throw new IllegalArgumentException(message.toString());
        }
    }

    public short getFeatureValueAsShort(String featureName, String value) {
        int featureIndex = this.getFeatureIndex(featureName);
        if ((featureIndex -= this.numByteFeatures) < this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex].get(value);
        }
        throw new IndexOutOfBoundsException("Feature '" + featureName + "' is not a short-valued feature");
    }

    public short getFeatureValueAsShort(int featureIndex, String value) {
        if ((featureIndex -= this.numByteFeatures) < this.numShortFeatures) {
            return this.shortFeatureValues[featureIndex].get(value);
        }
        throw new IndexOutOfBoundsException("Feature no. " + featureIndex + " is not a short-valued feature");
    }

    public boolean featureEquals(FeatureDefinition other) {
        int i;
        if (this.numByteFeatures != other.numByteFeatures || this.numShortFeatures != other.numShortFeatures || this.numContinuousFeatures != other.numContinuousFeatures) {
            return false;
        }
        for (i = 0; i < this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures; ++i) {
            if (this.getFeatureName(i).equals(other.getFeatureName(i))) continue;
            return false;
        }
        for (i = 0; i < this.numByteFeatures + this.numShortFeatures; ++i) {
            if (this.getNumberOfValues(i) != other.getNumberOfValues(i)) {
                return false;
            }
            int n = this.getNumberOfValues(i);
            for (int v = 0; v < n; ++v) {
                if (this.getFeatureValueAsString(i, v).equals(other.getFeatureValueAsString(i, v))) continue;
                return false;
            }
        }
        return true;
    }

    public String featureEqualsAnalyse(FeatureDefinition other) {
        int i;
        if (this.numByteFeatures != other.numByteFeatures) {
            return "The number of BYTE features differs: " + this.numByteFeatures + " versus " + other.numByteFeatures;
        }
        if (this.numShortFeatures != other.numShortFeatures) {
            return "The number of SHORT features differs: " + this.numShortFeatures + " versus " + other.numShortFeatures;
        }
        if (this.numContinuousFeatures != other.numContinuousFeatures) {
            return "The number of CONTINUOUS features differs: " + this.numContinuousFeatures + " versus " + other.numContinuousFeatures;
        }
        for (i = 0; i < this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures; ++i) {
            if (this.getFeatureName(i).equals(other.getFeatureName(i))) continue;
            return "The feature name differs at position [" + i + "]: " + this.getFeatureName(i) + " versus " + other.getFeatureName(i);
        }
        for (i = 0; i < this.numByteFeatures + this.numShortFeatures; ++i) {
            if (this.getNumberOfValues(i) != other.getNumberOfValues(i)) {
                return "The number of values differs at position [" + i + "]: " + this.getNumberOfValues(i) + " versus " + other.getNumberOfValues(i);
            }
            int n = this.getNumberOfValues(i);
            for (int v = 0; v < n; ++v) {
                if (this.getFeatureValueAsString(i, v).equals(other.getFeatureValueAsString(i, v))) continue;
                return "The feature value differs at position [" + i + "] for feature value [" + v + "]: " + this.getFeatureValueAsString(i, v) + " versus " + other.getFeatureValueAsString(i, v);
            }
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureDefinition)) {
            return false;
        }
        FeatureDefinition other = (FeatureDefinition)obj;
        if (this.featureWeights == null) {
            if (other.featureWeights != null) {
                return false;
            }
        } else {
            int i;
            if (other.featureWeights == null) {
                return false;
            }
            if (this.featureWeights.length != other.featureWeights.length) {
                return false;
            }
            for (i = 0; i < this.featureWeights.length; ++i) {
                if (this.featureWeights[i] == other.featureWeights[i]) continue;
                return false;
            }
            assert (this.floatWeightFuncts != null);
            assert (other.floatWeightFuncts != null);
            if (this.floatWeightFuncts.length != other.floatWeightFuncts.length) {
                return false;
            }
            for (i = 0; i < this.floatWeightFuncts.length; ++i) {
                if (this.floatWeightFuncts[i] == null) {
                    if (other.floatWeightFuncts[i] == null) continue;
                    return false;
                }
                if (other.floatWeightFuncts[i] == null) {
                    return false;
                }
                if (this.floatWeightFuncts[i].equals(other.floatWeightFuncts[i])) continue;
                return false;
            }
        }
        return this.featureEquals(other);
    }

    public boolean contains(FeatureDefinition other) {
        List<String> otherContinuousFeatures;
        List<String> otherShortFeatures;
        List<String> otherByteFeatures;
        List<String> thisByteFeatures = Arrays.asList(this.getByteFeatureNameArray());
        if (!thisByteFeatures.containsAll(otherByteFeatures = Arrays.asList(other.getByteFeatureNameArray()))) {
            return false;
        }
        for (String commonByteFeature : otherByteFeatures) {
            Object[] otherByteFeaturePossibleValues;
            Object[] thisByteFeaturePossibleValues = this.getPossibleValues(this.getFeatureIndex(commonByteFeature));
            if (Arrays.equals(thisByteFeaturePossibleValues, otherByteFeaturePossibleValues = other.getPossibleValues(other.getFeatureIndex(commonByteFeature)))) continue;
            return false;
        }
        List<String> thisShortFeatures = Arrays.asList(this.getShortFeatureNameArray());
        if (!thisShortFeatures.containsAll(otherShortFeatures = Arrays.asList(other.getShortFeatureNameArray()))) {
            return false;
        }
        for (String commonShortFeature : otherShortFeatures) {
            Object[] otherShortFeaturePossibleValues;
            Object[] thisShortFeaturePossibleValues = this.getPossibleValues(this.getFeatureIndex(commonShortFeature));
            if (Arrays.equals(thisShortFeaturePossibleValues, otherShortFeaturePossibleValues = other.getPossibleValues(other.getFeatureIndex(commonShortFeature)))) continue;
            return false;
        }
        List<String> thisContinuousFeatures = Arrays.asList(this.getContinuousFeatureNameArray());
        return thisContinuousFeatures.containsAll(otherContinuousFeatures = Arrays.asList(other.getContinuousFeatureNameArray()));
    }

    public FeatureDefinition subset(String[] featureNamesToDrop) {
        ArrayList<Integer> featureIndicesToDrop = new ArrayList<Integer>();
        for (String featureName : featureNamesToDrop) {
            try {
                int featureIndex = this.getFeatureIndex(featureName);
                featureIndicesToDrop.add(featureIndex);
            }
            catch (IllegalArgumentException e) {
                System.err.println("WARNING: feature " + featureName + " not found in FeatureDefinition; ignoring.");
            }
        }
        FeatureDefinition subDefinition = null;
        try {
            ByteArrayOutputStream toMemory = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(toMemory);
            this.writeBinaryTo(output, featureIndicesToDrop);
            byte[] memory = toMemory.toByteArray();
            ByteArrayInputStream fromMemory = new ByteArrayInputStream(memory);
            DataInputStream input = new DataInputStream(fromMemory);
            subDefinition = new FeatureDefinition(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (this.contains(subDefinition));
        return subDefinition;
    }

    public FeatureVector toFeatureVector(int unitIndex, String featureString) {
        int i;
        String[] featureValues = featureString.split("\\s+");
        if (featureValues.length != this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures) {
            throw new IllegalArgumentException("Expected " + (this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures) + " features, got " + featureValues.length);
        }
        byte[] bytes = new byte[this.numByteFeatures];
        short[] shorts = new short[this.numShortFeatures];
        float[] floats = new float[this.numContinuousFeatures];
        for (i = 0; i < this.numByteFeatures; ++i) {
            bytes[i] = Byte.parseByte(featureValues[i]);
        }
        for (i = 0; i < this.numShortFeatures; ++i) {
            shorts[i] = Short.parseShort(featureValues[this.numByteFeatures + i]);
        }
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            floats[i] = Float.parseFloat(featureValues[this.numByteFeatures + this.numShortFeatures + i]);
        }
        return new FeatureVector(bytes, shorts, floats, unitIndex);
    }

    public FeatureVector toFeatureVector(int unitIndex, byte[] bytes, short[] shorts, float[] floats) {
        if ((this.numByteFeatures != 0 || bytes != null) && this.numByteFeatures != bytes.length || (this.numShortFeatures != 0 || shorts != null) && this.numShortFeatures != shorts.length || (this.numContinuousFeatures != 0 || floats != null) && this.numContinuousFeatures != floats.length) {
            throw new IllegalArgumentException("Expected " + this.numByteFeatures + " bytes (got " + (bytes == null ? NULLVALUE : Integer.valueOf(bytes.length)) + "), " + this.numShortFeatures + " shorts (got " + (shorts == null ? NULLVALUE : Integer.valueOf(shorts.length)) + "), " + this.numContinuousFeatures + " floats (got " + (floats == null ? NULLVALUE : Integer.valueOf(floats.length)) + ")");
        }
        return new FeatureVector(bytes, shorts, floats, unitIndex);
    }

    public FeatureVector readFeatureVector(int currentUnitIndex, DataInput input) throws IOException {
        byte[] bytes = new byte[this.numByteFeatures];
        input.readFully(bytes);
        short[] shorts = new short[this.numShortFeatures];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = input.readShort();
        }
        float[] floats = new float[this.numContinuousFeatures];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = input.readFloat();
        }
        return new FeatureVector(bytes, shorts, floats, currentUnitIndex);
    }

    public FeatureVector readFeatureVector(int currentUnitIndex, ByteBuffer bb) throws IOException {
        byte[] bytes = new byte[this.numByteFeatures];
        bb.get(bytes);
        short[] shorts = new short[this.numShortFeatures];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = bb.getShort();
        }
        float[] floats = new float[this.numContinuousFeatures];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = bb.getFloat();
        }
        return new FeatureVector(bytes, shorts, floats, currentUnitIndex);
    }

    public FeatureVector createEdgeFeatureVector(int unitIndex, boolean start) {
        int i;
        int edgeFeature = this.getFeatureIndex(EDGEFEATURE);
        assert (edgeFeature < this.numByteFeatures);
        byte edge = start ? this.getFeatureValueAsByte(edgeFeature, EDGEFEATURE_START) : this.getFeatureValueAsByte(edgeFeature, EDGEFEATURE_END);
        byte[] bytes = new byte[this.numByteFeatures];
        short[] shorts = new short[this.numShortFeatures];
        float[] floats = new float[this.numContinuousFeatures];
        for (i = 0; i < this.numByteFeatures; ++i) {
            bytes[i] = this.getFeatureValueAsByte(i, NULLVALUE);
        }
        for (i = 0; i < this.numShortFeatures; ++i) {
            shorts[i] = this.getFeatureValueAsShort(this.numByteFeatures + i, NULLVALUE);
        }
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            floats[i] = 0.0f;
        }
        bytes[edgeFeature] = edge;
        return new FeatureVector(bytes, shorts, floats, unitIndex);
    }

    public String toFeatureString(FeatureVector fv) {
        int i;
        if (this.numByteFeatures != fv.getNumberOfByteFeatures() || this.numShortFeatures != fv.getNumberOfShortFeatures() || this.numContinuousFeatures != fv.getNumberOfContinuousFeatures()) {
            throw new IllegalArgumentException("Feature vector '" + fv + "' is inconsistent with feature definition");
        }
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < this.numByteFeatures; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.getFeatureValueAsString(i, fv.getByteFeature(i)));
        }
        for (i = this.numByteFeatures; i < this.numByteFeatures + this.numShortFeatures; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(this.getFeatureValueAsString(i, fv.getShortFeature(i)));
        }
        for (i = this.numByteFeatures + this.numShortFeatures; i < this.numByteFeatures + this.numShortFeatures + this.numContinuousFeatures; ++i) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(fv.getContinuousFeature(i));
        }
        return buf.toString();
    }

    public void writeTo(PrintWriter out, boolean writeWeights) {
        String val;
        int v;
        int vmax;
        int i;
        out.println(BYTEFEATURES);
        for (i = 0; i < this.numByteFeatures; ++i) {
            if (writeWeights) {
                out.print(this.featureWeights[i] + " | ");
            }
            out.print(this.getFeatureName(i));
            vmax = this.getNumberOfValues(i);
            for (v = 0; v < vmax; ++v) {
                out.print(" ");
                val = this.getFeatureValueAsString(i, v);
                out.print(val);
            }
            out.println();
        }
        out.println(SHORTFEATURES);
        for (i = 0; i < this.numShortFeatures; ++i) {
            if (writeWeights) {
                out.print(this.featureWeights[this.numByteFeatures + i] + " | ");
            }
            out.print(this.getFeatureName(this.numByteFeatures + i));
            vmax = this.getNumberOfValues(this.numByteFeatures + i);
            for (v = 0; v < vmax; ++v) {
                out.print(" ");
                val = this.getFeatureValueAsString(this.numByteFeatures + i, v);
                out.print(val);
            }
            out.println();
        }
        out.println(CONTINUOUSFEATURES);
        for (i = 0; i < this.numContinuousFeatures; ++i) {
            if (writeWeights) {
                out.print(this.featureWeights[this.numByteFeatures + this.numShortFeatures + i]);
                out.print(" ");
                out.print(this.floatWeightFuncts[i]);
                out.print(" | ");
            }
            out.print(this.getFeatureName(this.numByteFeatures + this.numShortFeatures + i));
            out.println();
        }
    }

    public void generateAllDotDescForWagon(PrintWriter out) {
        this.generateAllDotDescForWagon(out, null);
    }

    public void generateAllDotDescForWagon(PrintWriter out, Set<String> featuresToIgnore) {
        out.println("(");
        out.println("(occurid cluster)");
        int n = this.getNumberOfFeatures();
        for (int i = 0; i < n; ++i) {
            out.print("( ");
            String featureName = this.getFeatureName(i);
            out.print(featureName);
            if (featuresToIgnore != null && featuresToIgnore.contains(featureName)) {
                out.print(" ignore");
            }
            if (i < this.numByteFeatures + this.numShortFeatures) {
                int vmax = this.getNumberOfValues(i);
                for (int v = 0; v < vmax; ++v) {
                    out.print("  ");
                    String val = this.getFeatureValueAsString(i, v);
                    if (val.indexOf(34) != -1) {
                        StringBuilder buf = new StringBuilder();
                        for (int c = 0; c < val.length(); ++c) {
                            char ch = val.charAt(c);
                            if (ch == '\"') {
                                buf.append("\\\"");
                                continue;
                            }
                            buf.append(ch);
                        }
                        val = buf.toString();
                    }
                    out.print("\"" + val + "\"");
                }
                out.println(" )");
                continue;
            }
            out.println(" float )");
        }
        out.println(")");
    }

    public void generateFeatureWeightsFile(PrintWriter out) {
        String val;
        int v;
        int vmax;
        String featureName;
        int i;
        out.println("# This file lists the features and their weights to be used for\n# creating the MARY features file.\n# The same file can also be used to override weights in a run-time system.\n# Three sections are distinguished: Byte-valued, Short-valued, and\n# Continuous features.\n#\n# Lines starting with '#' are ignored; they can be used for comments\n# anywhere in the file. Empty lines are also ignored.\n# Entries must have the following form:\n# \n# <weight definition> | <feature definition>\n# \n# For byte and short features, <weight definition> is simply the \n# (float) number representing the weight.\n# For continuous features, <weight definition> is the\n# (float) number representing the weight, followed by an optional\n# weighting function including arguments.\n#\n# The <feature definition> is the feature name, which in the case of\n# byte and short features is followed by the full list of feature values.\n#\n# Note that the feature definitions must be identical between this file\n# and all unit feature files for individual database utterances.\n# THIS FILE WAS GENERATED AUTOMATICALLY");
        out.println();
        out.println(BYTEFEATURES);
        ArrayList<String> getValuesOf10 = new ArrayList<String>();
        getValuesOf10.add("phone");
        getValuesOf10.add("ph_vc");
        getValuesOf10.add("prev_phone");
        getValuesOf10.add("next_phone");
        getValuesOf10.add("stressed");
        getValuesOf10.add("syl_break");
        getValuesOf10.add("prev_syl_break");
        getValuesOf10.add("next_is_pause");
        getValuesOf10.add("prev_is_pause");
        ArrayList<String> getValuesOf5 = new ArrayList<String>();
        getValuesOf5.add("cplace");
        getValuesOf5.add("ctype");
        getValuesOf5.add("cvox");
        getValuesOf5.add("vfront");
        getValuesOf5.add("vheight");
        getValuesOf5.add("vlng");
        getValuesOf5.add("vrnd");
        getValuesOf5.add("vc");
        for (i = 0; i < this.numByteFeatures; ++i) {
            featureName = this.getFeatureName(i);
            if (getValuesOf10.contains(featureName)) {
                out.print("10 | " + featureName);
            } else {
                boolean found = false;
                for (String match : getValuesOf5) {
                    if (!featureName.matches(".*" + match)) continue;
                    out.print("5 | " + featureName);
                    found = true;
                    break;
                }
                if (!found) {
                    out.print("0 | " + featureName);
                }
            }
            vmax = this.getNumberOfValues(i);
            for (v = 0; v < vmax; ++v) {
                val = this.getFeatureValueAsString(i, v);
                out.print(" " + val);
            }
            out.print("\n");
        }
        out.println(SHORTFEATURES);
        for (i = this.numByteFeatures; i < this.numShortFeatures; ++i) {
            featureName = this.getFeatureName(i);
            out.print("0 | " + featureName);
            vmax = this.getNumberOfValues(i);
            for (v = 0; v < vmax; ++v) {
                val = this.getFeatureValueAsString(i, v);
                out.print(" " + val);
            }
            out.print("\n");
        }
        out.println(CONTINUOUSFEATURES);
        for (i = this.numByteFeatures; i < this.numByteFeatures + this.numContinuousFeatures; ++i) {
            featureName = this.getFeatureName(i);
            out.println("0 linear | " + featureName);
        }
        out.flush();
        out.close();
    }

    public static int diff(FeatureVector v1, FeatureVector v2) {
        int i;
        int ret = 0;
        if (v1.byteValuedDiscreteFeatures.length < v2.byteValuedDiscreteFeatures.length) {
            throw new RuntimeException("v1 and v2 don't have the same number of byte-valued features: [" + v1.byteValuedDiscreteFeatures.length + "] versus [" + v2.byteValuedDiscreteFeatures.length + "].");
        }
        for (i = 0; i < v1.byteValuedDiscreteFeatures.length; ++i) {
            if (v1.byteValuedDiscreteFeatures[i] != v2.byteValuedDiscreteFeatures[i]) continue;
            ++ret;
        }
        if (v1.shortValuedDiscreteFeatures.length < v2.shortValuedDiscreteFeatures.length) {
            throw new RuntimeException("v1 and v2 don't have the same number of short-valued features: [" + v1.shortValuedDiscreteFeatures.length + "] versus [" + v2.shortValuedDiscreteFeatures.length + "].");
        }
        for (i = 0; i < v1.shortValuedDiscreteFeatures.length; ++i) {
            if (v1.shortValuedDiscreteFeatures[i] != v2.shortValuedDiscreteFeatures[i]) continue;
            ++ret;
        }
        return ret;
    }
}

