/*
 * Decompiled with CFR 0.152.
 */
package marytts.datatypes;

import com.google.common.base.Objects;
import com.sun.speech.freetts.Utterance;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryDataType;
import marytts.datatypes.MaryXML;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AppendableSequenceAudioInputStream;
import marytts.util.data.audio.SequenceAudioInputStream;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryNormalisedWriter;
import marytts.util.io.FileUtils;
import marytts.util.io.ReaderSplitter;
import marytts.util.string.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MaryData {
    private MaryDataType type;
    private Locale locale;
    private String outputParams = null;
    private Document xmlDocument = null;
    private String plainText = null;
    private AudioInputStream audio = null;
    private AudioFileFormat audioFileFormat = null;
    private List<Utterance> utterances = null;
    private Logger logger = MaryUtils.getLogger("IO");
    private Voice defaultVoice = null;
    private String defaultStyle = "";
    private String defaultEffects = "";
    private MaryNormalisedWriter writer = null;
    private boolean doValidate;
    private boolean doWarnClient = false;

    public MaryData(MaryDataType type, Locale locale) {
        this(type, locale, false);
    }

    public MaryData(MaryDataType type, Locale locale, boolean createStubDocument) {
        if (type == null) {
            throw new NullPointerException("Received null type for MaryData");
        }
        this.type = type;
        this.locale = locale;
        this.doValidate = MaryProperties.getBoolean("maryxml.validate.modules", false);
        if (createStubDocument && type.isMaryXML()) {
            this.xmlDocument = MaryXML.newDocument();
        }
    }

    public boolean getValidating() {
        return this.doValidate;
    }

    public void setValidating(boolean doValidate) throws ParserConfigurationException {
        this.doValidate = doValidate;
    }

    @Deprecated
    public boolean getWarnClient() {
        return this.doWarnClient;
    }

    @Deprecated
    public void setWarnClient(boolean doWarnClient) {
    }

    public MaryDataType getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void readFrom(InputStream is) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        this.readFrom(is, null);
    }

    public void readFrom(InputStream is, String endMarker) throws ParserConfigurationException, SAXException, IOException, TransformerConfigurationException, TransformerException {
        if (this.type.isUtterances()) {
            throw new IOException("Cannot read into utterance-based data type!");
        }
        if (this.type.isXMLType() || this.type.isTextType()) {
            this.readFrom(new InputStreamReader(is, "UTF-8"), endMarker);
        } else {
            this.setAudio((AudioInputStream)is);
        }
    }

    public void readFrom(Reader from) throws ParserConfigurationException, SAXException, IOException {
        String inputData = FileUtils.getReaderAsString(from);
        this.setData(inputData);
    }

    public void readFrom(Reader from, String endMarker) throws ParserConfigurationException, SAXException, IOException {
        Reader r = from;
        if (endMarker != null) {
            ReaderSplitter fromSplitter = new ReaderSplitter(from, endMarker);
            r = fromSplitter.nextReader();
        }
        this.readFrom(r);
    }

    public void setData(String dataString) throws ParserConfigurationException, SAXException, IOException {
        dataString = StringUtils.purgeNonBreakingSpaces(dataString);
        if (this.type.isXMLType()) {
            this.logger.debug("Parsing XML input (" + (this.doValidate ? "" : "non-") + "validating): " + dataString);
            this.xmlDocument = DomUtils.parseDocument(dataString, this.doValidate);
        } else if (this.type.isTextType()) {
            this.logger.debug("Setting text input: " + dataString);
            this.plainText = dataString;
        } else {
            throw new IllegalArgumentException("Cannot set data of type " + this.type + " from a string");
        }
    }

    public void writeTo(OutputStream os) throws TransformerConfigurationException, FileNotFoundException, TransformerException, IOException, Exception {
        if (this.type.isUtterances()) {
            throw new IOException("Cannot write out utterance-based data type!");
        }
        if (this.type.isXMLType()) {
            if (this.writer == null) {
                this.writer = new MaryNormalisedWriter();
            }
            if (this.logger.getEffectiveLevel().equals(Level.DEBUG)) {
                ByteArrayOutputStream debugOut = new ByteArrayOutputStream();
                this.writer.output(this.xmlDocument, debugOut);
                this.logger.debug(debugOut.toString());
            }
            this.writer.output(this.xmlDocument, new BufferedOutputStream(os));
        } else if (this.type.isTextType()) {
            this.writeTo(new OutputStreamWriter(os, "UTF-8"));
        } else {
            this.logger.debug("Writing audio output, frame length " + this.audio.getFrameLength());
            AudioSystem.write(this.audio, this.audioFileFormat.getType(), os);
            os.flush();
            os.close();
        }
    }

    public void writeTo(Writer w) throws TransformerConfigurationException, FileNotFoundException, TransformerException, IOException, Exception {
        if (this.type.isUtterances()) {
            throw new IOException("Cannot write out utterance-based data type!");
        }
        if (this.type.isXMLType()) {
            throw new IOException("Better write XML data to an OutputStream, not to a Writer");
        }
        if (!this.type.isTextType()) {
            throw new Exception("Illegal attempt to write audio data to a character Writer");
        }
        w.write(this.plainText);
        w.flush();
        this.logger.debug("Writing Text output:\n" + this.plainText);
    }

    public Object getData() {
        if (this.type.isXMLType()) {
            return this.xmlDocument;
        }
        if (this.type.isTextType()) {
            return this.plainText;
        }
        if (this.type.isUtterances()) {
            return this.utterances;
        }
        return this.audio;
    }

    public String getPlainText() {
        return this.plainText;
    }

    public void setPlainText(String plainText) {
        this.plainText = plainText;
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public void setDocument(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public AudioInputStream getAudio() {
        return this.audio;
    }

    public void setAudio(AudioInputStream audio) {
        this.audio = audio;
    }

    public List<Utterance> getUtterances() {
        return this.utterances;
    }

    public void setUtterances(List<Utterance> utterances) {
        this.utterances = utterances;
    }

    public void setDefaultVoice(Voice voice) {
        if (voice == null) {
            return;
        }
        Locale voiceLocale = null;
        voiceLocale = voice.getLocale();
        Locale docLocale = this.getLocale();
        if (docLocale == null && this.getType().isXMLType() && this.getDocument() != null && this.getDocument().getDocumentElement().hasAttribute("xml:lang")) {
            docLocale = MaryUtils.string2locale(this.getDocument().getDocumentElement().getAttribute("xml:lang"));
        }
        if (docLocale != null && voiceLocale != null && !MaryUtils.subsumes(docLocale, voiceLocale) && !MaryUtils.subsumes(voiceLocale, docLocale)) {
            this.logger.warn("Voice `" + voice.getName() + "' does not match document locale `" + docLocale + "' -- ignoring!");
        }
        this.defaultVoice = voice;
    }

    public Voice getDefaultVoice() {
        return this.defaultVoice;
    }

    public void setDefaultStyle(String style) {
        this.defaultStyle = style;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultEffects(String effects) {
        this.defaultEffects = effects;
    }

    public String getDefaultEffects() {
        return this.defaultEffects;
    }

    public void setAudioFileFormat(AudioFileFormat audioFileFormat) {
        this.audioFileFormat = audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat() {
        return this.audioFileFormat;
    }

    public void append(MaryData md) {
        if (md == null) {
            throw new NullPointerException("Received null marydata");
        }
        if (!md.getType().equals(this.getType())) {
            throw new IllegalArgumentException("Cannot append mary data of type `" + md.getType().name() + "' to mary data of type `" + this.getType().name() + "'");
        }
        if (this.getType().isXMLType()) {
            NodeList kids = md.getDocument().getDocumentElement().getChildNodes();
            this.logger.debug("Appending " + kids.getLength() + " nodes to MaryXML structure");
            Element docEl = this.getDocument().getDocumentElement();
            for (int i = 0; i < kids.getLength(); ++i) {
                docEl.appendChild(this.getDocument().importNode(kids.item(i), true));
            }
        } else if (this.getType().isTextType()) {
            this.plainText = this.plainText == null ? md.getPlainText() : this.plainText + "\n\n" + md.getPlainText();
        } else if (this.getType().equals(MaryDataType.get("AUDIO"))) {
            this.appendAudio(md.getAudio());
        } else {
            throw new UnsupportedOperationException("Cannot append two mary data items of type `" + this.getType() + "'");
        }
    }

    public void appendAudio(AudioInputStream audioToAppend) {
        if (this.audio == null) {
            this.setAudio(audioToAppend);
        } else if (this.audio instanceof AppendableSequenceAudioInputStream) {
            ((AppendableSequenceAudioInputStream)this.audio).append(audioToAppend);
        } else {
            this.audio = new SequenceAudioInputStream(this.audio.getFormat(), Arrays.asList(this.audio, audioToAppend));
        }
    }

    public void setOutputParams(String params) {
        this.outputParams = params;
    }

    public String getOutputParams() {
        return this.outputParams;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("type", this.getType()).add("locale", this.getLocale()).add("output parameters", this.getOutputParams()).add("data", this.getData()).add("document", DomUtils.serializeToString(this.getDocument())).add("validating", this.getValidating()).add("plain text", this.getPlainText()).add("utterances", this.getUtterances()).add("audio", this.getAudio()).add("audio file format", this.getAudioFileFormat()).toString();
    }
}

