/*
 * Decompiled with CFR 0.152.
 */
package marytts.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import marytts.Version;
import marytts.client.MaryFormData;
import marytts.client.MarySocketClient;
import marytts.client.http.MaryHttpClient;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.http.Address;

public abstract class MaryClient {
    protected MaryFormData data;
    protected boolean beQuiet = false;
    protected boolean doProfile = false;

    public static MaryClient getMaryClient() throws IOException {
        return MaryClient.getMaryClient(null);
    }

    public static MaryClient getMaryClient(Address serverAddress) throws IOException {
        boolean profile = Boolean.getBoolean("mary.client.profile");
        boolean quiet = Boolean.getBoolean("mary.client.quiet");
        return MaryClient.getMaryClient(serverAddress, profile, quiet);
    }

    public static MaryClient getMaryClient(Address serverAddress, boolean profile, boolean quiet) throws IOException {
        MaryClient m = null;
        try {
            m = new MaryHttpClient(serverAddress, profile, quiet);
        }
        catch (IOException ioe) {
            try {
                m = new MarySocketClient(serverAddress, profile, quiet);
            }
            catch (IOException ioe2) {
                IOException ioe3 = new IOException("Cannot connect either to a HTTP nor to a Socket MARY server at " + (serverAddress != null ? serverAddress.getFullAddress() : "default location"));
                ioe3.initCause(ioe2);
                throw ioe3;
            }
        }
        return m;
    }

    protected MaryClient() throws IOException {
        boolean profile = Boolean.getBoolean("mary.client.profile");
        boolean quiet = Boolean.getBoolean("mary.client.quiet");
        this.data = new MaryFormData();
        this.initialise(profile, quiet);
    }

    protected MaryClient(boolean quiet) throws IOException {
        boolean profile = Boolean.getBoolean("mary.client.profile");
        this.data = new MaryFormData();
        this.initialise(profile, quiet);
    }

    protected MaryClient(Address serverAddress) throws IOException {
        boolean profile = Boolean.getBoolean("mary.client.profile");
        boolean quiet = Boolean.getBoolean("mary.client.quiet");
        this.data = serverAddress != null ? new MaryFormData(serverAddress) : new MaryFormData();
        this.initialise(profile, quiet);
    }

    protected MaryClient(Address serverAddress, boolean profile, boolean quiet) throws IOException {
        this.data = serverAddress != null ? new MaryFormData(serverAddress) : new MaryFormData();
        this.initialise(profile, quiet);
    }

    protected final void initialise(boolean profile, boolean quiet) throws IOException {
        this.doProfile = profile;
        this.beQuiet = quiet;
        if (!this.beQuiet) {
            System.err.println("Mary TTS client " + Version.specificationVersion() + " (impl. " + Version.implementationVersion() + ")");
        }
        try {
            this.fillServerVersion();
        }
        catch (IOException e1) {
            IOException ioe = new IOException("MARY client cannot connect to MARY server at\n" + this.data.hostAddress.getFullAddress() + "\n" + "Make sure that you have started the mary server\n" + "or specify a different host or port using \n" + "maryclient -Dserver.host=my.host.com -Dserver.port=12345");
            ioe.initCause(e1);
            throw ioe;
        }
        if (this.data.serverVersionInfo == null || !this.data.serverVersionInfo.startsWith("Mary")) {
            throw new IOException("This does not seem to be the expected kind of MARY server at " + this.data.hostAddress.getFullAddress() + "...");
        }
        if (!"unknown".equals(this.data.serverVersionNo) && !this.isServerVersionAtLeast("4.0")) {
            throw new IOException("Found old MARY server (version " + this.data.serverVersionNo + ") -- this client will only work with servers of version 4.0 or newer.");
        }
        if (!this.beQuiet) {
            System.err.print("Connected to " + this.data.hostAddress.getFullAddress() + ", ");
            System.err.println(this.data.serverVersionInfo);
            if (!this.data.serverCanStream) {
                System.err.println("Server version " + this.data.serverVersionNo + " cannot stream audio, defaulting to non-streaming");
            }
        }
        this.fillVoices();
        if (this.data.allVoices != null && this.data.allVoices.size() > 0 && this.data.allVoices.elementAt(this.data.voiceSelected).isLimitedDomain()) {
            this.data.limitedDomainExampleTexts = this.getVoiceExampleTextsLimitedDomain(this.data.allVoices.elementAt(this.data.voiceSelected).name());
        }
        if (this.data.allVoices != null && this.data.allVoices.size() > 0 && this.data.inputDataTypes != null && this.data.inputDataTypes.size() > 0) {
            this.data.inputText = this.data.allVoices.elementAt(this.data.voiceSelected).isLimitedDomain() ? this.data.limitedDomainExampleTexts.get(this.data.limitedDomainExampleTextSelected) : this.getServerExampleText(this.data.inputDataTypes.get(this.data.inputTypeSelected).name(), this.data.allVoices.elementAt(this.data.voiceSelected).getLocale().toString());
        }
    }

    public Address getAddress() {
        return this.data.hostAddress;
    }

    public String getHost() {
        return this.data.hostAddress.getHost();
    }

    public int getPort() {
        return this.data.hostAddress.getPort();
    }

    public Vector<String> getAudioFileFormatTypes() throws IOException {
        if (this.data.audioFileFormatTypes == null || this.data.audioOutTypes == null) {
            this.fillAudioFileFormatAndOutTypes();
        }
        return this.data.audioFileFormatTypes;
    }

    public Vector<String> getAudioOutTypes() throws IOException {
        if (this.data.audioFileFormatTypes == null || this.data.audioOutTypes == null) {
            this.fillAudioFileFormatAndOutTypes();
        }
        return this.data.audioOutTypes;
    }

    protected abstract void fillAudioFileFormatAndOutTypes() throws IOException;

    protected abstract void fillServerVersion() throws IOException;

    public boolean isServerVersionAtLeast(String version) throws IOException {
        if (this.data.serverVersionNo.equals("unknown")) {
            this.fillServerVersion();
        }
        return this.data.isServerVersionAtLeast(version);
    }

    public Vector<DataType> getAllDataTypes() throws IOException {
        if (this.data.allDataTypes == null) {
            this.fillDataTypes();
        }
        assert (this.data.allDataTypes != null && this.data.allDataTypes.size() > 0);
        return this.data.allDataTypes;
    }

    public Vector<DataType> getInputDataTypes() throws IOException {
        if (this.data.inputDataTypes == null) {
            this.fillDataTypes();
        }
        assert (this.data.inputDataTypes != null && this.data.inputDataTypes.size() > 0);
        return this.data.inputDataTypes;
    }

    public Vector<DataType> getOutputDataTypes() throws IOException {
        if (this.data.outputDataTypes == null) {
            this.fillDataTypes();
        }
        assert (this.data.outputDataTypes != null && this.data.outputDataTypes.size() > 0);
        return this.data.outputDataTypes;
    }

    protected abstract void fillDataTypes() throws IOException;

    public Vector<Voice> getVoices() throws IOException {
        if (this.data.allVoices == null) {
            this.fillVoices();
        }
        assert (this.data.allVoices != null && this.data.allVoices.size() > 0);
        return this.data.allVoices;
    }

    public Vector<Voice> getVoices(Locale locale) throws IOException {
        if (this.data.allVoices == null) {
            this.fillVoices();
        }
        return this.data.voicesByLocaleMap.get(locale);
    }

    public Vector<Voice> getGeneralDomainVoices() throws IOException {
        Vector<Voice> voices = this.getVoices();
        Vector<Voice> requestedVoices = new Vector<Voice>();
        for (Voice v : voices) {
            if (v.isLimitedDomain()) continue;
            requestedVoices.add(v);
        }
        if (!requestedVoices.isEmpty()) {
            return requestedVoices;
        }
        return null;
    }

    public Vector<Voice> getLimitedDomainVoices() throws IOException {
        Vector<Voice> voices = this.getVoices();
        Vector<Voice> requestedVoices = new Vector<Voice>();
        for (Voice v : voices) {
            if (!v.isLimitedDomain()) continue;
            requestedVoices.add(v);
        }
        if (!requestedVoices.isEmpty()) {
            return requestedVoices;
        }
        return null;
    }

    public Vector<Voice> getGeneralDomainVoices(Locale locale) throws IOException {
        Vector<Voice> voices = this.getVoices(locale);
        Vector<Voice> requestedVoices = new Vector<Voice>();
        for (Voice v : voices) {
            if (v.isLimitedDomain()) continue;
            requestedVoices.add(v);
        }
        if (!requestedVoices.isEmpty()) {
            return requestedVoices;
        }
        return null;
    }

    public Vector<Voice> getLimitedDomainVoices(Locale locale) throws IOException {
        Vector<Voice> voices = this.getVoices(locale);
        Vector<Voice> requestedVoices = new Vector<Voice>();
        for (Voice v : voices) {
            if (!v.isLimitedDomain()) continue;
            requestedVoices.add(v);
        }
        if (!requestedVoices.isEmpty()) {
            return requestedVoices;
        }
        return null;
    }

    protected abstract void fillVoices() throws IOException;

    public Set<Locale> getLocales() throws IOException {
        if (this.data.locales == null) {
            this.fillLocales();
        }
        return this.data.locales;
    }

    protected abstract void fillLocales() throws IOException;

    public Vector<String> getVoiceExampleTextsLimitedDomain(String voicename) throws IOException {
        if (!this.data.voiceExampleTextsLimitedDomain.containsKey(voicename)) {
            this.fillVoiceExampleTexts(voicename);
        }
        return this.data.voiceExampleTextsLimitedDomain.get(voicename);
    }

    protected abstract void fillVoiceExampleTexts(String var1) throws IOException;

    public String getServerExampleText(String dataType, String locale) throws IOException {
        if (!this.data.serverExampleTexts.containsKey(dataType + " " + locale)) {
            this.fillServerExampleText(dataType, locale);
        }
        this.data.currentExampleText = this.data.serverExampleTexts.get(dataType + " " + locale);
        return this.data.currentExampleText;
    }

    protected abstract void fillServerExampleText(String var1, String var2) throws IOException;

    protected abstract String getDefaultAudioEffects() throws IOException;

    public String getAudioEffects() throws IOException {
        if (this.data.audioEffects == null) {
            this.data.audioEffects = this.getDefaultAudioEffects();
        }
        return this.data.audioEffects;
    }

    public abstract String requestDefaultEffectParameters(String var1) throws IOException;

    public abstract String requestFullEffect(String var1, String var2) throws IOException;

    public abstract boolean isHMMEffect(String var1) throws IOException;

    public String requestEffectHelpText(String effectName) throws IOException {
        if (!this.data.audioEffectHelpTextsMap.containsKey(effectName)) {
            this.fillEffectHelpText(effectName);
        }
        return this.data.audioEffectHelpTextsMap.get(effectName);
    }

    protected abstract void fillEffectHelpText(String var1) throws IOException;

    public abstract String getFeatures(String var1) throws IOException;

    public abstract String getFeaturesForVoice(String var1) throws IOException;

    public void streamAudio(String input, String inputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, String defaultEffects, AudioPlayer audioPlayer, AudioPlayerListener listener) throws IOException {
        this._process(input, inputType, "AUDIO", locale, audioType, defaultVoiceName, defaultStyle, defaultEffects, audioPlayer, 0L, true, null, listener);
    }

    public void process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, String defaultEffects, String outputTypeParams, OutputStream output) throws IOException {
        this._process(input, inputType, outputType, locale, audioType, defaultVoiceName, defaultStyle, defaultEffects, output, 0L, false, outputTypeParams, null);
    }

    public void process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, OutputStream output) throws IOException {
        this.process(input, inputType, outputType, locale, audioType, defaultVoiceName, "", null, null, output);
    }

    public void process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, String defaultStyle, String defaultEffects, String outputTypeParams, OutputStream output, long timeout) throws IOException {
        this._process(input, inputType, outputType, locale, audioType, defaultVoiceName, defaultStyle, defaultEffects, output, timeout, false, outputTypeParams, null);
    }

    public void process(String input, String inputType, String outputType, String locale, String audioType, String defaultVoiceName, OutputStream output, long timeout) throws IOException {
        this.process(input, inputType, outputType, locale, audioType, defaultVoiceName, "", null, null, output, timeout);
    }

    protected abstract void _process(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, Object var9, long var10, boolean var12, String var13, AudioPlayerListener var14) throws IOException;

    public static AudioFileFormat.Type getAudioFileFormatType(String name) {
        AudioFileFormat.Type at;
        if (name.equals("MP3")) {
            at = new AudioFileFormat.Type("MP3", "mp3");
        } else if (name.equals("Vorbis")) {
            at = new AudioFileFormat.Type("Vorbis", "ogg");
        } else {
            try {
                at = (AudioFileFormat.Type)AudioFileFormat.Type.class.getField(name).get(null);
            }
            catch (Exception e) {
                return null;
            }
        }
        return at;
    }

    public static void usage() {
        System.err.println("usage:");
        System.err.println("java [properties] " + MaryHttpClient.class.getName() + " [inputfile]");
        System.err.println();
        System.err.println("Properties are: -Dinput.type=INPUTTYPE");
        System.err.println("                -Doutput.type=OUTPUTTYPE");
        System.err.println("                -Dlocale=LOCALE");
        System.err.println("                -Daudio.type=AUDIOTYPE");
        System.err.println("                -Dvoice.default=male|female|de1|de2|de3|...");
        System.err.println("                -Dserver.host=HOSTNAME");
        System.err.println("                -Dserver.port=PORTNUMBER");
        System.err.println("where INPUTTYPE is one of TEXT, RAWMARYXML, TOKENS, WORDS, POS,");
        System.err.println("                          PHONEMES, INTONATION, ALLOPHONES, ACOUSTPARAMS or MBROLA,");
        System.err.println("     OUTPUTTYPE is one of TOKENS, WORDS, POS, PHONEMES,");
        System.err.println("                          INTONATION, ALLOPHONES, ACOUSTPARAMS, MBROLA, or AUDIO,");
        System.err.println("     LOCALE is the language and/or the country (e.g., de, en_US);");
        System.err.println("and AUDIOTYPE is one of AIFF, AU, WAVE, MP3, and Vorbis.");
        System.err.println("The default values for input.type and output.type are TEXT and AUDIO,");
        System.err.println("respectively; default locale is en_US; the default audio.type is WAVE.");
        System.err.println();
        System.err.println("inputfile must be of type input.type.");
        System.err.println("If no inputfile is given, the program will read from standard input.");
        System.err.println();
        System.err.println("The output is written to standard output, so redirect or pipe as appropriate.");
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        int nr;
        if (args.length > 0 && args[0].equals("-h")) {
            MaryClient.usage();
            System.exit(1);
        }
        MaryClient mc = MaryClient.getMaryClient();
        BufferedReader inputReader = null;
        String inputType = System.getProperty("input.type", "TEXT");
        String outputType = System.getProperty("output.type", "AUDIO");
        String locale = System.getProperty("locale", "en_US");
        String audioType = System.getProperty("audio.type", "WAVE");
        if (!(audioType.equals("AIFC") || audioType.equals("AIFF") || audioType.equals("AU") || audioType.equals("SND") || audioType.equals("WAVE") || audioType.equals("MP3") || audioType.equals("Vorbis"))) {
            System.err.println("Invalid value '" + audioType + "' for property 'audio.type'");
            System.err.println();
            MaryClient.usage();
            System.exit(1);
        }
        String defaultVoiceName = System.getProperty("voice.default");
        String defaultStyle = "";
        String defaultEffects = null;
        String outputTypeParams = System.getProperty("output.type.params");
        if (args.length > 0) {
            File file = new File(args[0]);
            inputReader = new BufferedReader(new FileReader(file));
        } else {
            inputReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        }
        StringBuilder sb = new StringBuilder(1024);
        char[] buf = new char[1024];
        while ((nr = inputReader.read(buf)) != -1) {
            sb.append(buf, 0, nr);
        }
        try {
            mc.process(sb.toString(), inputType, outputType, locale, audioType, defaultVoiceName, defaultStyle, defaultEffects, outputTypeParams, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class WarningReader
    extends Thread {
        protected BufferedReader in;
        protected StringBuffer warnings;

        public WarningReader(BufferedReader in) {
            this.in = in;
            this.warnings = new StringBuffer();
        }

        public String getWarnings() {
            return this.warnings.toString();
        }

        @Override
        public void run() {
            char[] cbuf = new char[1024];
            try {
                int nr;
                while ((nr = this.in.read(cbuf)) != -1) {
                    this.warnings.append(cbuf, 0, nr);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface AudioPlayerListener {
        public void playerFinished();

        public void playerException(Exception var1);
    }

    public static class DataType {
        private String name;
        private boolean isInputType;
        private boolean isOutputType;

        public DataType(String name, boolean isInputType, boolean isOutputType) {
            this.name = name;
            this.isInputType = isInputType;
            this.isOutputType = isOutputType;
        }

        public String name() {
            return this.name;
        }

        public boolean isInputType() {
            return this.isInputType;
        }

        public boolean isOutputType() {
            return this.isOutputType;
        }

        public boolean isTextType() {
            return !this.name.equals("AUDIO");
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Voice {
        private String name;
        private Locale locale;
        private String gender;
        private String domain;
        private String synthesizerType;
        private boolean isLimitedDomain;

        public Voice(String name, Locale locale, String gender, String domain) {
            this.name = name;
            this.locale = locale;
            this.gender = gender;
            this.domain = domain;
            this.isLimitedDomain = domain != null && !domain.equals("general");
            this.synthesizerType = "not-specified";
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String name() {
            return this.name;
        }

        public String gender() {
            return this.gender;
        }

        public String synthesizerType() {
            return this.synthesizerType;
        }

        public void setSynthesizerType(String synthesizerTypeIn) {
            this.synthesizerType = synthesizerTypeIn;
        }

        public String toString() {
            return this.name + " (" + this.locale.getDisplayLanguage() + ", " + this.gender + (this.isLimitedDomain ? ", " + this.domain : "") + ")";
        }

        public boolean isLimitedDomain() {
            return this.isLimitedDomain;
        }

        public boolean isHMMVoice() {
            return this.synthesizerType.compareToIgnoreCase("hmm") == 0;
        }
    }
}

