/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer;

import de.dfki.lt.tools.tokenizer.FileTools;
import de.dfki.lt.tools.tokenizer.exceptions.InitializationException;
import de.dfki.lt.tools.tokenizer.regexp.JavaRegExpFactory;
import de.dfki.lt.tools.tokenizer.regexp.RegExp;
import de.dfki.lt.tools.tokenizer.regexp.RegExpFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class Description {
    protected static final String DEFS = "DEFINITIONS";
    protected static final String DEF_REGEXP = "regexp";
    protected static final String DEF_CLASS = "class";
    protected static final String LISTS = "LISTS";
    protected static final String LIST_FILE = "file";
    protected static final String LIST_ENCODING = "encoding";
    protected static final String RULES = "RULES";
    protected static RegExpFactory FACTORY = new JavaRegExpFactory();
    protected HashMap definitionsMap;
    protected HashMap rulesMap;
    protected HashMap regExpMap;
    protected HashMap listsMap;

    protected HashMap getDefinitionsMap() {
        return this.definitionsMap;
    }

    protected void setDefinitionsMap(HashMap aDefinitionsMap) {
        this.definitionsMap = aDefinitionsMap;
    }

    protected HashMap getRulesMap() {
        return this.rulesMap;
    }

    protected void setRulesMap(HashMap aRulesMap) {
        this.rulesMap = aRulesMap;
    }

    protected HashMap getRegExpMap() {
        return this.regExpMap;
    }

    protected void setRegExpMap(HashMap aRegExpMap) {
        this.regExpMap = aRegExpMap;
    }

    protected HashMap getListsMap() {
        return this.listsMap;
    }

    protected void setListsMap(HashMap aListsMap) {
        this.listsMap = aListsMap;
    }

    private Element getChild(Element anEle, String aName) {
        NodeList children = anEle.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node oneChild = children.item(i);
            if (!(oneChild instanceof Element) || !((Element)oneChild).getTagName().equals(aName)) continue;
            return (Element)oneChild;
        }
        return null;
    }

    protected void loadDefinitions(Document aDescr, Set classes) {
        NodeList defs = this.getChild(aDescr.getDocumentElement(), DEFS).getChildNodes();
        HashMap<String, StringBuffer> tempMap = new HashMap<String, StringBuffer>();
        int iMax = defs.getLength();
        for (int i = 0; i < iMax; ++i) {
            Element oneDef;
            String className;
            Node oneObj = defs.item(i);
            if (!(oneObj instanceof Element) || (className = (oneDef = (Element)oneObj).getAttribute(DEF_CLASS)).length() == 0) continue;
            if (!classes.contains(className)) {
                throw new InitializationException("undefined class " + className + " in definitions");
            }
            String regExpr = oneDef.getAttribute(DEF_REGEXP);
            StringBuffer oldRegExpr = (StringBuffer)tempMap.get(className);
            if (null == oldRegExpr) {
                StringBuffer newRegExpr = new StringBuffer(regExpr);
                tempMap.put(className, newRegExpr);
                continue;
            }
            oldRegExpr.append("|".intern() + regExpr);
        }
        for (String key : tempMap.keySet()) {
            StringBuffer val = (StringBuffer)tempMap.get(key);
            this.getDefinitionsMap().put(key, FACTORY.createRegExp(val.toString()));
        }
    }

    protected void loadRules(Document aDescr) {
        Element defRoot = this.getChild(aDescr.getDocumentElement(), DEFS);
        NodeList rules = this.getChild(aDescr.getDocumentElement(), RULES).getChildNodes();
        int iMax = rules.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node oneObj = rules.item(i);
            if (!(oneObj instanceof Element)) continue;
            Element oneRule = (Element)oneObj;
            StringBuffer ruleRegExpr = new StringBuffer();
            if (oneRule.getChildNodes().getLength() == 0) {
                ruleRegExpr.append(" ".intern());
            } else {
                NodeList ruleEles = oneRule.getChildNodes();
                int jMax = ruleEles.getLength();
                for (int j = 0; j < jMax; ++j) {
                    Node oneRuleEle = ruleEles.item(j);
                    if (oneRuleEle instanceof Text) {
                        ruleRegExpr.append(((Text)oneRuleEle).getData().trim());
                        continue;
                    }
                    if (!(oneRuleEle instanceof Element)) continue;
                    String ruleEleName = ((Element)oneRuleEle).getTagName();
                    Element regExprEle = this.getChild(defRoot, ruleEleName);
                    if (null == regExprEle) {
                        throw new InitializationException("undefined definition " + ruleEleName + " in rule");
                    }
                    ruleRegExpr.append(regExprEle.getAttribute(DEF_REGEXP));
                }
            }
            RegExp aRegExp = FACTORY.createRegExp(ruleRegExpr.toString());
            this.getRulesMap().put(oneRule.getTagName(), aRegExp);
            String className = oneRule.getAttribute(DEF_CLASS);
            if (className.length() <= 0) continue;
            this.getRegExpMap().put(aRegExp, className);
        }
    }

    protected void loadLists(Document aDescr, Set classes, String aResourceDir) {
        NodeList lists = this.getChild(aDescr.getDocumentElement(), LISTS).getChildNodes();
        int iMax = lists.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node oneObj = lists.item(i);
            if (!(oneObj instanceof Element)) continue;
            Element oneList = (Element)oneObj;
            String className = oneList.getAttribute(DEF_CLASS);
            if (!classes.contains(className)) {
                throw new InitializationException("undefined class " + className + " in lists");
            }
            String fileName = oneList.getAttribute(LIST_FILE);
            String fileEncoding = oneList.getAttribute(LIST_ENCODING);
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(FileTools.openResourceFileAsStream(aResourceDir + "/" + fileName), fileEncoding));
                HashSet<String> items = new HashSet<String>();
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("#".intern())) continue;
                    int end = line.indexOf(35);
                    if (-1 != end) {
                        line = line.substring(0, end);
                    }
                    if ((line = line.trim()).equals("")) continue;
                    items.add(line);
                    items.add(line.toUpperCase());
                }
                in.close();
                this.getListsMap().put(className, items);
                continue;
            }
            catch (IOException ioe) {
                throw new InitializationException(ioe.toString());
            }
        }
    }
}

