/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FreeTTS;
import com.sun.speech.freetts.InputMode;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.VoiceManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class FreeTTSTime
extends FreeTTS {
    private static final String VERSION = "FreeTTSTime Version 1.1, August  1, 2003";

    public FreeTTSTime() {
        super(VoiceManager.getInstance().getVoice("alan"));
    }

    public FreeTTSTime(Voice voice) {
        super(voice);
    }

    public static void usage() {
        System.out.println(VERSION);
        System.out.println("Usage:");
        System.out.println("    -dumpASCII file : dump the final wave to file");
        System.out.println("    -dumpAudio file : dump audio to file ");
        System.out.println("    -help           : shows usage information");
        System.out.println("    -detailedMetrics: turn on detailed metrics");
        System.out.println("    -dumpRelations  : dump the relations ");
        System.out.println("    -dumpUtterance  : dump the final utterance");
        System.out.println("    -metrics        : turn on metrics");
        System.out.println("    -run  name      : sets the name of the run");
        System.out.println("    -silent         : don't say anything");
        System.out.println("    -verbose        : verbose output");
        System.out.println("    -version        : shows version number");
        System.out.println("    -timeTest       : runs a lengthy time test");
        System.out.println("    -iter count     : run for count iterations");
        System.out.println("    -time XX:XX     : speak the given time");
        System.out.println("    -time now       : speak the current time");
        System.out.println("    -period secs    : period of iter");
        System.out.println("    -clockMode      : tells time every 5 mins");
        System.out.println("    -voice VOICE    : " + VoiceManager.getInstance().toString());
        System.exit(0);
    }

    private static void interactiveMode(FreeTTSTime freetts) {
        try {
            while (true) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Enter time: ");
                System.out.flush();
                String time = reader.readLine();
                if (time == null || time.length() == 0 || time.equals("quit")) {
                    freetts.shutdown();
                    System.exit(0);
                    continue;
                }
                freetts.getVoice().startBatch();
                freetts.safeTimeToSpeech(time);
                freetts.getVoice().endBatch();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static String timeApprox(int hour, int min) {
        int mm = min % 5;
        if (mm == 0 || mm == 4) {
            return "exactly";
        }
        if (mm == 1) {
            return "just after";
        }
        if (mm == 2) {
            return "a little after";
        }
        return "almost";
    }

    private static String timeMin(int hour, int min) {
        int mm = min / 5;
        if (min % 5 > 2) {
            ++mm;
        }
        if ((mm *= 5) > 55) {
            mm = 0;
        }
        if (mm == 0) {
            return "";
        }
        if (mm == 5) {
            return "five past";
        }
        if (mm == 10) {
            return "ten past";
        }
        if (mm == 15) {
            return "quarter past";
        }
        if (mm == 20) {
            return "twenty past";
        }
        if (mm == 25) {
            return "twenty-five past";
        }
        if (mm == 30) {
            return "half past";
        }
        if (mm == 35) {
            return "twenty-five to";
        }
        if (mm == 40) {
            return "twenty to";
        }
        if (mm == 45) {
            return "quarter to";
        }
        if (mm == 50) {
            return "ten to";
        }
        if (mm == 55) {
            return "five to";
        }
        return "five to";
    }

    private static String timeHour(int hour, int min) {
        int hh = hour;
        if (min > 32) {
            ++hh;
        }
        if (hh == 24) {
            hh = 0;
        }
        if (hh > 12) {
            hh -= 12;
        }
        if (hh == 0) {
            return "midnight";
        }
        if (hh == 1) {
            return "one";
        }
        if (hh == 2) {
            return "two";
        }
        if (hh == 3) {
            return "three";
        }
        if (hh == 4) {
            return "four";
        }
        if (hh == 5) {
            return "five";
        }
        if (hh == 6) {
            return "six";
        }
        if (hh == 7) {
            return "seven";
        }
        if (hh == 8) {
            return "eight";
        }
        if (hh == 9) {
            return "nine";
        }
        if (hh == 10) {
            return "ten";
        }
        if (hh == 11) {
            return "eleven";
        }
        if (hh == 12) {
            return "twelve";
        }
        return "twelve";
    }

    private static String timeOfDay(int hour, int min) {
        int hh = hour;
        if (min > 58) {
            ++hh;
        }
        if (hh == 24) {
            return "";
        }
        if (hh > 17) {
            return "in the evening";
        }
        if (hh > 11) {
            return "in the afternoon";
        }
        return "in the morning";
    }

    public static String timeToString(String time) {
        String theTime = null;
        if (Pattern.matches("[012][0-9]:[0-5][0-9]", time)) {
            int hour = Integer.parseInt(time.substring(0, 2));
            int min = Integer.parseInt(time.substring(3));
            theTime = FreeTTSTime.timeToString(hour, min);
        }
        return theTime;
    }

    public static String timeToString(int hour, int min) {
        String theTime = "The time is now, " + FreeTTSTime.timeApprox(hour, min) + " " + FreeTTSTime.timeMin(hour, min) + " " + FreeTTSTime.timeHour(hour, min) + ", " + FreeTTSTime.timeOfDay(hour, min) + ".";
        return theTime;
    }

    public void timeToSpeech(String time) {
        String theTime = FreeTTSTime.timeToString(time);
        if (theTime == null) {
            throw new IllegalArgumentException("Bad time format");
        }
        this.textToSpeech(theTime);
    }

    public void timeToSpeech(int hour, int min) {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Bad time format: hour");
        }
        if (min < 0 || min > 59) {
            throw new IllegalArgumentException("Bad time format: min");
        }
        String theTime = FreeTTSTime.timeToString(hour, min);
        this.textToSpeech(theTime);
    }

    public void safeTimeToSpeech(String time) {
        try {
            if (time.equals("now")) {
                this.speakNow();
            } else {
                this.timeToSpeech(time);
            }
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Bad time format");
        }
    }

    public void speakNow() {
        long now = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        int hour = cal.get(11);
        int min = cal.get(12);
        this.timeToSpeech(hour, min);
    }

    public static void main(String[] args) {
        String time = null;
        String dumpFile = null;
        Object protocol = null;
        boolean timeTest = false;
        int iterations = 1;
        int delay = 0;
        boolean setMetrics = false;
        boolean setDetailedMetrics = false;
        boolean setVerbose = false;
        boolean setDumpUtterance = false;
        boolean setDumpRelations = false;
        String waveDumpFile = null;
        String runTitle = null;
        boolean setSilentMode = false;
        String audioFile = null;
        boolean setInputMode = false;
        String voiceName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-metrics")) {
                setMetrics = true;
                continue;
            }
            if (args[i].equals("-detailedMetrics")) {
                setDetailedMetrics = true;
                continue;
            }
            if (args[i].equals("-silent")) {
                setSilentMode = true;
                continue;
            }
            if (args[i].equals("-period")) {
                if (++i >= args.length) continue;
                try {
                    delay = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Bad clock period");
                    FreeTTSTime.usage();
                }
                continue;
            }
            if (args[i].equals("-verbose")) {
                setVerbose = true;
                continue;
            }
            if (args[i].equals("-dumpUtterance")) {
                setDumpUtterance = true;
                continue;
            }
            if (args[i].equals("-dumpRelations")) {
                setDumpRelations = true;
                continue;
            }
            if (args[i].equals("-clockMode")) {
                iterations = Integer.MAX_VALUE;
                delay = 300;
                continue;
            }
            if (args[i].equals("-timeTest")) {
                timeTest = true;
                iterations = 100;
                continue;
            }
            if (args[i].equals("-dumpAudio")) {
                if (++i < args.length) {
                    audioFile = args[i];
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-iter")) {
                if (++i < args.length) {
                    try {
                        iterations = Integer.parseInt(args[i]);
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Bad iteration format");
                        FreeTTSTime.usage();
                    }
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-dumpASCII")) {
                if (++i < args.length) {
                    dumpFile = args[i];
                    waveDumpFile = args[i];
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println(VERSION);
                continue;
            }
            if (args[i].equals("-help")) {
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-time")) {
                setInputMode = true;
                if (++i < args.length) {
                    time = args[i];
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-run")) {
                if (++i < args.length) {
                    runTitle = args[i];
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            if (args[i].equals("-voice")) {
                if (++i < args.length) {
                    voiceName = args[i];
                    continue;
                }
                FreeTTSTime.usage();
                continue;
            }
            System.out.println("Unknown option:" + args[i]);
        }
        if (voiceName == null) {
            voiceName = "alan";
        }
        FreeTTSTime freetts = new FreeTTSTime(VoiceManager.getInstance().getVoice(voiceName));
        Voice voice = freetts.getVoice();
        if (setMetrics) {
            voice.setMetrics(true);
        }
        if (setDetailedMetrics) {
            voice.setDetailedMetrics(true);
        }
        if (setVerbose) {
            voice.setVerbose(true);
        }
        if (setDumpUtterance) {
            voice.setDumpUtterance(true);
        }
        if (setDumpRelations) {
            voice.setDumpRelations(true);
        }
        if (waveDumpFile != null) {
            voice.setWaveDumpFile(waveDumpFile);
        }
        if (runTitle != null) {
            voice.setRunTitle(runTitle);
        }
        if (setSilentMode) {
            freetts.setSilentMode(true);
        }
        if (audioFile != null) {
            freetts.setAudioFile(audioFile);
        }
        if (setInputMode) {
            freetts.setInputMode(InputMode.TEXT);
        }
        freetts.startup();
        if (time != null) {
            freetts.getVoice().startBatch();
            for (int i = 0; i < iterations; ++i) {
                freetts.safeTimeToSpeech(time);
                try {
                    Thread.sleep((long)delay * 1000L);
                    continue;
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
            freetts.getVoice().endBatch();
        } else {
            FreeTTSTime.interactiveMode(freetts);
        }
        freetts.shutdown();
        System.exit(0);
    }
}

