/*
 * Decompiled with CFR 0.152.
 */
package MGP_I15;

import MGP_I15.Parser;
import java.util.Locale;
import java.util.Set;
import javax.sound.sampled.AudioInputStream;
import marytts.client.RemoteMaryInterface;
import marytts.util.data.audio.AudioPlayer;

public class MaryTTS {
    public static void MaryPlay(String[] args) {
        boolean usePersoSentence = false;
        String host = "localhost";
        int port = 59125;
        String country = "fr";
        String sentence = "";
        String part = "";
        String side = "";
        String position = "";
        switch (args.length) {
            case 1: {
                if (args[0].equals("--help")) {
                    System.out.println("Usage:");
                    System.out.println("java example.MaryTTSEmbedded [country part side position] [--help] [-p your_personnal_tts_string country]");
                    System.out.println("\nARGUMENTS :");
                    System.out.println("\t country : en | fr (natively supported)");
                    System.out.println("\t part : arm | hand | elbow | shoulder | leg | foot | knee | hip");
                    System.out.println("\t side : left | right | 0");
                    System.out.println("\t position : up | down | front | back | left | right");
                    System.out.println("\nOPTIONS :");
                    System.out.println("\t-p string country : Use your personal TTS string");
                    break;
                }
                MaryTTS.wrongArgs();
                return;
            }
            case 3: {
                if (args[0].equals("-p") && args[1] != null && (args[2].equals("en") || args[2].equals("fr"))) {
                    usePersoSentence = true;
                    sentence = args[1];
                    country = args[2];
                    break;
                }
                MaryTTS.wrongArgs();
                return;
            }
            case 4: {
                if ((args[0].equals("en") || args[0].equals("fr")) && args[1] != null && (args[2].equals("left") || args[2].equals("right") || args[2].equals("0")) && args[3] != null) {
                    country = args[0];
                    part = args[1];
                    side = args[2];
                    position = args[3];
                    break;
                }
                MaryTTS.wrongArgs();
                return;
            }
            default: {
                MaryTTS.wrongArgs();
                return;
            }
        }
        try {
            RemoteMaryInterface marytts = new RemoteMaryInterface("localhost", 59125);
            System.out.println("I currently have " + marytts.getAvailableVoices() + " voices in " + marytts.getAvailableLocales() + " languages available.");
            System.out.println("\tOut of these, " + marytts.getAvailableVoices(Locale.US) + " are for US English.");
            System.out.println("\tOut of these, " + marytts.getAvailableVoices(Locale.FRENCH) + " are for French.");
            Set<String> voices = marytts.getAvailableVoices(MaryTTS.setLocale(country));
            marytts.setVoice(voices.iterator().next());
            System.out.println("Active voice : " + marytts.getVoice());
            AudioInputStream audio = null;
            if (!usePersoSentence) {
                String phrase = MaryTTS.getSentence(part, side, position, country);
                System.out.println("Sentence : " + phrase);
                audio = marytts.generateAudio(phrase);
            } else {
                System.out.println("Sentence : " + sentence);
                System.out.println("Generating audio on MaryTTS server");
                audio = marytts.generateAudio(sentence);
            }
            if (audio != null) {
                System.out.println("Creating audio player");
                AudioPlayer player = new AudioPlayer(audio);
                System.out.println("Starting audio player");
                player.start();
                System.out.println("Joining audio player");
                player.join();
            }
        }
        catch (Exception e) {
            System.err.println("Error generating audio, incorrect sentence or incorrect language");
        }
    }

    private static Locale setLocale(String country) {
        System.out.println("Country: " + country);
        switch (country) {
            case "fr": {
                return Locale.FRENCH;
            }
            case "en": {
                return Locale.US;
            }
        }
        System.err.println("Country not found. Usage \"fr\" or \"en\"");
        return null;
    }

    private static String getSentence(String part, String side, String position, String country) {
        Parser parse = new Parser(country);
        String xmlName = String.valueOf(part) + "-" + side + "-" + position;
        System.out.println("xmlNAME : " + xmlName);
        return parse.getString(xmlName);
    }

    private static void wrongArgs() {
        System.err.println("Usage: java example.MaryTTSEmbedded country part side position");
        System.err.println("\t--help for specifications");
    }
}

