/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.nio;

import org.apache.http.HttpResponseFactory;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpClientIOTarget;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.HttpParams;

public class DefaultClientIOEventDispatch
implements IOEventDispatch {
    protected final ByteBufferAllocator allocator;
    protected final NHttpClientHandler handler;
    protected final HttpParams params;

    public DefaultClientIOEventDispatch(NHttpClientHandler handler, HttpParams params) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.allocator = this.createByteBufferAllocator();
        this.handler = handler;
        this.params = params;
    }

    protected ByteBufferAllocator createByteBufferAllocator() {
        return new HeapByteBufferAllocator();
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    protected NHttpClientIOTarget createConnection(IOSession session) {
        return new DefaultNHttpClientConnection(session, this.createHttpResponseFactory(), this.allocator, this.params);
    }

    public void connected(IOSession session) {
        NHttpClientIOTarget conn = this.createConnection(session);
        Object attachment = session.getAttribute("http.session.attachment");
        session.setAttribute("http.connection", conn);
        this.handler.connected(conn, attachment);
    }

    public void disconnected(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        if (conn != null) {
            this.handler.closed(conn);
        }
    }

    public void inputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        conn.consumeInput(this.handler);
    }

    public void outputReady(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        conn.produceOutput(this.handler);
    }

    public void timeout(IOSession session) {
        NHttpClientIOTarget conn = (NHttpClientIOTarget)session.getAttribute("http.connection");
        this.handler.timeout(conn);
    }
}

