/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ShortStringTranslator {
    ArrayList<String> list;
    Map<String, Short> map;

    public ShortStringTranslator() {
        this.list = new ArrayList();
        this.map = new HashMap<String, Short>();
    }

    public ShortStringTranslator(short initialRange) {
        this.list = new ArrayList(initialRange);
        this.map = new HashMap<String, Short>();
    }

    public ShortStringTranslator(String[] strings) {
        if (strings.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Too many strings for a short-string translator");
        }
        this.list = new ArrayList<String>(Arrays.asList(strings));
        this.map = new HashMap<String, Short>();
        for (int i = 0; i < strings.length; ++i) {
            this.map.put(strings[i], (short)i);
        }
    }

    public void set(short b, String s) {
        this.list.add(b, s);
        this.map.put(s, b);
    }

    public boolean contains(String s) {
        return this.map.containsKey(s);
    }

    public boolean contains(short b) {
        short index = b;
        return index >= 0 && index < this.list.size();
    }

    public short get(String s) {
        Short index = this.map.get(s);
        if (index == null) {
            throw new IllegalArgumentException("No short value known for string [" + s + "]");
        }
        return index;
    }

    public String get(short b) {
        short index = b;
        if (index < 0 || index >= this.list.size()) {
            throw new IndexOutOfBoundsException("Short value out of range: " + index);
        }
        return this.list.get(index);
    }

    public String[] getStringValues() {
        return this.list.toArray(new String[0]);
    }

    public short getNumberOfValues() {
        return (short)this.list.size();
    }
}

