/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import marytts.util.math.MathUtils;

public class Histogram {
    private double[] m_hist;
    private double[] m_data;
    private double[] m_binCenters;
    private String m_name;
    private double m_min;
    private double m_max;
    private int m_nbins;
    private int m_entries;
    private double m_overflow;
    private double m_underflow;
    private boolean m_debug;
    private double m_bandwidth;

    public Histogram(double[] data) {
        double min = MathUtils.min(data);
        double max = MathUtils.max(data);
        this.setHistogram(data, 15, min, max);
    }

    public Histogram(double[] data, int nbins) {
        double min = MathUtils.min(data);
        double max = MathUtils.max(data);
        this.setHistogram(data, nbins, min, max);
    }

    public Histogram(double[] data, int nbins, double min, double max) {
        this.setHistogram(data, nbins, min, max);
    }

    public void setHistogram(double[] data, int nbins, double min, double max) {
        this.m_nbins = nbins;
        this.m_min = min;
        this.m_max = max;
        this.m_data = data;
        this.m_hist = new double[this.m_nbins];
        this.m_binCenters = new double[this.m_nbins];
        this.m_underflow = 0.0;
        this.m_overflow = 0.0;
        this.setBandWidth();
        for (double x : this.m_data) {
            this.fill(x);
        }
        this.m_binCenters = this.setSampleArray();
    }

    public void changeSettings(int nbins) {
        this.m_nbins = nbins;
        this.m_binCenters = new double[this.m_nbins];
        this.m_hist = new double[this.m_nbins];
        this.setBandWidth();
        for (double x : this.m_data) {
            this.fill(x);
        }
        this.m_binCenters = this.setSampleArray();
    }

    public void fill(double x) {
        BinInfo bin = this.findBin(x);
        if (bin.isUnderflow) {
            this.m_underflow += 1.0;
        }
        if (bin.isOverflow) {
            this.m_overflow += 1.0;
        }
        if (bin.isInRange) {
            int n = bin.index;
            this.m_hist[n] = this.m_hist[n] + 1.0;
        }
        if (this.m_debug) {
            System.out.println("debug: fill: value " + x + " # underflows " + this.m_underflow + " # overflows " + this.m_overflow + " bin index " + bin.index);
        }
        ++this.m_entries;
    }

    private BinInfo findBin(double x) {
        BinInfo bin = new BinInfo();
        bin.isInRange = false;
        bin.isUnderflow = false;
        bin.isOverflow = false;
        if (x < this.m_min) {
            bin.isUnderflow = true;
        } else if (x > this.m_max) {
            bin.isOverflow = true;
        } else {
            double binWidth = this.getBandWidth();
            for (int i = 0; i < this.m_nbins; ++i) {
                double highEdge = this.m_min + (double)(i + 1) * binWidth;
                if (!(x <= highEdge)) continue;
                bin.isInRange = true;
                bin.index = i;
                break;
            }
        }
        return bin;
    }

    public void setBandWidth() {
        this.m_bandwidth = (this.m_max - this.m_min) / (double)this.m_nbins;
    }

    public double getBandWidth() {
        return this.m_bandwidth;
    }

    public void writeToFile(String fileName) throws IOException {
        PrintWriter outfile = new PrintWriter(new FileOutputStream(fileName));
        outfile.println("// Output from Histogram class");
        outfile.println("// metaData: ");
        outfile.println("bins " + this.m_nbins);
        outfile.println("min " + this.m_min);
        outfile.println("max " + this.m_max);
        outfile.println("totalEntries " + this.m_entries);
        outfile.println("underflow " + this.m_underflow);
        outfile.println("overflow " + this.m_overflow);
        outfile.println("// binData:");
        for (int i = 0; i < this.m_nbins; ++i) {
            outfile.println(i + " " + this.m_binCenters[i] + " " + this.m_hist[i]);
        }
        outfile.println("// end.");
        outfile.close();
    }

    public void show() {
        DecimalFormat df = new DecimalFormat(" ##0.00;-##0.00");
        double binWidth = (this.m_max - this.m_min) / (double)this.m_nbins;
        System.out.println(" bin range        height");
        for (int i = 0; i < this.m_nbins; ++i) {
            double binLowEdge = this.m_min + (double)i * binWidth;
            double binHighEdge = binLowEdge + binWidth;
            System.out.println(df.format(binLowEdge) + " to " + df.format(binHighEdge) + "   " + df.format(this.m_hist[i]));
        }
    }

    public double[] setSampleArray() {
        double[] binCenters = new double[this.m_nbins];
        double binWidth = (this.m_max - this.m_min) / (double)this.m_nbins;
        for (int i = 0; i < this.m_nbins; ++i) {
            double binLowEdge = this.m_min + (double)i * binWidth;
            double binHighEdge = binLowEdge + binWidth;
            binCenters[i] = (binLowEdge + binHighEdge) / 2.0;
        }
        return binCenters;
    }

    public int entries() {
        return this.m_entries;
    }

    public String name() {
        return this.m_name;
    }

    public int numberOfBins() {
        return this.m_nbins;
    }

    public double min() {
        return this.m_min;
    }

    public double mean() {
        return MathUtils.mean(this.m_data);
    }

    public double variance() {
        return MathUtils.variance(this.m_data);
    }

    public double stdDev() {
        return MathUtils.standardDeviation(this.m_data);
    }

    public double max() {
        return this.m_max;
    }

    public double overflow() {
        return this.m_overflow;
    }

    public double underflow() {
        return this.m_underflow;
    }

    public double[] getHistArray() {
        return this.m_hist;
    }

    public double[] getSampleArray() {
        return this.m_binCenters;
    }

    public double[] getDataArray() {
        return this.m_data;
    }

    public void setDebug(boolean flag) {
        this.m_debug = flag;
    }

    public boolean getDebug() {
        return this.m_debug;
    }

    private class BinInfo {
        public int index;
        public boolean isUnderflow;
        public boolean isOverflow;
        public boolean isInRange;

        private BinInfo() {
        }
    }
}

