/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import marytts.signalproc.window.HammingWindow;

public class DTW {
    private static final double INFINITE = 1.0E32;
    double[][] signal;
    double[][] reference;
    double slope = 0.0;
    double[] weights;
    String distanceFunction;
    double[] sigma2 = null;
    double costValue;

    public DTW(double[][] signal, double[][] reference) {
        this.signal = signal;
        this.reference = reference;
        this.distanceFunction = "Euclidean";
        this.setCost(this.dpDistance());
    }

    public DTW(double[][] signal, double[][] reference, String distanceFunction) {
        this.signal = signal;
        this.reference = reference;
        this.distanceFunction = distanceFunction;
        this.setCost(this.dpDistance());
    }

    public DTW(double[][] signal, double[][] reference, double[] sigma2) {
        this.signal = signal;
        this.reference = reference;
        this.sigma2 = sigma2;
        this.distanceFunction = "Mahalanobis";
        this.setCost(this.dpDistance());
    }

    private void setCost(double cost) {
        this.costValue = cost;
    }

    private void setCost(double[] sigma2) {
        this.sigma2 = sigma2;
    }

    public double getCost() {
        return this.costValue;
    }

    public double getNormalizedCost() {
        return this.costValue * 2.0 / (double)(this.reference.length + this.signal.length);
    }

    private double dpDistance() {
        if (this.signal == null || this.reference == null) {
            return 1.0E32;
        }
        if (this.signal.length == 0 || this.reference.length == 0) {
            return 1.0E32;
        }
        if (this.signal[0].length != this.reference[0].length) {
            throw new RuntimeException("Given signal vector order (" + this.signal[0].length + ") and reference vector order (" + this.reference[0].length + ") are not same.");
        }
        this.weights = this.weightFunction(this.reference.length);
        RecurssiveDTW rdp = new RecurssiveDTW(this.signal.length, this.reference.length);
        return rdp.dpCost;
    }

    public double EuclideanDistance(double[] x, double[] y) {
        double sum = 0.0;
        if (x.length != y.length) {
            throw new RuntimeException("Given array lengths were not equal.");
        }
        int d = x.length;
        for (int i = 0; i < d; ++i) {
            sum += (x[i] - y[i]) * (x[i] - y[i]);
        }
        sum = Math.sqrt(sum);
        return sum;
    }

    public double AbsDistance(double[] x, double[] y) {
        double sum = 0.0;
        if (x.length != y.length) {
            throw new RuntimeException("Given array lengths were not equal.");
        }
        int d = x.length;
        for (int i = 0; i < d; ++i) {
            sum += Math.abs(x[i] - y[i]);
        }
        return sum;
    }

    public double[] weightFunction(int windowLength) {
        HammingWindow w = new HammingWindow(windowLength);
        double[] weightsF = w.getCoeffs();
        for (int i = 0; i < weightsF.length; ++i) {
            weightsF[i] = 1.0 - weightsF[i];
        }
        return weightsF;
    }

    private double mahalanobis(double[] v1, double[] v2, double[] sig2) {
        if (v1.length != v2.length) {
            throw new RuntimeException("Given array lengths were not equal.");
        }
        if (v1.length != sig2.length) {
            throw new RuntimeException("Given array lengths were not equal.");
        }
        double sum = 0.0;
        double diff = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            diff = v1[i] - v2[i];
            sum += diff * diff / sig2[i];
        }
        return sum;
    }

    protected double frameDistance(double[] f1, double[] f2, String distanceType) {
        double dis = 0.0;
        dis = distanceType == "Mahalanobis" ? this.mahalanobis(f1, f2, this.sigma2) : (distanceType == "Euclidean" ? this.EuclideanDistance(f1, f2) : this.AbsDistance(f1, f2));
        return dis;
    }

    public class RecurssiveDTW {
        Node[][] nodes;
        int xlen;
        int ylen;
        double dpCost;
        double pathLength;
        double dpNormalizedCost;

        RecurssiveDTW(int xlen, int ylen) {
            this.xlen = xlen;
            this.ylen = ylen;
            this.nodes = new Node[xlen][ylen];
            this.dpCost = this.rdpSearch(xlen - 1, ylen - 1);
            this.pathLength = this.getPathLength();
            this.dpNormalizedCost = this.dpCost / this.pathLength;
        }

        public double getPathLength() {
            double sumDist = 0.0;
            Node pNode = this.nodes[this.xlen - 1][this.ylen - 1].prevNode;
            Node cNode = this.nodes[this.xlen - 1][this.ylen - 1];
            while (pNode != null && cNode != null) {
                sumDist += this.euclideanDistance(pNode.x, pNode.y, cNode.x, cNode.y);
                pNode = pNode.prevNode;
                cNode = cNode.prevNode;
            }
            return sumDist;
        }

        public void printBestPath() {
            Node cNode = this.nodes[this.xlen - 1][this.ylen - 1];
            System.out.println("Printing best path:");
            while (cNode != null) {
                System.out.println(cNode.x + " " + cNode.y);
                cNode = cNode.prevNode;
            }
        }

        public int[][] getBestPath() {
            int[][] bestPath = null;
            Node cNode = this.nodes[this.xlen - 1][this.ylen - 1];
            int numItems = 0;
            while (cNode != null) {
                cNode = cNode.prevNode;
                ++numItems;
            }
            bestPath = new int[numItems][2];
            int i = 0;
            while (cNode != null) {
                bestPath[i][0] = cNode.x;
                bestPath[i][1] = cNode.y;
                cNode = cNode.prevNode;
                ++i;
            }
            return bestPath;
        }

        public double euclideanDistance(double x1, double y1, double x2, double y2) {
            double xsQ = (x1 - x2) * (x1 - x2);
            double ysQ = (y1 - y2) * (y1 - y2);
            return Math.sqrt(xsQ + ysQ);
        }

        public double rdpSearch(int x, int y) {
            if (x < 0 || y < 0) {
                return 1.0E32;
            }
            if (x == 0 && y == 0) {
                this.nodes[x][y] = new Node(0, 0, false);
                this.nodes[x][y].value = this.nodes[x][y].frameDist;
                this.nodes[x][y].prevNode = null;
                return this.nodes[x][y].value;
            }
            if (x == 0 || y == 0) {
                this.nodes[x][y] = new Node(x, y, false);
                this.nodes[x][y].value = 1.0E32;
                this.nodes[x][y].prevNode = this.nodes[0][0];
                return this.nodes[x][y].value;
            }
            if (this.nodes[x][y] == null) {
                this.nodes[x][y] = new Node(x, y, false);
            }
            if (this.nodes[x][y].value != -1.0) {
                return this.nodes[x][y].value;
            }
            double minV = 1.0E32;
            double[] localD = new double[]{this.rdpSearch(x - 1, y - 1), this.rdpSearch(x - 2, y - 1), this.rdpSearch(x - 1, y - 2), this.rdpSearch(x, y - 1), this.rdpSearch(x - 1, y)};
            minV = localD[0];
            if (x - 1 >= 0 && y - 1 >= 0) {
                this.nodes[x][y].prevNode = this.nodes[x - 1][y - 1];
            }
            if (localD[1] < minV) {
                minV = localD[1];
                if (x - 2 >= 0 && y - 1 >= 0) {
                    this.nodes[x][y].prevNode = this.nodes[x - 2][y - 1];
                }
            }
            if (localD[2] < minV) {
                minV = localD[2];
                if (x - 1 >= 0 && y - 2 >= 0) {
                    this.nodes[x][y].prevNode = this.nodes[x - 1][y - 2];
                }
            }
            if (localD[3] < minV) {
                minV = localD[3];
                if (x >= 0 && y - 1 >= 0) {
                    this.nodes[x][y].prevNode = this.nodes[x][y - 1];
                }
            }
            if (localD[4] < minV) {
                minV = localD[4];
                if (x - 1 >= 0 && y >= 0) {
                    this.nodes[x][y].prevNode = this.nodes[x - 1][y];
                }
            }
            this.nodes[x][y].value = minV + this.nodes[x][y].frameDist;
            return this.nodes[x][y].value;
        }
    }

    public class Node {
        public int x;
        public int y;
        public double value;
        public double frameDist;
        public boolean edgeNode;
        public Node prevNode;

        Node(int x, int y, boolean isWeight) {
            this.x = x;
            this.y = y;
            this.frameDist = isWeight ? DTW.this.weights[y] * DTW.this.frameDistance(DTW.this.reference[y], DTW.this.signal[x], DTW.this.distanceFunction) : DTW.this.frameDistance(DTW.this.reference[y], DTW.this.signal[x], DTW.this.distanceFunction);
            this.value = -1.0;
        }
    }
}

