/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import marytts.util.io.StreamLogger;

public class General {
    public static String readWord(DataInputStream dis) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        while (Character.isWhitespace(c = General.readChar(dis))) {
        }
        do {
            sb.append(c);
        } while (!Character.isWhitespace(c = General.readChar(dis)));
        return sb.toString();
    }

    public static char readChar(DataInputStream dis) throws IOException {
        return (char)dis.readByte();
    }

    public static char[] readChars(DataInputStream dis, int num) throws IOException {
        char[] carray = new char[num];
        for (int i = 0; i < num; ++i) {
            carray[i] = General.readChar(dis);
        }
        return carray;
    }

    public static float readFloat(DataInputStream dis, boolean isBigEndian) throws IOException {
        float val = !isBigEndian ? General.readLittleEndianFloat(dis) : dis.readFloat();
        return val;
    }

    public static void writeFloat(DataOutputStream dos, boolean isBigEndian, float val) throws IOException {
        if (!isBigEndian) {
            General.writeLittleEndianFloat(dos, val);
        } else {
            dos.writeFloat(val);
        }
    }

    public static float readLittleEndianFloat(DataInputStream dataStream) throws IOException {
        return Float.intBitsToFloat(General.readLittleEndianInt(dataStream));
    }

    public static void writeLittleEndianFloat(DataOutputStream dataStream, float val) throws IOException {
        General.writeLittleEndianInt(dataStream, Float.floatToRawIntBits(val));
    }

    public static int readInt(DataInputStream dis, boolean isBigEndian) throws IOException {
        if (!isBigEndian) {
            return General.readLittleEndianInt(dis);
        }
        return dis.readInt();
    }

    public static void writeInt(DataOutputStream dis, boolean isBigEndian, int val) throws IOException {
        if (!isBigEndian) {
            General.writeLittleEndianInt(dis, val);
        } else {
            dis.writeInt(val);
        }
    }

    public static int readLittleEndianInt(DataInputStream dataStream) throws IOException {
        int bits = 0;
        for (int shift = 0; shift < 32; shift += 8) {
            int byteRead = 0xFF & dataStream.readByte();
            bits |= byteRead << shift;
        }
        return bits;
    }

    public static void writeLittleEndianInt(DataOutputStream dataStream, int val) throws IOException {
        int mask = 255;
        for (int shift = 0; shift < 32; shift += 8) {
            dataStream.writeByte(mask & val >> shift);
        }
    }

    public static short readShort(DataInputStream dis, boolean isBigEndian) throws IOException {
        if (!isBigEndian) {
            return General.readLittleEndianShort(dis);
        }
        return dis.readShort();
    }

    public static short readLittleEndianShort(DataInputStream dis) throws IOException {
        short bits = (short)(0xFF & dis.readByte());
        bits = (short)(bits | (short)(0xFF & dis.readByte()) << 8);
        return bits;
    }

    public static byte shortToUlaw(short sample) {
        int mantissa;
        int exponent;
        int ulawbyte;
        int[] exp_lut = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
        int CLIP = 32635;
        int BIAS = 132;
        int sign = sample >> 8 & 0x80;
        if (sign != 0) {
            sample = -sample;
        }
        if (sample > 32635) {
            sample = (short)32635;
        }
        if ((ulawbyte = (int)(~(sign | (exponent = exp_lut[(sample = (short)(sample + 132)) >> 7 & 0xFF]) << 4 | (mantissa = sample >> exponent + 3 & 0xF)) & 0xFF)) == 0) {
            ulawbyte = 2;
        }
        return (byte)(ulawbyte - 128);
    }

    public static short ulawToShort(byte ulaw) {
        short ulawbyte = (short)(ulaw + 128);
        int[] exp_lut = new int[]{0, 132, 396, 924, 1980, 4092, 8316, 16764};
        ulawbyte = (short)(ulawbyte & 0xFF);
        ulawbyte = ~ulawbyte;
        int sign = ulawbyte & 0x80;
        int exponent = (ulawbyte & 0xFF) >> 4 & 7;
        int mantissa = ulawbyte & 0xF;
        short sample = (short)(exp_lut[exponent] + (mantissa << exponent + 3));
        if (sign != 0) {
            sample = -sample;
        }
        return sample;
    }

    public static byte[] shortToUlaw(short[] samples) {
        if (samples == null) {
            return null;
        }
        byte[] ulaw = new byte[samples.length];
        for (int i = 0; i < samples.length; ++i) {
            ulaw[i] = General.shortToUlaw(samples[i]);
        }
        return ulaw;
    }

    public static short[] ulawToShort(byte[] ulaw) {
        if (ulaw == null) {
            return null;
        }
        short[] samples = new short[ulaw.length];
        for (int i = 0; i < ulaw.length; ++i) {
            samples[i] = General.ulawToShort(ulaw[i]);
        }
        return samples;
    }

    public static String hex(float f) {
        return Integer.toHexString(Float.floatToIntBits(f));
    }

    public static short quantize(float f, float fMin, float fRange) {
        return (short)(((double)f - (double)fMin) * 65535.0 / (double)fRange - 32768.0);
    }

    public static short[] quantize(float[] f, float fMin, float fRange) {
        int len = f.length;
        short[] ret = new short[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = General.quantize(f[i], fMin, fRange);
        }
        return ret;
    }

    public static float unQuantize(short s, float fMin, float fRange) {
        return (float)(((double)s + 32768.0) * (double)fRange / 65535.0 - (double)fMin);
    }

    public static float[] unQuantize(short[] s, float fMin, float fRange) {
        int len = s.length;
        float[] ret = new float[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = General.unQuantize(s[i], fMin, fRange);
        }
        return ret;
    }

    public static void launchProc(String cmdLine, String task, String baseName) {
        Process proc = null;
        Object line = null;
        try {
            proc = Runtime.getRuntime().exec(cmdLine);
            InputStream procStdOut = proc.getInputStream();
            InputStream procStdErr = proc.getErrorStream();
            StreamLogger stdOutLogger = new StreamLogger(procStdOut, System.out);
            StreamLogger stdErrLogger = new StreamLogger(procStdErr, System.err);
            stdOutLogger.start();
            stdErrLogger.start();
            try {
                stdOutLogger.join();
                stdErrLogger.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                throw new RuntimeException(task + " computation failed on file [" + baseName + "]!\n" + "Command line was: [" + cmdLine + "].");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(task + " computation provoked an IOException on file [" + baseName + "].", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(task + " computation interrupted on file [" + baseName + "].", e);
        }
    }

    public static void launchBatchProc(String cmdLine, String task, String filedir) {
        Process proc = null;
        Process proctmp = null;
        Object procStdout = null;
        String line = null;
        String tmpFile = filedir + "tmp.bat";
        System.out.println("Running: " + cmdLine);
        try {
            FileWriter tmp = new FileWriter(tmpFile);
            tmp.write(cmdLine);
            tmp.close();
            proctmp = Runtime.getRuntime().exec("chmod +x " + tmpFile);
            proctmp.waitFor();
            if (proctmp.exitValue() != 0) {
                BufferedReader errReader = new BufferedReader(new InputStreamReader(proctmp.getErrorStream()));
                while ((line = errReader.readLine()) != null) {
                    System.err.println("ERR> " + line);
                }
                errReader.close();
                throw new RuntimeException(task + " computation failed on file [" + filedir + "]!\n" + "Command line was: [chmod +x " + tmpFile + "].");
            }
            proc = Runtime.getRuntime().exec(tmpFile);
            InputStream procStdOut = proc.getInputStream();
            InputStream procStdErr = proc.getErrorStream();
            StreamLogger stdOutLogger = new StreamLogger(procStdOut, System.out);
            StreamLogger stdErrLogger = new StreamLogger(procStdErr, System.err);
            stdOutLogger.start();
            stdErrLogger.start();
            try {
                stdOutLogger.join();
                stdErrLogger.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            proc.waitFor();
            if (proc.exitValue() != 0) {
                BufferedReader errReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((line = errReader.readLine()) != null) {
                    System.err.println("ERR> " + line);
                }
                errReader.close();
                throw new RuntimeException(task + " computation failed on file [" + filedir + "]!\n" + "Command line was: [" + cmdLine + "].");
            }
            File batchFile = new File(tmpFile);
            if (batchFile.exists()) {
                batchFile.delete();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(task + " computation provoked an IOException on file [" + filedir + "].", e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(task + " computation interrupted on file [" + filedir + "].", e);
        }
    }
}

