/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryXML;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import marytts.util.dom.MaryNormalisedWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.SAXException;

public class MaryDomUtils
extends DomUtils {
    public static Element encloseWithMTU(Element t, String orig, String accentPosition) {
        if (!t.getNodeName().equals("t")) {
            throw new DOMException(15, "Only t elements allowed, received " + t.getNodeName() + ".");
        }
        Element parent = (Element)t.getParentNode();
        assert (parent != null);
        Document doc = t.getOwnerDocument();
        Element mtu = MaryXML.createElement(doc, "mtu");
        mtu.setAttribute("orig", orig);
        if (accentPosition != null) {
            mtu.setAttribute("accent", accentPosition);
        }
        parent.insertBefore(mtu, t);
        mtu.appendChild(t);
        return mtu;
    }

    public static Element appendToken(Element t, String newTokenText) {
        if (!t.getNodeName().equals("t")) {
            throw new DOMException(15, "Only t elements allowed, received " + t.getNodeName() + ".");
        }
        Element parent = (Element)t.getParentNode();
        Document doc = t.getOwnerDocument();
        Element next = MaryDomUtils.getNextSiblingElement(t);
        Element newT = MaryXML.createElement(doc, "t");
        MaryDomUtils.setTokenText(newT, newTokenText);
        parent.insertBefore(newT, next);
        return newT;
    }

    public static String tokenText(Element t) {
        if (!t.getNodeName().equals("t")) {
            throw new DOMException(15, "Only t elements allowed, received " + t.getNodeName() + ".");
        }
        return MaryDomUtils.getPlainTextBelow(t).trim();
    }

    public static void setTokenText(Element t, String s) {
        if (!t.getNodeName().equals("t")) {
            throw new DOMException(15, "Only t elements allowed, received " + t.getNodeName() + ".");
        }
        Document doc = t.getOwnerDocument();
        NodeIterator textIt = ((DocumentTraversal)((Object)doc)).createNodeIterator(t, 4, null, false);
        Text text = null;
        String textString = null;
        while ((text = (Text)textIt.nextNode()) != null && (textString = text.getData().trim()).equals("")) {
        }
        if (text == null) {
            text = t.getOwnerDocument().createTextNode(s);
            t.appendChild(text);
        } else {
            text.setData(s);
        }
    }

    public static Element createBoundary(Document doc) {
        if (!doc.getDocumentElement().getTagName().equals("maryxml")) {
            throw new DOMException(15, "Expected <maryxml> document, received " + doc.getDocumentElement().getTagName() + ".");
        }
        Element boundary = MaryXML.createElement(doc, "boundary");
        boundary.setAttribute("breakindex", "3");
        boundary.setAttribute("tone", "unknown");
        return boundary;
    }

    public static Locale getLocale(Document doc) {
        if (doc.getDocumentElement().hasAttribute("xml:lang")) {
            return MaryUtils.string2locale(doc.getDocumentElement().getAttribute("xml:lang"));
        }
        return null;
    }

    public static boolean isSchemaValid(Document doc) throws MaryConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MaryNormalisedWriter mnw = new MaryNormalisedWriter();
        try {
            mnw.output(doc, baos);
        }
        catch (TransformerException te) {
            throw new MaryConfigurationException("Cannot serialize document for Schema-valid parsing", te);
        }
        try {
            MaryDomUtils.parseDocument(new ByteArrayInputStream(baos.toByteArray()), true);
        }
        catch (ParserConfigurationException pce) {
            throw new MaryConfigurationException("Problem setting up parser", pce);
        }
        catch (IOException ioe) {
            throw new MaryConfigurationException("IOException should not occur but it does", ioe);
        }
        catch (SAXException se) {
            return false;
        }
        return true;
    }
}

