/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import marytts.util.data.BaseDoubleDataSource;

public class TextReaderDoubleDataSource
extends BaseDoubleDataSource {
    protected BufferedReader reader;

    public TextReaderDoubleDataSource(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public TextReaderDoubleDataSource(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        for (int i = 0; i < length; ++i) {
            try {
                double value;
                String line = this.reader.readLine().trim();
                target[targetPos + i] = value = Double.parseDouble(line);
                continue;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return i;
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                return i;
            }
        }
        return length;
    }

    @Override
    public boolean hasMoreData() {
        int c = -1;
        try {
            this.reader.mark(10);
            c = this.reader.read();
            this.reader.reset();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return c != -1;
    }
}

