/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.Arrays;
import java.util.List;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BlockwiseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public class MixerDoubleDataSource
extends BaseDoubleDataSource {
    protected DoubleDataSource[] sources;
    protected boolean hasMoreData = true;

    public MixerDoubleDataSource(DoubleDataSource[] inputSources) {
        this.sources = new DoubleDataSource[inputSources.length];
        this.dataLength = 0L;
        for (int i = 0; i < inputSources.length; ++i) {
            if (this.dataLength != -1L) {
                long dl = inputSources[i].getDataLength();
                if (dl == -1L) {
                    this.dataLength = -1L;
                } else if (dl > this.dataLength) {
                    this.dataLength = dl;
                }
            }
            this.sources[i] = inputSources[i] instanceof BlockwiseDoubleDataSource ? new BufferedDoubleDataSource(inputSources[i]) : inputSources[i];
        }
    }

    public MixerDoubleDataSource(List inputSources) {
        this(inputSources.toArray(new DoubleDataSource[0]));
    }

    @Override
    public boolean hasMoreData() {
        if (!this.hasMoreData) {
            return false;
        }
        boolean foundOneWithData = false;
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].hasMoreData()) continue;
            foundOneWithData = true;
            break;
        }
        if (foundOneWithData) {
            return true;
        }
        this.hasMoreData = false;
        return false;
    }

    @Override
    public int available() {
        int available = 0;
        for (int i = 0; i < this.sources.length; ++i) {
            int a = this.sources[i].available();
            if (a <= available) continue;
            available = a;
        }
        return available;
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (target.length - targetPos < length) {
            throw new IllegalArgumentException("Target array cannot hold enough data (" + (target.length - targetPos) + " left, but " + length + " requested)");
        }
        double[] buf = new double[length];
        int maxCopied = 0;
        for (int i = 0; i < this.sources.length; ++i) {
            int copied = this.sources[i].getData(buf);
            if (copied > maxCopied) {
                Arrays.fill(target, targetPos + maxCopied, targetPos + copied, 0.0);
                maxCopied = copied;
            }
            for (int j = 0; j < copied; ++j) {
                int n = targetPos + j;
                target[n] = target[n] + buf[j];
            }
        }
        return maxCopied;
    }
}

