/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.FFRTargetCostFunction;
import marytts.unitselection.select.Target;
import marytts.unitselection.weightingfunctions.WeightFunc;
import marytts.unitselection.weightingfunctions.WeightFunctionManager;
import marytts.vocalizations.VocalizationFeatureFileReader;

public class VocalizationFFRTargetCostFunction
extends FFRTargetCostFunction {
    private int MEANING_RATING_RANGE = 5;

    public VocalizationFFRTargetCostFunction(VocalizationFeatureFileReader ffr) {
        this(ffr, ffr.getFeatureDefinition());
    }

    public VocalizationFFRTargetCostFunction(VocalizationFeatureFileReader ffr, FeatureDefinition fDef) {
        this.load(ffr, fDef);
    }

    private void load(VocalizationFeatureFileReader ffr, FeatureDefinition fDef) {
        this.featureVectors = ffr.featureVectorMapping(fDef);
        this.featureDefinition = fDef;
        this.weightFunction = new WeightFunc[this.featureDefinition.getNumberOfContinuousFeatures()];
        WeightFunctionManager wfm = new WeightFunctionManager();
        int nDiscreteFeatures = this.featureDefinition.getNumberOfByteFeatures() + this.featureDefinition.getNumberOfShortFeatures();
        for (int i = 0; i < this.weightFunction.length; ++i) {
            String weightFunctionName = this.featureDefinition.getWeightFunctionName(nDiscreteFeatures + i);
            this.weightFunction[i] = "".equals(weightFunctionName) ? wfm.getWeightFunction("linear") : wfm.getWeightFunction(weightFunctionName);
        }
        this.rememberWhichWeightsAreNonZero();
    }

    @Override
    protected double cost(Target target, Unit unit, FeatureDefinition weights, WeightFunc[] weightFunctions) {
        int i;
        ++this.nCostComputations;
        FeatureVector targetFeatures = target.getFeatureVector();
        assert (targetFeatures != null) : "Target " + target + " does not have pre-computed feature vector";
        FeatureVector unitFeatures = this.featureVectors[unit.index];
        int nBytes = targetFeatures.byteValuedDiscreteFeatures.length;
        int nShorts = targetFeatures.shortValuedDiscreteFeatures.length;
        int nFloats = targetFeatures.continuousFeatures.length;
        assert (nBytes == unitFeatures.byteValuedDiscreteFeatures.length);
        assert (nShorts == unitFeatures.shortValuedDiscreteFeatures.length);
        assert (nFloats == unitFeatures.continuousFeatures.length);
        float[] weightVector = weights.getFeatureWeights();
        double cost = 0.0;
        if (nBytes > 0) {
            for (i = 0; i < nBytes; ++i) {
                if (!this.weightsNonZero[i]) continue;
                float weight = weightVector[i];
                if (this.featureDefinition.hasSimilarityMatrix(i)) {
                    byte targetFeatValueIndex = targetFeatures.byteValuedDiscreteFeatures[i];
                    byte unitFeatValueIndex = unitFeatures.byteValuedDiscreteFeatures[i];
                    float similarity = this.featureDefinition.getSimilarity(i, unitFeatValueIndex, targetFeatValueIndex);
                    cost += (double)(similarity * weight);
                    if (!this.debugShowCostGraph) continue;
                    int n = i;
                    this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)(similarity * weight);
                    continue;
                }
                if (targetFeatures.byteValuedDiscreteFeatures[i] == unitFeatures.byteValuedDiscreteFeatures[i]) continue;
                cost += (double)weight;
                if (!this.debugShowCostGraph) continue;
                int n = i;
                this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
            }
        }
        if (nShorts > 0) {
            int n = nBytes + nShorts;
            for (i = nBytes; i < n; ++i) {
                if (!this.weightsNonZero[i]) continue;
                float weight = weightVector[i];
                if (targetFeatures.shortValuedDiscreteFeatures[i - nBytes] == unitFeatures.shortValuedDiscreteFeatures[i - nBytes]) continue;
                cost += (double)weight;
                if (!this.debugShowCostGraph) continue;
                int n2 = i;
                this.cumulWeightedCosts[n2] = this.cumulWeightedCosts[n2] + (double)weight;
            }
        }
        if (nFloats > 0) {
            int nDiscrete;
            int n = nDiscrete + nFloats;
            for (int i2 = nDiscrete = nBytes + nShorts; i2 < n; ++i2) {
                if (!this.weightsNonZero[i2]) continue;
                float weight = weightVector[i2];
                float a = targetFeatures.continuousFeatures[i2 - nDiscrete];
                float b = unitFeatures.continuousFeatures[i2 - nDiscrete];
                if (a != a) continue;
                double myCost = b == b ? weightFunctions[i2 - nDiscrete].cost(a, b) : (double)this.MEANING_RATING_RANGE;
                cost += (double)weight * myCost;
                if (!this.debugShowCostGraph) continue;
                int n3 = i2;
                this.cumulWeightedCosts[n3] = this.cumulWeightedCosts[n3] + (double)weight * myCost;
            }
        }
        return cost;
    }

    @Override
    protected double featureCost(Target target, Unit unit, String featureName, FeatureDefinition weights, WeightFunc[] weightFunctions) {
        if (!this.featureDefinition.hasFeature(featureName)) {
            throw new IllegalArgumentException("this feature does not exists in feature definition");
        }
        FeatureVector targetFeatures = target.getFeatureVector();
        assert (targetFeatures != null) : "Target " + target + " does not have pre-computed feature vector";
        FeatureVector unitFeatures = this.featureVectors[unit.index];
        int nBytes = targetFeatures.byteValuedDiscreteFeatures.length;
        int nShorts = targetFeatures.shortValuedDiscreteFeatures.length;
        int nFloats = targetFeatures.continuousFeatures.length;
        assert (nBytes == unitFeatures.byteValuedDiscreteFeatures.length);
        assert (nShorts == unitFeatures.shortValuedDiscreteFeatures.length);
        assert (nFloats == unitFeatures.continuousFeatures.length);
        int featureIndex = this.featureDefinition.getFeatureIndex(featureName);
        float[] weightVector = weights.getFeatureWeights();
        double cost = 0.0;
        if (featureIndex < nBytes) {
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                if (this.featureDefinition.hasSimilarityMatrix(featureIndex)) {
                    byte targetFeatValueIndex = targetFeatures.byteValuedDiscreteFeatures[featureIndex];
                    byte unitFeatValueIndex = unitFeatures.byteValuedDiscreteFeatures[featureIndex];
                    float similarity = this.featureDefinition.getSimilarity(featureIndex, unitFeatValueIndex, targetFeatValueIndex);
                    cost = similarity * weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)(similarity * weight);
                    }
                } else if (targetFeatures.byteValuedDiscreteFeatures[featureIndex] != unitFeatures.byteValuedDiscreteFeatures[featureIndex]) {
                    cost = weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
                    }
                }
            }
        } else if (featureIndex < nShorts + nBytes) {
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                if (targetFeatures.shortValuedDiscreteFeatures[featureIndex - nBytes] != unitFeatures.shortValuedDiscreteFeatures[featureIndex - nBytes]) {
                    cost = weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
                    }
                }
            }
        } else {
            int nDiscrete = nBytes + nShorts;
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                float a = targetFeatures.continuousFeatures[featureIndex - nDiscrete];
                float b = unitFeatures.continuousFeatures[featureIndex - nDiscrete];
                if (a == a) {
                    double myCost = b == b ? weightFunctions[featureIndex - nDiscrete].cost(a, b) : (double)this.MEANING_RATING_RANGE;
                    cost = (double)weight * myCost;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight * myCost;
                    }
                }
            }
        }
        return cost;
    }
}

