/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.emospeak;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.client.MaryClient;
import marytts.tools.emospeak.AsynchronousThreadedMaryClient;
import marytts.tools.emospeak.AudioFileReceiver;
import marytts.tools.emospeak.EmoTransformer;
import marytts.tools.emospeak.JFeeltracePanel;
import marytts.tools.emospeak.ProsodyXMLDisplayer;
import marytts.tools.emospeak.TwoDimensionalModel;
import marytts.util.http.Address;

public class EmoSpeakPanel
extends JPanel
implements AudioFileReceiver,
ProsodyXMLDisplayer {
    private int r = 1;
    private EmoTransformer emoTransformer;
    private AsynchronousThreadedMaryClient asynchronousSynthesiser;
    private MaryClient synchronousSynthesiser;
    private AudioInputStream currentAudio = null;
    private AudioInputStream nextAudio = null;
    private Clip clip = null;
    private boolean synthesiseAsynchronously;
    private String maryServerHost;
    private int maryServerPort;
    private Map voicesByLocale;
    boolean haveGerman = false;
    private Map sampleTextsByLocale;
    private Map localeByDisplayLanguage;
    private JTextField tfPowerValue;
    private JCheckBoxMenuItem showPowerMenuItem;
    private JComboBox cbInputText;
    private JLabel lPowerValue;
    private JButton bPlay;
    private JTextPane tpProsodyXML;
    private JScrollPane jScrollPane1;
    private JCheckBoxMenuItem showMaryXMLMenuItem;
    private JLabel lActivationValue;
    private JPanel inputTextPanel;
    private JTextField tfActivationValue;
    private JLabel lVoice;
    private JLabel lProsodyXML;
    private JMenu optionsMenu;
    private JPanel dimensionValuePanel;
    private JFeeltracePanel ftPanel;
    private JComboBox cbVoice;
    private JPanel audioPanel;
    private JLabel lInputText;
    private JLabel lEvaluationValue;
    private JMenuBar jMenuBar1;
    private JTextField tfEvaluationValue;
    private JComboBox cbLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmoSpeakPanel(boolean synthesiseAsynchronously, String maryServerHost, int maryServerPort) throws IOException, UnknownHostException {
        this.synthesiseAsynchronously = synthesiseAsynchronously;
        this.maryServerHost = maryServerHost;
        this.maryServerPort = maryServerPort;
        EmoSpeakPanel emoSpeakPanel = this;
        synchronized (emoSpeakPanel) {
            this.initComponents();
            this.customInitComponents();
        }
    }

    public void initialiseMenu() {
        JRootPane rp = this.getRootPane();
        if (rp != null) {
            rp.setJMenuBar(this.jMenuBar1);
        }
    }

    public TwoDimensionalModel feeltraceModel() {
        return this.ftPanel.feeltraceModel();
    }

    public BoundedRangeModel powerModel() {
        return this.ftPanel.powerModel();
    }

    private void initComponents() {
        this.audioPanel = new JPanel();
        this.lVoice = new JLabel();
        this.cbVoice = new JComboBox();
        this.bPlay = new JButton();
        this.dimensionValuePanel = new JPanel();
        this.lActivationValue = new JLabel();
        this.tfActivationValue = new JTextField();
        this.lEvaluationValue = new JLabel();
        this.tfEvaluationValue = new JTextField();
        this.lPowerValue = new JLabel();
        this.tfPowerValue = new JTextField();
        this.inputTextPanel = new JPanel();
        this.lInputText = new JLabel();
        this.cbInputText = new JComboBox();
        this.ftPanel = new JFeeltracePanel();
        this.lProsodyXML = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tpProsodyXML = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.optionsMenu = new JMenu();
        this.showPowerMenuItem = new JCheckBoxMenuItem();
        this.showMaryXMLMenuItem = new JCheckBoxMenuItem();
        this.setLayout(new GridBagLayout());
        this.cbLanguage = new JComboBox();
        this.cbLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmoSpeakPanel.this.cbLanguageItemStateChanged(evt);
            }
        });
        this.audioPanel.add(this.cbLanguage);
        this.lVoice.setText("Voice:");
        this.audioPanel.add(this.lVoice);
        this.cbVoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmoSpeakPanel.this.cbVoiceItemStateChanged(evt);
            }
        });
        this.audioPanel.add(this.cbVoice);
        this.bPlay.setText("Play");
        this.bPlay.setMnemonic('P');
        this.bPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.bPlayActionPerformed(evt);
            }
        });
        this.audioPanel.add(this.bPlay);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.audioPanel, gridBagConstraints);
        this.dimensionValuePanel.setLayout(new GridLayout(3, 2));
        this.lActivationValue.setText("Activation");
        this.dimensionValuePanel.add(this.lActivationValue);
        this.tfActivationValue.setText("0");
        this.tfActivationValue.setPreferredSize(new Dimension(40, 21));
        this.tfActivationValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.tfActivationValueActionPerformed(evt);
            }
        });
        this.tfActivationValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EmoSpeakPanel.this.tfActivationValueFocusLost(evt);
            }
        });
        this.dimensionValuePanel.add(this.tfActivationValue);
        this.lEvaluationValue.setText("Evaluation");
        this.dimensionValuePanel.add(this.lEvaluationValue);
        this.tfEvaluationValue.setText("0");
        this.tfEvaluationValue.setPreferredSize(new Dimension(40, 21));
        this.tfEvaluationValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.tfEvaluationValueActionPerformed(evt);
            }
        });
        this.tfEvaluationValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EmoSpeakPanel.this.tfEvaluationValueFocusLost(evt);
            }
        });
        this.dimensionValuePanel.add(this.tfEvaluationValue);
        this.lPowerValue.setText("Power");
        this.dimensionValuePanel.add(this.lPowerValue);
        this.tfPowerValue.setText("0");
        this.tfPowerValue.setPreferredSize(new Dimension(40, 21));
        this.tfPowerValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.tfPowerValueActionPerformed(evt);
            }
        });
        this.tfPowerValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EmoSpeakPanel.this.tfPowerValueFocusLost(evt);
            }
        });
        this.dimensionValuePanel.add(this.tfPowerValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.dimensionValuePanel, gridBagConstraints);
        this.lInputText.setHorizontalAlignment(11);
        this.lInputText.setText("Text:");
        this.inputTextPanel.add(this.lInputText);
        this.cbInputText.setEditable(true);
        this.cbInputText.setFont(new Font("Dialog", 0, 10));
        this.cbInputText.setToolTipText("Type or select the text to be spoken.");
        this.cbInputText.setPreferredSize(new Dimension(350, 26));
        this.cbInputText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.cbInputTextActionPerformed(evt);
            }
        });
        this.cbInputText.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmoSpeakPanel.this.cbInputTextItemStateChanged(evt);
            }
        });
        this.inputTextPanel.add(this.cbInputText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.inputTextPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.ftPanel, gridBagConstraints);
        this.lProsodyXML.setText("Prosody XML:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this.lProsodyXML, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.tpProsodyXML.setBorder(new EtchedBorder());
        this.tpProsodyXML.setEditable(false);
        this.tpProsodyXML.setPreferredSize(new Dimension(400, 100));
        this.jScrollPane1.setViewportView(this.tpProsodyXML);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.optionsMenu.setText("Options");
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmoSpeakPanel.this.optionsMenuActionPerformed(evt);
            }
        });
        this.showPowerMenuItem.setSelected(true);
        this.showPowerMenuItem.setText("Show Power");
        this.showPowerMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmoSpeakPanel.this.showPowerMenuItemItemStateChanged(evt);
            }
        });
        this.optionsMenu.add(this.showPowerMenuItem);
        this.showMaryXMLMenuItem.setSelected(true);
        this.showMaryXMLMenuItem.setText("Show Prosody XML");
        this.showMaryXMLMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EmoSpeakPanel.this.showMaryXMLMenuItemItemStateChanged(evt);
            }
        });
        this.optionsMenu.add(this.showMaryXMLMenuItem);
        this.jMenuBar1.add(this.optionsMenu);
    }

    private void tfActivationValueActionPerformed(ActionEvent evt) {
        this.updateFeeltraceModelFromTextFields();
    }

    private void tfEvaluationValueFocusLost(FocusEvent evt) {
        this.updateFeeltraceModelFromTextFields();
    }

    private void bPlayActionPerformed(ActionEvent evt) {
        if (this.bPlay.getText().equals("Play")) {
            try {
                this.preparePlayAudio();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "Cannot play audio", 0);
                return;
            }
            this.bPlay.setText("Stop");
            this.playAudio();
        } else {
            this.bPlay.setText("Play");
            if (this.clip != null) {
                this.clip.stop();
            }
        }
    }

    private void optionsMenuActionPerformed(ActionEvent evt) {
    }

    private void cbInputTextItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.requestUpdateProsodyXML();
        }
    }

    private void cbLanguageItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.updateVoices();
            this.updateSampleTexts();
        }
    }

    private Vector readSampleTexts(Locale locale) {
        Vector<String> texts = new Vector<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("sampletexts_" + locale.getLanguage() + ".txt"), "UTF-8"));
            while ((line = br.readLine()) != null) {
                if (line.trim().equals("")) continue;
                texts.add(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return texts;
    }

    private Locale getSelectedLanguage() {
        String displayLanguage = (String)this.cbLanguage.getSelectedItem();
        return (Locale)this.localeByDisplayLanguage.get(displayLanguage);
    }

    private void updateVoices() {
        Locale locale = this.getSelectedLanguage();
        this.cbVoice.removeAllItems();
        Vector voices = (Vector)this.voicesByLocale.get(locale);
        assert (voices != null);
        for (MaryClient.Voice v : voices) {
            this.cbVoice.addItem(v);
            if (!v.name().equals("de7") && !v.name().equals("de6") && !v.name().equals("us1")) continue;
            this.cbVoice.setSelectedItem(v);
        }
    }

    private void updateSampleTexts() {
        Locale locale = this.getSelectedLanguage();
        this.cbInputText.removeAllItems();
        Vector texts = (Vector)this.sampleTextsByLocale.get(locale);
        assert (texts != null);
        if (texts.size() == 0) {
            return;
        }
        for (String s : texts) {
            this.cbInputText.addItem(s);
        }
        this.cbInputText.removeItemAt(0);
        this.cbInputText.setSelectedIndex(0);
    }

    private void showPowerMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.ftPanel.setShowPower(true);
        } else {
            this.ftPanel.setShowPower(false);
            this.bPlay.requestFocusInWindow();
        }
        this.ftPanel.verifyPowerVisible();
        this.verifyPowerVisible();
    }

    private void showMaryXMLMenuItemItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.jScrollPane1.setVisible(true);
            this.lProsodyXML.setVisible(true);
        } else {
            this.jScrollPane1.setVisible(false);
            this.lProsodyXML.setVisible(false);
            this.bPlay.requestFocusInWindow();
        }
    }

    private void cbVoiceItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.requestUpdateProsodyXML();
        }
    }

    private void cbInputTextActionPerformed(ActionEvent evt) {
        Object item = this.cbInputText.getSelectedItem();
        if (((DefaultComboBoxModel)this.cbInputText.getModel()).getIndexOf(item) == -1) {
            this.cbInputText.addItem(item);
        }
        this.requestUpdateProsodyXML();
    }

    private void tfPowerValueActionPerformed(ActionEvent evt) {
        this.updatePowerModelFromTextFields();
    }

    private void tfEvaluationValueActionPerformed(ActionEvent evt) {
        this.updateFeeltraceModelFromTextFields();
    }

    private void tfActivationValueFocusLost(FocusEvent evt) {
        this.updateFeeltraceModelFromTextFields();
    }

    private void tfPowerValueFocusLost(FocusEvent evt) {
        this.updatePowerModelFromTextFields();
    }

    public void requestExit() {
        this.emoTransformer.requestExit();
        if (this.synthesiseAsynchronously) {
            this.asynchronousSynthesiser.requestExit();
        }
    }

    private synchronized void customInitComponents() throws IOException, UnknownHostException {
        Vector<MaryClient.Voice> voiceInfo;
        if (this.synthesiseAsynchronously) {
            this.asynchronousSynthesiser = this.maryServerHost == null ? new AsynchronousThreadedMaryClient(this) : new AsynchronousThreadedMaryClient(this, this.maryServerHost, this.maryServerPort, false, false);
            this.asynchronousSynthesiser.start();
        } else {
            this.synchronousSynthesiser = this.maryServerHost == null ? MaryClient.getMaryClient() : MaryClient.getMaryClient(new Address(this.maryServerHost, this.maryServerPort), false, false);
        }
        try {
            this.emoTransformer = new EmoTransformer(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.emoTransformer.start();
        this.verifyPowerVisible();
        this.feeltraceModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EmoSpeakPanel.this.updateFeeltraceDisplays();
                EmoSpeakPanel.this.requestUpdateProsodyXML();
            }
        });
        if (this.ftPanel.showPower()) {
            this.powerModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    EmoSpeakPanel.this.updatePowerDisplays();
                    EmoSpeakPanel.this.requestUpdateProsodyXML();
                }
            });
        }
        if ((voiceInfo = this.synthesiseAsynchronously ? this.asynchronousSynthesiser.getServerVoices() : this.synchronousSynthesiser.getGeneralDomainVoices()) == null) {
            int port;
            String host;
            if (this.synthesiseAsynchronously) {
                host = this.asynchronousSynthesiser.getHost();
                port = this.asynchronousSynthesiser.getPort();
            } else {
                host = this.synchronousSynthesiser.getHost();
                port = this.synchronousSynthesiser.getPort();
            }
            JOptionPane.showMessageDialog(null, "Cannot start EmoSpeak: Server " + host + ":" + port + " has no general domain voices!", "No voices available", 0);
            System.exit(1);
        }
        this.voicesByLocale = new HashMap();
        this.sampleTextsByLocale = new HashMap();
        this.localeByDisplayLanguage = new HashMap();
        for (MaryClient.Voice v : voiceInfo) {
            if (!this.voicesByLocale.containsKey(v.getLocale())) {
                this.voicesByLocale.put(v.getLocale(), new Vector());
            }
            Vector localeVoices = (Vector)this.voicesByLocale.get(v.getLocale());
            localeVoices.add(v);
            if (!v.getLocale().equals(Locale.GERMAN)) continue;
            this.haveGerman = true;
        }
        for (Locale locale : this.voicesByLocale.keySet()) {
            this.sampleTextsByLocale.put(locale, this.readSampleTexts(locale));
            this.localeByDisplayLanguage.put(locale.getDisplayLanguage(), locale);
            this.cbLanguage.addItem(locale.getDisplayLanguage());
        }
        if (this.haveGerman) {
            this.cbLanguage.setSelectedItem(Locale.GERMAN);
        }
        this.updateVoices();
        this.updateSampleTexts();
    }

    private void updateFeeltraceModelFromTextFields() {
        boolean validA = false;
        boolean validE = false;
        int A = 0;
        int E = 0;
        try {
            A = Integer.parseInt(this.tfActivationValue.getText());
            if (this.feeltraceModel().getMinY() <= A && A <= this.feeltraceModel().getMaxY()) {
                validA = true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            E = Integer.parseInt(this.tfEvaluationValue.getText());
            if (this.feeltraceModel().getMinX() <= E && E <= this.feeltraceModel().getMaxX()) {
                validE = true;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        int newA = validA ? A : this.feeltraceModel().getY();
        int newE = validE ? E : this.feeltraceModel().getX();
        this.feeltraceModel().setXY(newE, newA);
    }

    private void updatePowerModelFromTextFields() {
        boolean valid = false;
        int value = 0;
        try {
            value = Integer.parseInt(this.tfPowerValue.getText());
            if (value >= this.powerModel().getMinimum() && value <= this.powerModel().getMaximum()) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (valid) {
            this.powerModel().setValue(value);
        } else {
            this.tfPowerValue.setText(String.valueOf(this.powerModel().getValue()));
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.verifyPowerVisible();
        super.paintComponent(graphics);
    }

    private void verifyPowerVisible() {
        this.lPowerValue.setVisible(this.ftPanel.showPower());
        this.tfPowerValue.setVisible(this.ftPanel.showPower());
    }

    private void updateFeeltraceDisplays() {
        this.tfActivationValue.setText(String.valueOf(this.feeltraceModel().getY()));
        this.tfEvaluationValue.setText(String.valueOf(this.feeltraceModel().getX()));
    }

    private void updatePowerDisplays() {
        this.tfPowerValue.setText(String.valueOf(this.powerModel().getValue()));
    }

    private void requestUpdateProsodyXML() {
        Object selectedText = this.cbInputText.getSelectedItem();
        if (selectedText == null) {
            return;
        }
        String text = selectedText.toString();
        this.emoTransformer.setEmotionValues(this.feeltraceModel().getY(), this.feeltraceModel().getX(), this.powerModel().getValue(), text, this.getSelectedLanguage(), this.r++);
    }

    @Override
    public synchronized void updateProsodyXML(String prosodyxmlString, int r1) {
        this.tpProsodyXML.setText(prosodyxmlString);
        if (this.synthesiseAsynchronously) {
            MaryClient.Voice maryClientVoice = (MaryClient.Voice)this.cbVoice.getSelectedItem();
            assert (maryClientVoice != null);
            this.asynchronousSynthesiser.scheduleRequest(prosodyxmlString, maryClientVoice, r1);
        }
    }

    private void preparePlayAudio() throws Exception {
        if (this.synthesiseAsynchronously) {
            if (this.nextAudio != null) {
                this.currentAudio = this.nextAudio;
                this.nextAudio = null;
            }
        } else {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.synchronousSynthesiser.process(this.tpProsodyXML.getText(), "RAWMARYXML", "AUDIO", ((MaryClient.Voice)this.cbVoice.getSelectedItem()).getLocale().toString(), "AU", ((MaryClient.Voice)this.cbVoice.getSelectedItem()).name(), os);
            byte[] bytes = os.toByteArray();
            this.currentAudio = AudioSystem.getAudioInputStream(new ByteArrayInputStream(bytes));
        }
        if (!(this.currentAudio != null || this.clip != null && this.clip.isOpen())) {
            this.bPlay.setEnabled(false);
            throw new Exception("No audio data to play (did synthesis succeed?)");
        }
        if (this.currentAudio != null) {
            if (this.clip != null && this.clip.isOpen()) {
                this.closeClip();
            }
            DataLine.Info info = new DataLine.Info(Clip.class, this.currentAudio.getFormat());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent le) {
                    if (le.getType() == LineEvent.Type.STOP) {
                        EmoSpeakPanel.this.closeAudio();
                    }
                }
            });
            this.clip.open(this.currentAudio);
            this.currentAudio.close();
            this.currentAudio = null;
        }
        this.clip.setFramePosition(0);
    }

    private void playAudio() {
        assert (this.clip != null && this.clip.isOpen());
        this.clip.start();
    }

    private void closeAudio() {
        this.bPlay.setText("Play");
    }

    private void closeClip() {
        if (!System.getProperty("java.vendor").equals("Sun Microsystems Inc.") || !System.getProperty("os.name").equals("Linux")) {
            this.clip.close();
        }
    }

    @Override
    public void setNextAudio(AudioInputStream audioInputStream) {
        this.nextAudio = audioInputStream;
    }
}

