/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.window;

import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.LogSpectrum;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;

public class BlackmanWindow
extends Window {
    public BlackmanWindow(int length) {
        super(length);
    }

    public BlackmanWindow(int length, double prescalingFactor) {
        super(length, prescalingFactor);
    }

    @Override
    protected void initialise() {
        boolean prescale = this.prescalingFactor != 1.0;
        for (int i = 0; i < this.window.length; ++i) {
            this.window[i] = 0.42 - 0.5 * Math.cos((double)(i * 2) * Math.PI / (double)(this.window.length - 1)) + 0.08 * Math.cos((double)(i * 4) * Math.PI / (double)(this.window.length - 1));
            if (!prescale) continue;
            int n = i;
            this.window[n] = this.window[n] * this.prescalingFactor;
        }
    }

    public String toString() {
        return "Blackman window";
    }

    public static void main(String[] args) {
        int samplingRate = Integer.getInteger("samplingrate", 1);
        int windowLengthMs = Integer.getInteger("windowlength.ms", 0);
        int windowLength = Integer.getInteger("windowlength.samples", 512);
        if (windowLengthMs != 0) {
            windowLength = windowLengthMs * samplingRate / 1000;
        }
        int fftSize = Math.max(4096, MathUtils.closestPowerOfTwoAbove(windowLength));
        BlackmanWindow w = new BlackmanWindow(windowLength);
        FunctionGraph timeGraph = new FunctionGraph(0.0, 1.0 / (double)samplingRate, w.window);
        timeGraph.showInJFrame(((Object)w).toString() + " in time domain", true, false);
        double[] fftSignal = new double[fftSize];
        double sum = MathUtils.sum(w.window);
        for (int i = 0; i < w.window.length; ++i) {
            fftSignal[i] = w.window[i] / sum;
        }
        LogSpectrum freqGraph = new LogSpectrum(fftSignal, samplingRate);
        freqGraph.showInJFrame(((Object)w).toString() + " log frequency response", true, false);
    }
}

