/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.FrameNoisePartLpc;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.signalproc.window.Window;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class NoisePartWindowedOverlapAddLpcSynthesizer {
    public static double[] synthesize(HntmSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams, HntmSynthesizerParams synthesisParams) {
        int startIndexNext;
        float tsiNext;
        boolean isVoiced;
        boolean isNoised;
        int i;
        double[] noisePart = null;
        int lpOrder = 0;
        float tsi = 0.0f;
        int startIndex = 0;
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        for (i = 0; i < hnmSignal.frames.length; ++i) {
            boolean bl = isNoised = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
            if (!isNoised || hnmSignal.frames[i].n == null || !(hnmSignal.frames[i].n instanceof FrameNoisePartLpc) || ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs == null) continue;
            lpOrder = ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs.length;
            break;
        }
        if (lpOrder > 0) {
            noisePart = new double[outputLen];
            Arrays.fill(noisePart, 0.0);
            double[] winWgtSum = new double[outputLen];
            Arrays.fill(winWgtSum, 0.0);
            int windowType = 1;
            double[] yInitial = new double[lpOrder];
            Arrays.fill(yInitial, 0.0);
            int fftSizeNoise = SignalProcUtils.getDFTSize(hnmSignal.samplingRateInHz);
            int wsNoise = 0;
            boolean isDisplay = false;
            Object noiseSourceHpf = null;
            int transitionOverlapLen = SignalProcUtils.time2sample(synthesisParams.noiseSynthesisTransitionOverlapInSeconds, hnmSignal.samplingRateInHz);
            for (i = 0; i < hnmSignal.frames.length; ++i) {
                isVoiced = hnmSignal.frames[i].h != null && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f;
                boolean isNextVoiced = i < hnmSignal.frames.length - 1 && hnmSignal.frames[i + 1].h != null && hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz > 0.0f;
                isNoised = hnmSignal.frames[i].n != null && hnmSignal.frames[i].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz;
                boolean isNextNoised = i < hnmSignal.frames.length - 1 && hnmSignal.frames[i + 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz && hnmSignal.frames[i + 1].n != null;
                boolean isPrevNoised = i > 0 && hnmSignal.frames[i - 1].maximumFrequencyOfVoicingInHz < 0.5f * (float)hnmSignal.samplingRateInHz && hnmSignal.frames[i - 1].n != null;
                float noiseWindowDurationInSeconds = i < hnmSignal.frames.length - 1 && isNextNoised ? Math.max(synthesisParams.noiseSynthesisWindowDurationInSeconds, 2.0f * (hnmSignal.frames[i + 1].tAnalysisInSeconds - hnmSignal.frames[i].tAnalysisInSeconds)) : synthesisParams.noiseSynthesisWindowDurationInSeconds;
                wsNoise = SignalProcUtils.time2sample(noiseWindowDurationInSeconds, hnmSignal.samplingRateInHz);
                if (!isNextNoised) {
                    wsNoise += transitionOverlapLen;
                }
                if (!isPrevNoised) {
                    wsNoise += transitionOverlapLen;
                }
                if (wsNoise % 2 == 0) {
                    ++wsNoise;
                }
                tsi = i == 0 ? 0.0f : Math.max(0.0f, hnmSignal.frames[i].tAnalysisInSeconds - 0.5f * noiseWindowDurationInSeconds);
                startIndex = SignalProcUtils.time2sample(tsi, hnmSignal.samplingRateInHz);
                if (i < hnmSignal.frames.length - 1) {
                    tsiNext = Math.max(0.0f, hnmSignal.frames[i].tAnalysisInSeconds + 0.5f * noiseWindowDurationInSeconds);
                    startIndexNext = SignalProcUtils.time2sample(tsiNext, hnmSignal.samplingRateInHz);
                } else {
                    startIndexNext = outputLen - 1;
                    tsiNext = SignalProcUtils.sample2time(startIndexNext, hnmSignal.samplingRateInHz);
                }
                if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc) {
                    Window winNoise = Window.get(windowType, wsNoise);
                    winNoise.normalizePeakValue(1.0f);
                    double[] wgt = winNoise.getCoeffs();
                    double[] x = SignalProcUtils.getWhiteNoiseOfVariance(wsNoise, 1.0);
                    if (isNoised && hnmSignal.frames[i].n != null && hnmSignal.frames[i].n instanceof FrameNoisePartLpc && ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs != null) {
                        winNoise.apply(x, 0);
                        double[] y = SignalProcUtils.arFilter(x, ((FrameNoisePartLpc)hnmSignal.frames[i].n).lpCoeffs, 1.0);
                        if (synthesisParams.hpfAfterNoiseSynthesis) {
                            y = SignalProcUtils.fdFilter(y, hnmSignal.frames[i].maximumFrequencyOfVoicingInHz, 0.5f * (float)hnmSignal.samplingRateInHz, hnmSignal.samplingRateInHz, fftSizeNoise);
                        }
                        MathUtils.adjustStandardDeviation(y, ((FrameNoisePartLpc)hnmSignal.frames[i].n).origNoiseStd);
                        for (int n = startIndex; n < Math.min(startIndex + wsNoise, noisePart.length); ++n) {
                            int n2 = n;
                            noisePart[n2] = noisePart[n2] + y[n - startIndex] * wgt[n - startIndex] * wgt[n - startIndex];
                            int n3 = n;
                            winWgtSum[n3] = winWgtSum[n3] + wgt[n - startIndex] * wgt[n - startIndex] * wgt[n - startIndex];
                        }
                    }
                }
                System.out.println("LPC noise synthesis complete at " + String.valueOf(hnmSignal.frames[i].tAnalysisInSeconds) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(hnmSignal.frames.length) + "..." + String.valueOf(startIndex) + "-" + String.valueOf(startIndex + wsNoise));
            }
            for (i = 0; i < winWgtSum.length; ++i) {
                if (!(winWgtSum[i] > 0.0)) continue;
                int n = i;
                noisePart[n] = noisePart[n] / winWgtSum[i];
                if (!Double.isNaN(noisePart[i])) continue;
                noisePart[i] = 0.0;
            }
        }
        if (synthesisParams.applyTriangularNoiseEnvelopeForVoicedParts) {
            tsiNext = 0.0f;
            for (i = 0; i < hnmSignal.frames.length; ++i) {
                int n;
                boolean bl = isVoiced = hnmSignal.frames[i].maximumFrequencyOfVoicingInHz > 0.0f;
                if (!isVoiced) continue;
                tsi = i == 0 ? 0.0f : hnmSignal.frames[i].tAnalysisInSeconds;
                startIndex = SignalProcUtils.time2sample(tsi, hnmSignal.samplingRateInHz);
                if (i < hnmSignal.frames.length - 1) {
                    tsiNext = Math.max(0.0f, hnmSignal.frames[i + 1].tAnalysisInSeconds);
                    startIndexNext = SignalProcUtils.time2sample(tsiNext, hnmSignal.samplingRateInHz);
                } else {
                    startIndexNext = outputLen - 1;
                    tsiNext = SignalProcUtils.sample2time(startIndexNext, hnmSignal.samplingRateInHz);
                }
                int enEnvLen = startIndexNext - startIndex + 1;
                if (enEnvLen <= 0) continue;
                double[] enEnv = new double[enEnvLen];
                int l1 = SignalProcUtils.time2sample(0.15 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                int l2 = SignalProcUtils.time2sample(0.85 * (double)(tsiNext - tsi), hnmSignal.samplingRateInHz);
                int lMid = (int)Math.floor(0.5 * (double)(l1 + l2) + 0.5);
                for (n = 0; n < l1; ++n) {
                    enEnv[n] = synthesisParams.energyTriangleLowerValue;
                }
                for (n = l1; n < lMid; ++n) {
                    enEnv[n] = (double)(n - l1) * (synthesisParams.energyTriangleUpperValue - synthesisParams.energyTriangleLowerValue) / (double)(lMid - l1) + synthesisParams.energyTriangleLowerValue;
                }
                for (n = lMid; n < l2; ++n) {
                    enEnv[n] = (double)(n - lMid) * (synthesisParams.energyTriangleLowerValue - synthesisParams.energyTriangleUpperValue) / (double)(l2 - lMid) + synthesisParams.energyTriangleUpperValue;
                }
                for (n = l2; n < enEnvLen; ++n) {
                    enEnv[n] = synthesisParams.energyTriangleLowerValue;
                }
                for (n = startIndex; n <= Math.min(noisePart.length - 1, startIndexNext); ++n) {
                    int n4 = n;
                    noisePart[n4] = noisePart[n4] * enEnv[n - startIndex];
                }
            }
        }
        if (analysisParams.preemphasisCoefNoise > 0.0f) {
            noisePart = SignalProcUtils.removePreemphasis(noisePart, analysisParams.preemphasisCoefNoise);
        }
        MathUtils.adjustMean(noisePart, 0.0);
        return noisePart;
    }
}

