/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechFrame;
import marytts.signalproc.sinusoidal.NonharmonicSinusoidalSpeechSignal;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.signalproc.sinusoidal.TrackGenerator;
import marytts.signalproc.window.Window;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PitchSynchronousSinusoidalAnalyzer
extends SinusoidalAnalyzer {
    public static float DEFAULT_ANALYSIS_PERIODS = 2.5f;

    public PitchSynchronousSinusoidalAnalyzer(SinusoidalAnalysisParams paramsIn) {
        super(paramsIn);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm) {
        return this.analyzePitchSynchronous(x, pm, DEFAULT_ANALYSIS_PERIODS, -1.0f);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm, float numPeriods) {
        return this.analyzePitchSynchronous(x, pm, numPeriods, -1.0f);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds) {
        return this.analyzePitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, 50.0f);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz) {
        return this.analyzePitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, 0);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType) {
        return this.analyzePitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, null);
    }

    public SinusoidalTracks analyzePitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType, float[] initialPeakLocationsInHz) {
        TrackGenerator tg = new TrackGenerator();
        NonharmonicSinusoidalSpeechSignal sinSignal = this.extracSinusoidsPitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, spectralEnvelopeType, initialPeakLocationsInHz);
        SinusoidalTracks sinTracks = tg.generateTracks(sinSignal, deltaInHz, this.params.fs);
        if (sinTracks != null) {
            sinTracks.getTrackStatistics();
            PitchSynchronousSinusoidalAnalyzer.getGrossStatistics(sinTracks);
        }
        sinTracks.absMaxOriginal = (float)this.params.absMax;
        sinTracks.totalEnergy = (float)this.params.totalEnergy;
        return sinTracks;
    }

    public NonharmonicSinusoidalSpeechSignal extracSinusoidsPitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz) {
        return this.extracSinusoidsPitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, 0);
    }

    public NonharmonicSinusoidalSpeechSignal extracSinusoidsPitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType) {
        return this.extracSinusoidsPitchSynchronous(x, pm, numPeriods, skipSizeInSeconds, deltaInHz, 0, null);
    }

    public NonharmonicSinusoidalSpeechSignal extracSinusoidsPitchSynchronous(double[] x, PitchMarks pm, float numPeriods, float skipSizeInSeconds, float deltaInHz, int spectralEnvelopeType, float[] initialPeakLocationsInHz) {
        int i;
        int totalFrm;
        this.params.absMax = MathUtils.getAbsMax(x);
        this.params.totalEnergy = SignalProcUtils.energy(x);
        boolean bFixedSkipRate = false;
        if (skipSizeInSeconds > 0.0f) {
            this.params.ss = (int)Math.floor((double)(skipSizeInSeconds * (float)this.params.fs) + 0.5);
            bFixedSkipRate = true;
        }
        if (!bFixedSkipRate) {
            totalFrm = (int)Math.floor((double)((float)pm.pitchMarks.length - numPeriods) + 0.5);
            if (totalFrm > pm.pitchMarks.length - 1) {
                totalFrm = pm.pitchMarks.length - 1;
            }
        } else {
            totalFrm = (int)((double)(x.length / this.params.ss) + 0.5);
        }
        double[] frm = null;
        NonharmonicSinusoidalSpeechSignal sinSignal = new NonharmonicSinusoidalSpeechSignal(totalFrm);
        boolean[] isSinusoidNulls = new boolean[totalFrm];
        Arrays.fill(isSinusoidNulls, false);
        int totalNonNull = 0;
        int pmInd = 0;
        int currentTimeInd = 0;
        boolean isOutputToTextFile = false;
        for (i = 0; i < totalFrm; ++i) {
            float currentTime;
            int j;
            float f0;
            boolean isVoiced;
            int T0;
            if (!bFixedSkipRate) {
                T0 = pm.pitchMarks[i + 1] - pm.pitchMarks[i];
                isVoiced = (double)pm.f0s[i] > 10.0;
                f0 = pm.f0s[i];
            } else {
                while (pm.pitchMarks[pmInd] < currentTimeInd) {
                    if (++pmInd <= pm.pitchMarks.length - 1) continue;
                    pmInd = pm.pitchMarks.length - 1;
                    break;
                }
                if (pmInd < pm.pitchMarks.length - 1) {
                    T0 = pm.pitchMarks[pmInd + 1] - pm.pitchMarks[pmInd];
                    isVoiced = (double)pm.f0s[pmInd] > 10.0;
                } else {
                    T0 = pm.pitchMarks[pmInd] - pm.pitchMarks[pmInd - 1];
                    isVoiced = (double)pm.f0s[pmInd - 1] > 10.0;
                }
                f0 = (float)this.params.fs / (float)T0;
            }
            this.params.ws = (int)Math.floor((double)(numPeriods * (float)T0) + 0.5);
            if (this.params.ws % 2 == 0) {
                ++this.params.ws;
            }
            this.params.ws = Math.max(this.params.ws, this.params.minWindowSize);
            frm = new double[this.params.ws];
            Arrays.fill(frm, 0.0);
            if (!bFixedSkipRate) {
                for (j = pm.pitchMarks[i]; j < Math.min(pm.pitchMarks[i] + this.params.ws - 1, x.length); ++j) {
                    frm[j - pm.pitchMarks[i]] = x[j];
                }
            } else {
                for (j = currentTimeInd; j < Math.min(currentTimeInd + this.params.ws - 1, x.length); ++j) {
                    frm[j - currentTimeInd] = x[j];
                }
            }
            this.params.win = Window.get(this.params.windowType, this.params.ws);
            this.params.win.applyInline(frm, 0, this.params.ws);
            if (!bFixedSkipRate) {
                currentTime = ((float)pm.pitchMarks[i] + 0.5f * (float)this.params.ws) / (float)this.params.fs;
            } else {
                currentTime = ((float)currentTimeInd + 0.5f * (float)this.params.ws) / (float)this.params.fs;
                currentTimeInd += this.params.ss;
            }
            sinSignal.framesSins[i] = initialPeakLocationsInHz == null ? PitchSynchronousSinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, f0, this.params) : PitchSynchronousSinusoidalAnalyzer.analyze_frame(frm, isOutputToTextFile, spectralEnvelopeType, isVoiced, f0, initialPeakLocationsInHz[initialPeakLocationsInHz.length - 1] + 50.0f, false, this.params, initialPeakLocationsInHz);
            if (sinSignal.framesSins[i] != null) {
                for (j = 0; j < sinSignal.framesSins[i].sinusoids.length; ++j) {
                    sinSignal.framesSins[i].sinusoids[j].frameIndex = i;
                }
            }
            int peakCount = 0;
            if (sinSignal.framesSins[i] == null) {
                isSinusoidNulls[i] = true;
            } else {
                isSinusoidNulls[i] = false;
                ++totalNonNull;
                peakCount = sinSignal.framesSins[i].sinusoids.length;
            }
            if (sinSignal.framesSins[i] != null) {
                sinSignal.framesSins[i].time = currentTime;
            }
            System.out.println("Analysis complete at " + String.valueOf(currentTime) + "s. for frame " + String.valueOf(i + 1) + " of " + String.valueOf(totalFrm) + "(found " + String.valueOf(peakCount) + " peaks)");
        }
        NonharmonicSinusoidalSpeechSignal sinSignal2 = null;
        Object voicings2 = null;
        if (totalNonNull > 0) {
            sinSignal2 = new NonharmonicSinusoidalSpeechSignal(totalNonNull);
            int ind = 0;
            for (i = 0; i < totalFrm; ++i) {
                if (isSinusoidNulls[i]) continue;
                sinSignal2.framesSins[ind] = new NonharmonicSinusoidalSpeechFrame(sinSignal.framesSins[i]);
                if (++ind > totalNonNull - 1) break;
            }
            sinSignal2.originalDurationInSeconds = (float)x.length / (float)this.params.fs;
        }
        return sinSignal2;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
        PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
        int pitchMarkOffset = 0;
        PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, pitchMarkOffset);
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        int windowType = 1;
        boolean bRefinePeakEstimatesParabolaIn = true;
        boolean bRefinePeakEstimatesBiasIn = true;
        boolean bSpectralReassignmentIn = true;
        boolean bAdjustNeighFreqDependentIn = true;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabolaIn, bRefinePeakEstimatesBiasIn, bSpectralReassignmentIn, bAdjustNeighFreqDependentIn);
        PitchSynchronousSinusoidalAnalyzer sa = new PitchSynchronousSinusoidalAnalyzer(params);
        SinusoidalTracks st = sa.analyzePitchSynchronous(x, pm);
    }
}

