/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;

public class FrameProvider {
    protected DoubleDataSource signal;
    protected InlineDataProcessor processor;
    protected int samplingRate;
    protected long frameStart;
    protected long nextFrameStart;
    protected int totalRead = 0;
    protected double[] frame;
    protected int validSamplesInFrame;
    protected int frameShift;
    protected int frameLength;
    private double[] memory;
    private int posInMemory;
    private boolean memoryFilled;
    private boolean stopWhenTouchingEnd;

    public FrameProvider(DoubleDataSource signal, InlineDataProcessor processor, int frameLength, int frameShift, int samplingRate, boolean stopWhenTouchingEnd) {
        this.signal = signal;
        this.processor = processor;
        this.frameShift = frameShift;
        this.frameLength = frameLength;
        this.samplingRate = samplingRate;
        this.frame = new double[frameLength];
        this.frameStart = -1L;
        this.nextFrameStart = 0L;
        this.validSamplesInFrame = 0;
        this.memory = new double[frameLength];
        this.posInMemory = this.memory.length;
        this.memoryFilled = false;
        this.stopWhenTouchingEnd = stopWhenTouchingEnd;
    }

    public double getFrameStartTime() {
        return (double)this.frameStart / (double)this.samplingRate;
    }

    public long getFrameStartSamples() {
        return this.frameStart;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public double getFrameShiftTime() {
        return (double)this.frameShift / (double)this.samplingRate;
    }

    public int getFrameShiftSamples() {
        return this.frameShift;
    }

    public double getFrameLengthTime() {
        return (double)this.getFrameLengthSamples() / (double)this.samplingRate;
    }

    public int getFrameLengthSamples() {
        return this.frameLength;
    }

    public boolean stopWhenTouchingEnd() {
        return this.stopWhenTouchingEnd;
    }

    public boolean hasMoreData() {
        return this.signal.hasMoreData() || !this.stopWhenTouchingEnd && this.memoryFilled && this.posInMemory < this.memory.length;
    }

    public int validSamplesInFrame() {
        return this.validSamplesInFrame;
    }

    public double[] getNextFrame() {
        int nFromMemory;
        this.frameStart = this.nextFrameStart;
        if (!this.hasMoreData()) {
            this.validSamplesInFrame = 0;
            return null;
        }
        if (this.memoryFilled && this.posInMemory < this.memory.length) {
            nFromMemory = this.memory.length - this.posInMemory;
            System.arraycopy(this.memory, this.posInMemory, this.frame, 0, nFromMemory);
        } else {
            nFromMemory = 0;
        }
        int read = this.getData(nFromMemory);
        this.totalRead += read;
        if (nFromMemory + read < this.frameLength) {
            assert (!this.signal.hasMoreData());
            Arrays.fill(this.frame, nFromMemory + read, this.frame.length, 0.0);
        }
        this.validSamplesInFrame = nFromMemory + read;
        int amountToRemember = this.frameLength - this.frameShift;
        if (this.validSamplesInFrame < this.frameLength) {
            amountToRemember = this.validSamplesInFrame - this.frameShift;
        }
        if (amountToRemember > 0) {
            if (this.memory.length < amountToRemember) {
                this.memory = new double[amountToRemember];
            }
            System.arraycopy(this.frame, this.validSamplesInFrame - amountToRemember, this.memory, this.memory.length - amountToRemember, amountToRemember);
            this.posInMemory = this.memory.length - amountToRemember;
            this.memoryFilled = true;
        } else {
            this.posInMemory = this.memory.length;
            this.memoryFilled = false;
        }
        if (this.processor != null) {
            this.processor.applyInline(this.frame, 0, this.frameLength);
        }
        this.nextFrameStart = this.frameStart + (long)this.frameShift;
        return this.frame;
    }

    public double[] getCurrentFrame() {
        return this.frame;
    }

    protected int getData(int nPrefilled) {
        return this.signal.getData(this.frame, nPrefilled, this.frame.length - nPrefilled);
    }

    public void resetInternalTimer() {
        this.frameStart = -1L;
        this.nextFrameStart = 0L;
        this.totalRead = 0;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[i]));
            int samplingRate = (int)inputAudio.getFormat().getSampleRate();
            double[] signal = new AudioDoubleDataSource(inputAudio).getAllData();
            FrameProvider fp = new FrameProvider(new BufferedDoubleDataSource(signal), null, 2048, 512, samplingRate, false);
            double[] result = new double[signal.length];
            int resultPos = 0;
            while (fp.hasMoreData()) {
                double[] frame = fp.getNextFrame();
                if (fp.validSamplesInFrame() >= fp.getFrameShiftSamples()) {
                    System.arraycopy(frame, 0, result, resultPos, fp.getFrameShiftSamples());
                    resultPos += fp.getFrameShiftSamples();
                    continue;
                }
                System.arraycopy(frame, 0, result, resultPos, fp.validSamplesInFrame());
                resultPos += fp.validSamplesInFrame();
            }
            System.err.println("Signal has length " + signal.length + ", result " + resultPos);
            double err = MathUtils.sumSquaredError(signal, result);
            System.err.println("Sum squared error: " + err);
            if (!(err > 1.0E-6)) continue;
            double[] difference = MathUtils.subtract(signal, result);
            SignalGraph diffGraph = new SignalGraph(difference, samplingRate);
            diffGraph.showInJFrame("difference", true, true);
        }
    }
}

