/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.filter.FIRBandPassFilterBankAnalyser;
import marytts.signalproc.filter.Subband;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.signal.SignalProcUtils;

public class FIRBandPassFilterBankSynthesiser {
    public double[] apply(FIRBandPassFilterBankAnalyser analyser, Subband[] subbands) {
        return this.apply(analyser, subbands, true);
    }

    public double[] apply(FIRBandPassFilterBankAnalyser analyser, Subband[] subbands, boolean bNormalizeInOverlappingRegions) {
        double[] x = null;
        if (analyser != null && analyser.filters != null && subbands != null) {
            int i;
            assert (analyser.filters.length == subbands.length);
            int maxLen = subbands[0].waveform.length;
            for (i = 1; i < subbands.length; ++i) {
                maxLen = Math.max(maxLen, subbands[i].waveform.length);
            }
            x = new double[maxLen];
            Arrays.fill(x, 0.0);
            for (i = 0; i < subbands.length; ++i) {
                for (int j = 0; j < subbands[i].waveform.length; ++j) {
                    int n = j;
                    x[n] = x[n] + subbands[i].waveform[j];
                }
            }
            x = SignalProcUtils.filterfd(analyser.normalizationFilterTransformedIR, x, subbands[0].samplingRate);
        }
        return x;
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        String outFileName;
        DDSAudioInputStream outputAudio;
        AudioFormat outputFormat;
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int numBands = 4;
        double overlapAround1000Hz = 100.0;
        FIRBandPassFilterBankAnalyser analyser = new FIRBandPassFilterBankAnalyser(numBands, samplingRate, overlapAround1000Hz);
        Subband[] subbands = analyser.apply(x);
        for (int i = 0; i < subbands.length; ++i) {
            outputFormat = new AudioFormat((int)subbands[i].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
            outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(subbands[i].waveform), outputFormat);
            outFileName = args[0].substring(0, args[0].length() - 4) + "_band" + String.valueOf(i + 1) + ".wav";
            AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        }
        FIRBandPassFilterBankSynthesiser synthesiser = new FIRBandPassFilterBankSynthesiser();
        double[] y = synthesiser.apply(analyser, subbands);
        outputFormat = new AudioFormat((int)subbands[0].samplingRate, inputAudio.getFormat().getSampleSizeInBits(), inputAudio.getFormat().getChannels(), true, true);
        outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(y), outputFormat);
        outFileName = args[0].substring(0, args[0].length() - 4) + "_resynthesis" + ".wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
    }
}

