/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JPanel;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.ShortTermPhaseSpectrumAnalyser;
import marytts.signalproc.display.Spectrogram;
import marytts.signalproc.window.GaussWindow;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;

public class Phasogram
extends Spectrogram {
    public static final int DEFAULT_WINDOWSIZE = 2047;
    public static final Window DEFAULT_WINDOW = new GaussWindow(2047);
    public static final int DEFAULT_WINDOWSHIFT = 1;
    public static final int DEFAULT_FFTSIZE = 2048;
    protected static final double FREQ_MAX = 4000.0;

    public Phasogram(AudioInputStream ais) {
        this(ais, 640, 480);
    }

    public Phasogram(AudioInputStream ais, int width, int height) {
        this(ais, DEFAULT_WINDOW, 1, 2048, width, height);
    }

    public Phasogram(AudioInputStream ais, Window window, int windowShift, int fftSize) {
        this(ais, window, windowShift, fftSize, 640, 480);
    }

    public Phasogram(AudioInputStream ais, Window window, int windowShift, int fftSize, int width, int height) {
        super(ais, window, windowShift, fftSize, width, height);
    }

    public Phasogram(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public Phasogram(double[] signal, int samplingRate, int width, int height) {
        this(signal, samplingRate, DEFAULT_WINDOW, 1, 2048, width, height);
    }

    public Phasogram(double[] signal, int samplingRate, Window window, int windowShift, int fftSize, int width, int height) {
        super(signal, samplingRate, window, windowShift, fftSize, width, height);
    }

    @Override
    protected void update() {
        ShortTermPhaseSpectrumAnalyser spectrumAnalyser = new ShortTermPhaseSpectrumAnalyser(new BufferedDoubleDataSource(this.signal), this.fftSize, this.window, this.windowShift, this.samplingRate);
        this.spectra = new ArrayList();
        this.deltaF = spectrumAnalyser.getFrequencyResolution();
        long startTime = System.currentTimeMillis();
        FrameBasedAnalyser.FrameAnalysisResult<T>[] results = spectrumAnalyser.analyseAllFrames();
        for (int i = 0; i < results.length; ++i) {
            double[] phaseSpectrum = (double[])results[i].get();
            this.spectra.add(phaseSpectrum);
        }
        long endTime = System.currentTimeMillis();
        System.err.println("Computed " + this.spectra.size() + " phase spectra in " + (endTime - startTime) + " ms.");
        this.spectra_indexmax = (int)(4000.0 / this.deltaF);
        if (this.spectra_indexmax > this.fftSize / 2) {
            this.spectra_indexmax = this.fftSize / 2;
        }
        super.updateData(0.0, (double)this.windowShift / (double)this.samplingRate, new double[this.spectra.size()]);
        this.ymin = 0.0;
        this.ymax = (double)this.spectra_indexmax * this.deltaF;
        this.repaint();
    }

    @Override
    protected void initialiseDependentWindows() {
    }

    @Override
    protected JPanel getControls() {
        return null;
    }

    @Override
    protected void drawSpectrum(Graphics2D g, double[] spectrum, int image_X, int image_width, int image_refY, int image_height) {
        int rect_height;
        double yScaleFactor = (double)image_height / (double)this.spectra_indexmax;
        if (image_width < 2) {
            image_width = 2;
        }
        if ((rect_height = (int)Math.ceil(yScaleFactor)) < 2) {
            rect_height = 2;
        }
        for (int i = 0; i < this.spectra_indexmax; ++i) {
            assert (spectrum[i] >= -Math.PI && spectrum[i] <= Math.PI);
            int color = Double.isNaN(spectrum[i]) ? 255 : (int)(255.0 * (Math.PI + spectrum[i]) / (Math.PI * 2));
            g.setColor(new Color(color, color, color));
            g.fillRect(image_X, image_refY - (int)((double)i * yScaleFactor), image_width, rect_height);
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            AudioInputStream ais = AudioSystem.getAudioInputStream(new File(args[i]));
            double[] signal = new AudioDoubleDataSource(ais).getAllData();
            int nFrames = 500;
            int startSample = 5000;
            int fftSize = 2048;
            double[] excerpt = new double[nFrames + fftSize];
            System.arraycopy(signal, startSample, excerpt, 0, excerpt.length);
            Phasogram signalSpectrum = new Phasogram(excerpt, (int)ais.getFormat().getSampleRate());
            signalSpectrum.showInJFrame(args[i], false, true);
        }
    }
}

