/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.Window;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.FFT;

public class ShortTermAutocorrelationAnalyser
extends FrameBasedAnalyser {
    protected double[] correlationInput;

    public ShortTermAutocorrelationAnalyser(DoubleDataSource signal, Window window, int frameShift, int samplingRate) {
        super(signal, window, frameShift, samplingRate);
        this.correlationInput = new double[2 * window.getLength()];
    }

    public Object analyse(double[] frame) {
        if (frame.length != this.getFrameLengthSamples()) {
            throw new IllegalArgumentException("Expected frame of length " + this.getFrameLengthSamples() + ", got " + frame.length);
        }
        System.arraycopy(frame, 0, this.correlationInput, 0, frame.length);
        Arrays.fill(this.correlationInput, frame.length, this.correlationInput.length, 0.0);
        return FFT.autoCorrelate(this.correlationInput);
    }
}

