/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import marytts.signalproc.analysis.PitchFileHeader;
import marytts.util.data.ESTTrackReader;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class PitchMarks {
    public int[] pitchMarks;
    public float[] f0s;
    public int totalZerosToPadd;

    public PitchMarks() {
        this.pitchMarks = null;
        this.f0s = null;
        this.totalZerosToPadd = 0;
    }

    public PitchMarks(ESTTrackReader pmFile, int samplingRateInHz) {
        block4: {
            this();
            int frameEnd = 0;
            boolean frameStart = false;
            if (pmFile == null || pmFile.getNumFrames() <= 0) break block4;
            frameEnd = (int)((double)pmFile.getTime(0) * (double)samplingRateInHz);
            if (frameEnd > 0) {
                this.pitchMarks = new int[pmFile.getNumFrames() + 1];
                this.f0s = new float[pmFile.getNumFrames()];
                this.pitchMarks[0] = 0;
                for (int f = 0; f < pmFile.getNumFrames(); ++f) {
                    this.pitchMarks[f + 1] = frameEnd = (int)((double)pmFile.getTime(f) * (double)samplingRateInHz);
                    this.f0s[f] = f > 0 ? 1.0f / (pmFile.getTime(f) - pmFile.getTime(f - 1)) : 1.0f / pmFile.getTime(f);
                }
            } else {
                this.pitchMarks = new int[pmFile.getNumFrames()];
                this.f0s = new float[pmFile.getNumFrames() - 1];
                this.pitchMarks[0] = 0;
                for (int f = 1; f < pmFile.getNumFrames(); ++f) {
                    this.pitchMarks[f] = frameEnd = (int)((double)pmFile.getTime(f) * (double)samplingRateInHz);
                    this.f0s[f - 1] = f > 0 ? 1.0f / (pmFile.getTime(f) - pmFile.getTime(f - 1)) : 1.0f / pmFile.getTime(f);
                }
            }
        }
    }

    public PitchMarks(int count, int[] pitchMarksIn, float[] f0sIn, int totalZerosToPaddIn) {
        if (count > 1) {
            this.pitchMarks = new int[count];
            this.f0s = new float[count - 1];
            System.arraycopy(pitchMarksIn, 0, this.pitchMarks, 0, Math.min(pitchMarksIn.length, count));
            System.arraycopy(f0sIn, 0, this.f0s, 0, Math.min(f0sIn.length, count - 1));
        } else {
            this.pitchMarks = null;
            this.f0s = null;
        }
        this.totalZerosToPadd = Math.max(0, totalZerosToPaddIn);
    }

    public void findAndSetUnvoicedF0s(float[] f0sRef, PitchFileHeader f0Header, int samplingRateInHz) {
        double[] f0sRefDouble = ArrayUtils.copyFloat2Double(f0sRef);
        this.findAndSetUnvoicedF0s(f0sRefDouble, f0Header, samplingRateInHz);
    }

    public void findAndSetUnvoicedF0s(double[] f0sRef, PitchFileHeader f0Header, int samplingRateInHz) {
        if (this.pitchMarks != null && this.pitchMarks.length > 1) {
            int i;
            float[] times = new float[f0sRef.length];
            for (i = 0; i < f0sRef.length; ++i) {
                times[i] = (float)SignalProcUtils.frameIndex2Time(i, f0Header.windowSizeInSeconds, f0Header.skipSizeInSeconds);
            }
            for (i = 0; i < this.f0s.length; ++i) {
                float currentTime = SignalProcUtils.sample2time(this.pitchMarks[i + 1], samplingRateInHz);
                int currentRefIndex = MathUtils.findClosest(times, currentTime);
                if (!(f0sRef[currentRefIndex] < 10.0)) continue;
                this.f0s[i] = (float)f0sRef[currentRefIndex];
            }
        }
    }
}

