/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.IOException;
import marytts.signalproc.analysis.CepstrumLPCAnalyser;
import marytts.util.data.ESTTrackReader;
import marytts.util.data.ESTTrackWriter;

public class Lpcc2Lpc {
    private static float[][] convertData(float[][] lpcc, int lpcOrder) {
        int nCep = lpcc[0].length;
        double[] c = new double[nCep];
        double[] a = new double[lpcOrder + 1];
        float[][] lpc = new float[lpcc.length][lpcOrder + 1];
        for (int i = 0; i < lpcc.length; ++i) {
            int k;
            for (k = 0; k < nCep; ++k) {
                c[k] = lpcc[i][k];
            }
            a = CepstrumLPCAnalyser.lpcc2lpc(c, lpcOrder);
            lpc[i][0] = (float)Math.exp(c[0]);
            for (k = 1; k <= lpcOrder; ++k) {
                lpc[i][k] = (float)a[k];
            }
        }
        return lpc;
    }

    public static void convert(String inFileName, String outFileName, int lpcOrder) throws IOException {
        ESTTrackReader etr = new ESTTrackReader(inFileName);
        float[][] lpc = Lpcc2Lpc.convertData(etr.getFrames(), lpcOrder);
        ESTTrackWriter etw = new ESTTrackWriter(etr.getTimes(), lpc, "lpc");
        etw.doWriteAndClose(outFileName, etr.isBinary(), etr.isBigEndian());
    }

    public static void main(String[] args) throws IOException {
        Lpcc2Lpc.convert(args[1], args[2], new Integer(args[0]));
    }
}

