/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.signalproc.adaptation.FileMap;
import marytts.util.io.LEDataInputStream;
import marytts.util.io.LEDataOutputStream;

public class IndexMap {
    public FileMap[] files;

    public IndexMap() {
        this.files = null;
    }

    public IndexMap(int numItems) {
        this.allocate(numItems);
    }

    public IndexMap(IndexMap im) {
        this.copyFrom(im);
    }

    public void allocate(int numItems) {
        this.files = numItems > 0 ? new FileMap[numItems] : null;
    }

    public void copyFrom(IndexMap im) {
        if (im.files.length > 0) {
            this.files = new FileMap[im.files.length];
            for (int i = 0; i < im.files.length; ++i) {
                this.files[i] = new FileMap(im.files[i]);
            }
        } else {
            this.files = null;
        }
    }

    public void writeToFile(String binaryFileName) throws IOException {
        LEDataOutputStream out = null;
        try {
            out = new LEDataOutputStream(binaryFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (out != null) {
            out.writeInt(this.files.length);
            for (int i = 0; i < this.files.length; ++i) {
                out.writeInt(this.files[i].indicesMap.length);
                for (int j = 0; j < this.files[i].indicesMap.length; ++j) {
                    out.writeInt(this.files[i].indicesMap[j].length);
                    out.writeInt(this.files[i].indicesMap[j]);
                }
            }
            out.close();
        }
    }

    public void readFromFile(String binaryFileName) throws IOException {
        LEDataInputStream in = null;
        try {
            in = new LEDataInputStream(binaryFileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (in != null) {
            int numItems = in.readInt();
            this.allocate(numItems);
            for (int i = 0; i < numItems; ++i) {
                int tmpNumGroups = in.readInt();
                this.files[i] = new FileMap(tmpNumGroups, 0);
                for (int j = 0; j < tmpNumGroups; ++j) {
                    int tmpNumItems = in.readInt();
                    if (tmpNumItems <= 0) continue;
                    this.files[i].indicesMap[j] = new int[tmpNumItems];
                    int[] tmpInts = in.readInt(tmpNumItems);
                    System.arraycopy(tmpInts, 0, this.files[i].indicesMap[j], 0, this.files[i].indicesMap[j].length);
                }
            }
            in.close();
        }
    }
}

