/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation;

import marytts.signalproc.analysis.Label;
import marytts.signalproc.analysis.Labels;
import marytts.util.string.StringUtils;

public class Context {
    public int numLeftNeighbours;
    public int numRightNeighbours;
    public String allContext;
    public String[] leftContexts;
    public String currentContext;
    public String[] rightContexts;
    private double[] scores;
    public static final char leftContextSeparator = '.';
    public static final char rightContextSeparator = ',';
    public static final double LOWEST_CONTEXT_SCORE = 1.0;

    public Context(Context existing) {
        this.numLeftNeighbours = existing.numLeftNeighbours;
        this.numRightNeighbours = existing.numRightNeighbours;
        this.allContext = existing.allContext;
        this.setLeftContext(existing.leftContexts);
        this.currentContext = existing.currentContext;
        this.setRightContext(existing.rightContexts);
        this.setScores();
        this.setAllContext();
    }

    public Context(String allContextIn) {
        this.allContext = allContextIn;
        this.parseAllContext();
    }

    public Context(Labels labels, int currentLabelIndex, int totalNeighbours) {
        this(labels, currentLabelIndex, totalNeighbours, totalNeighbours);
    }

    public Context(Labels labels, int currentLabelIndex, int totalLeftNeighbours, int totalRightNeighbours) {
        int i;
        this.leftContexts = null;
        this.rightContexts = null;
        this.currentContext = "";
        if (totalLeftNeighbours > 0) {
            this.leftContexts = new String[totalLeftNeighbours];
            for (i = totalLeftNeighbours; i > 0; --i) {
                this.leftContexts[totalLeftNeighbours - i] = labels != null && currentLabelIndex - i >= 0 ? labels.items[currentLabelIndex - i].phn : "";
            }
        }
        this.currentContext = labels.items[currentLabelIndex].phn;
        if (totalRightNeighbours > 0) {
            this.rightContexts = new String[totalRightNeighbours];
            for (i = 0; i < totalRightNeighbours; ++i) {
                this.rightContexts[i] = labels != null && currentLabelIndex + i + 1 < labels.items.length ? labels.items[currentLabelIndex + i + 1].phn : "";
            }
        }
        this.setScores();
        this.setAllContext();
    }

    public void setLeftContext(String[] leftContextIn) {
        this.leftContexts = null;
        if (leftContextIn != null) {
            this.leftContexts = new String[leftContextIn.length];
            System.arraycopy(leftContextIn, 0, this.leftContexts, 0, this.leftContexts.length);
        }
    }

    public void setRightContext(String[] rightContextIn) {
        this.rightContexts = null;
        if (rightContextIn != null) {
            this.rightContexts = new String[rightContextIn.length];
            System.arraycopy(rightContextIn, 0, this.rightContexts, 0, this.rightContexts.length);
        }
    }

    public void setScores() {
        int maxContext = 0;
        if (this.leftContexts != null) {
            maxContext = this.leftContexts.length;
        }
        if (this.rightContexts != null) {
            maxContext = Math.max(maxContext, this.rightContexts.length);
        }
        this.scores = new double[maxContext + 1];
        double tmpSum = 1.0;
        for (int i = 0; i < maxContext + 1; ++i) {
            this.scores[i] = tmpSum;
            tmpSum = 2.0 * tmpSum + 1.0;
        }
    }

    public double[] getPossibleScores() {
        double[] possibleScores = null;
        if (this.scores != null) {
            possibleScores = new double[2 * (this.scores.length - 1) + 1];
            double tmpSum = 0.0;
            for (int i = 0; i < this.scores.length - 2; ++i) {
                possibleScores[2 * i] = tmpSum + this.scores[i];
                possibleScores[2 * i + 1] = tmpSum + 2.0 * this.scores[i];
                tmpSum += 2.0 * this.scores[i];
            }
            possibleScores[2 * (this.scores.length - 1)] = tmpSum + this.scores[this.scores.length - 1];
        }
        return possibleScores;
    }

    public void setAllContext() {
        int i;
        this.allContext = "";
        for (i = 0; i < this.leftContexts.length; ++i) {
            this.allContext = this.allContext + this.leftContexts[i] + '.';
        }
        this.allContext = this.allContext + this.currentContext + ',';
        for (i = 0; i < this.rightContexts.length - 1; ++i) {
            this.allContext = this.allContext + this.rightContexts[i] + ',';
        }
        this.allContext = this.allContext + this.rightContexts[this.rightContexts.length - 1];
    }

    public void parseAllContext() {
        int[] rightInds;
        int i;
        int[] leftInds = StringUtils.find(this.allContext, '.');
        if (leftInds != null) {
            this.leftContexts = new String[leftInds.length];
            int start = 0;
            for (i = 0; i < leftInds.length; ++i) {
                this.leftContexts[i] = this.allContext.substring(start, leftInds[i]);
                start = leftInds[i] + 1;
            }
        } else {
            this.leftContexts = null;
        }
        if ((rightInds = StringUtils.find(this.allContext, ',')) != null) {
            this.rightContexts = new String[rightInds.length];
            for (i = 0; i < rightInds.length - 1; ++i) {
                this.rightContexts[i] = this.allContext.substring(rightInds[i] + 1, rightInds[i + 1]);
            }
            this.rightContexts[rightInds.length - 1] = this.allContext.substring(rightInds[rightInds.length - 1] + 1, this.allContext.length());
        } else {
            this.rightContexts = null;
        }
        this.currentContext = leftInds != null ? (rightInds != null ? this.allContext.substring(leftInds[leftInds.length - 1] + 1, rightInds[0]) : this.allContext.substring(leftInds[leftInds.length - 1] + 1, this.allContext.length())) : (rightInds != null ? this.allContext.substring(0, rightInds[0]) : this.allContext);
        this.setScores();
    }

    public double matchScore(Context context) {
        assert (this.leftContexts.length == context.leftContexts.length);
        assert (this.rightContexts.length == context.rightContexts.length);
        double score = 0.0;
        if (this.currentContext.compareTo(context.currentContext) == 0) {
            int i;
            score += this.scores[this.scores.length - 1];
            for (i = this.leftContexts.length - 1; i >= 0 && this.leftContexts[i].compareTo(context.leftContexts[i]) == 0; --i) {
                score += this.scores[i];
            }
            for (i = 0; i < this.rightContexts.length && this.rightContexts[i].compareTo(context.rightContexts[i]) == 0; ++i) {
                score += this.scores[this.scores.length - 2 - i];
            }
        }
        return score;
    }

    public static void main(String[] args) {
        Label[] items1 = new Label[5];
        Label[] items2 = new Label[5];
        for (int i = 0; i < items1.length; ++i) {
            items1[i] = new Label();
            items2[i] = new Label();
        }
        Labels labels1 = new Labels(items1);
        Labels labels2 = new Labels(items2);
        labels1.items[0].phn = "A";
        labels1.items[1].phn = "B";
        labels1.items[2].phn = "C";
        labels1.items[3].phn = "D";
        labels1.items[4].phn = "E";
        labels2.items[0].phn = "A1";
        labels2.items[1].phn = "B";
        labels2.items[2].phn = "C";
        labels2.items[3].phn = "D1";
        labels2.items[4].phn = "E1";
        Context c1 = new Context(labels1, 2, 2);
        Context c2 = new Context(labels2, 2, 2);
        System.out.println(String.valueOf(c1.matchScore(c2)));
        Context c3 = new Context("t.u.nl,i,n");
        System.out.println(c3.currentContext);
        double[] possibleScores = c1.getPossibleScores();
        System.out.println("Test completed");
    }
}

