/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.NoSuchPropertyException;
import marytts.modules.ExternalModuleRequest;
import marytts.modules.MaryModule;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import marytts.util.io.StreamLogger;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ExternalModule
implements MaryModule {
    private String name;
    private String cmd;
    private MaryDataType inputType;
    private MaryDataType outputType;
    private Locale locale;
    protected int state;
    protected Process process;
    protected OutputStream to;
    protected InputStream from;
    protected StreamLogger errorLogger;
    private LinkedList requestQueue;
    private boolean exitRequested = false;
    protected ProcessingThread processingThread = null;
    protected RestarterThread restarterThread = null;
    private boolean needToRestart = false;
    protected Logger logger;
    protected long timeLimit;
    protected boolean retrying = false;
    protected String ignorePattern = null;

    protected Process getProcess() {
        return this.process;
    }

    protected ExternalModule(String name, String cmd, MaryDataType inputType, MaryDataType outputType, Locale locale) throws NoSuchPropertyException {
        this.name = name;
        this.cmd = cmd;
        this.inputType = inputType;
        this.outputType = outputType;
        this.locale = locale;
        this.timeLimit = MaryProperties.needInteger("modules.timeout");
        this.requestQueue = new LinkedList();
        this.state = 0;
    }

    protected void open() throws IOException {
        assert (this.cmd != null);
        this.process = Runtime.getRuntime().exec(this.cmd);
        if (System.getProperty("java.vendor").startsWith("Sun") && System.getProperty("java.version").startsWith("1.4.1")) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.to = this.process.getOutputStream();
        this.from = this.process.getInputStream();
        this.errorLogger = new StreamLogger(this.process.getErrorStream(), this.name() + " err", this.ignorePattern);
        this.errorLogger.start();
    }

    protected void close() {
        try {
            if (this.to != null) {
                this.to.close();
            }
            if (this.from != null) {
                this.from.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.process != null) {
            this.process.destroy();
        }
        this.process = null;
        this.to = null;
        this.from = null;
        this.errorLogger = null;
    }

    protected OutputStream to() {
        return this.to;
    }

    protected InputStream from() {
        return this.from;
    }

    protected String cmd() {
        return this.cmd;
    }

    protected void setCmd(String cmd) {
        this.cmd = cmd;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public MaryDataType inputType() {
        return this.getInputType();
    }

    @Override
    public MaryDataType getInputType() {
        return this.inputType;
    }

    @Override
    @Deprecated
    public MaryDataType outputType() {
        return this.getOutputType();
    }

    @Override
    public MaryDataType getOutputType() {
        return this.outputType;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public synchronized void startup() throws Exception {
        assert (this.state == 0);
        this.setExitRequested(false);
        this.open();
        this.setNeedToRestart(false);
        this.logger = MaryUtils.getLogger(this.name());
        this.logger.info("Module started (" + this.inputType() + "->" + this.outputType() + ", locale " + this.getLocale() + ").");
        this.state = 1;
    }

    @Override
    public synchronized void powerOnSelfTest() throws Error {
        assert (this.state == 1);
        this.logger.info("Starting power-on self test.");
        try {
            MaryData in = new MaryData(this.inputType, this.getLocale());
            String example = this.inputType.exampleText(this.getLocale());
            if (example != null) {
                in.readFrom(new StringReader(example));
                if (this.outputType.equals(MaryDataType.get("AUDIO"))) {
                    in.setAudioFileFormat(new AudioFileFormat(AudioFileFormat.Type.WAVE, Voice.AF22050, -1));
                }
                this.process(in);
            } else {
                this.logger.debug("No example text -- no power-on self test!");
            }
        }
        catch (Throwable t) {
            throw new Error("Module " + this.name + ": Power-on self test failed.", t);
        }
        this.logger.info("Power-on self test complete.");
    }

    @Override
    public void shutdown() {
        assert (this.state == 1);
        this.close();
        this.setExitRequested(true);
        this.doNotifyAll();
        try {
            this.processingThread.join();
            this.restarterThread.join();
        }
        catch (InterruptedException e) {
            this.logger.info(e);
        }
        this.logger.info("Module shut down.");
        this.state = 0;
    }

    protected MaryData externalIO(MaryData d) throws TransformerConfigurationException, TransformerException, FileNotFoundException, IOException, ParserConfigurationException, SAXException, Exception {
        assert (!this.needToRestart());
        this.logger.info("Writing to module.");
        d.writeTo(this.to());
        this.logger.info("Reading from module.");
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.readFrom(this.from(), this.outputType().endMarker());
        this.logger.info("Read complete.");
        return result;
    }

    @Override
    public final MaryData process(MaryData d) throws TransformerConfigurationException, TransformerException, FileNotFoundException, IOException, ParserConfigurationException, SAXException, Exception {
        assert (this.state == 1);
        this.logger.info("Adding request");
        ExternalModuleRequest request = new ExternalModuleRequest(d);
        this.addRequest(request);
        this.doNotifyAll();
        this.logger.info("Now waiting for request to be processed");
        long tStart = System.currentTimeMillis();
        while (!request.problemOccurred() && request.getOutput() == null && System.currentTimeMillis() - tStart < this.timeLimit) {
            this.doWait(this.timeLimit);
        }
        if (request.getOutput() == null) {
            if (request.problemOccurred()) {
                this.logger.error("Problem occurred. Rescheduling request.");
            } else {
                this.logger.error("Timeout occurred. Requesting module restart and rescheduling request.");
                this.setNeedToRestart(true);
            }
            this.removeRequest(request);
            request.setProblemOccurred(false);
            this.addRequest(request);
            this.doNotifyAll();
            this.logger.info("Waiting for request to be processed (2nd try)");
            tStart = System.currentTimeMillis();
            while (!request.problemOccurred() && request.getOutput() == null && System.currentTimeMillis() - tStart < this.timeLimit) {
                this.doWait(this.timeLimit);
            }
            if (request.getOutput() == null) {
                if (request.problemOccurred()) {
                    this.logger.error("Problem occurred again. Giving up.");
                } else {
                    this.logger.error("Timeout occurred again. Requesting module restart, but giving up on this request.");
                    this.setNeedToRestart(true);
                }
                this.removeRequest(request);
                throw new IOException("Module " + this.name() + " cannot process.");
            }
        }
        this.logger.info("Request processed");
        return request.getOutput();
    }

    protected synchronized void addRequest(Object r) {
        this.requestQueue.addLast(r);
    }

    protected synchronized ExternalModuleRequest getNextRequest() {
        return (ExternalModuleRequest)this.requestQueue.removeFirst();
    }

    protected synchronized void removeRequest(ExternalModuleRequest r) {
        this.requestQueue.remove(r);
    }

    protected synchronized boolean haveWaitingRequests() {
        return !this.requestQueue.isEmpty();
    }

    protected synchronized void setNeedToRestart(boolean needToRestart) {
        this.needToRestart = needToRestart;
    }

    protected synchronized boolean needToRestart() {
        return this.needToRestart;
    }

    protected synchronized void doNotifyAll() {
        this.notifyAll();
    }

    protected synchronized void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            this.logger.info(e);
        }
    }

    protected synchronized void doWait(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException e) {
            this.logger.info(e);
        }
    }

    protected synchronized void setExitRequested(boolean b) {
        this.exitRequested = b;
    }

    protected synchronized boolean exitRequested() {
        return this.exitRequested;
    }

    public class RestarterThread
    extends Thread {
        protected static final int MAX_RESTART_ATTEMPTS = 3;

        @Override
        public void run() {
            int nrFailuresRestarting = 0;
            while (!ExternalModule.this.exitRequested()) {
                if (ExternalModule.this.needToRestart()) {
                    if (nrFailuresRestarting < 3) {
                        ExternalModule.this.logger.info("Restarting module.");
                        try {
                            ExternalModule.this.close();
                            ExternalModule.this.open();
                            ExternalModule.this.setNeedToRestart(false);
                            ExternalModule.this.logger.info("Module restarted");
                            ExternalModule.this.doNotifyAll();
                            nrFailuresRestarting = 0;
                        }
                        catch (Exception e) {
                            ExternalModule.this.logger.error("Problem restarting.", e);
                            ++nrFailuresRestarting;
                        }
                        continue;
                    }
                    ExternalModule.this.logger.error("Restarting has failed " + nrFailuresRestarting + " times, giving up.");
                    ExternalModule.this.setNeedToRestart(false);
                    nrFailuresRestarting = 0;
                    ExternalModule.this.doNotifyAll();
                    continue;
                }
                ExternalModule.this.logger.info("Currently no need to restart, waiting");
                ExternalModule.this.doWait();
                ExternalModule.this.logger.info("RestarterThread was woken up.");
            }
        }
    }

    public class ProcessingThread
    extends Thread {
        @Override
        public void run() {
            while (!ExternalModule.this.exitRequested()) {
                while (ExternalModule.this.needToRestart()) {
                    ExternalModule.this.logger.info("ProcessingThread waiting for restart.");
                    ExternalModule.this.doWait();
                    if (ExternalModule.this.needToRestart()) continue;
                    ExternalModule.this.logger.info("ProcessingThread noticed restart done.");
                }
                if (ExternalModule.this.haveWaitingRequests()) {
                    ExternalModuleRequest request = ExternalModule.this.getNextRequest();
                    ExternalModule.this.logger.info("Now processing next request.");
                    try {
                        MaryData output = ExternalModule.this.externalIO(request.getInput());
                        request.setOutput(output);
                        ExternalModule.this.doNotifyAll();
                    }
                    catch (Exception e) {
                        ExternalModule.this.logger.error("Problem occurred during I/O with external module. Requesting module restart.", e);
                        request.setProblemOccurred(true);
                        ExternalModule.this.setNeedToRestart(true);
                        ExternalModule.this.doNotifyAll();
                    }
                    continue;
                }
                ExternalModule.this.logger.debug("Currently nothing to do, waiting");
                ExternalModule.this.doWait();
                ExternalModule.this.logger.debug("ProcessingThread was woken up.");
            }
        }
    }
}

