/*
 * Decompiled with CFR 0.152.
 */
package marytts.machinelearning;

import marytts.machinelearning.Cluster;
import marytts.machinelearning.KMeansClusteringTrainerParams;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.util.math.MathUtils;

public class KMeansClusteringTrainer {
    public Cluster[] clusters;
    public int[] totalObservationsInClusters;
    public int[] clusterIndices;
    public double[][] covMatrixGlobal;
    public double[][] invCovMatrixGlobal;

    public void train(double[][] x, KMeansClusteringTrainerParams kmeansParams) {
        int d2;
        int d1;
        int[] inds;
        int i;
        int d;
        int t;
        int k;
        if (kmeansParams.globalVariances == null) {
            double[] meanVector = MathUtils.mean(x, true);
            kmeansParams.globalVariances = MathUtils.variance(x, meanVector, true);
        }
        int observations = x.length;
        int dimension = x[0].length;
        int ind = -1;
        double minDist = Double.MIN_VALUE;
        double[][] m_new = new double[kmeansParams.numClusters][];
        for (k = 0; k < kmeansParams.numClusters; ++k) {
            m_new[k] = new double[dimension];
        }
        int[][] b = new int[observations][];
        for (t = 0; t < observations; ++t) {
            b[t] = new int[kmeansParams.numClusters];
        }
        int[][] b_old = new int[observations][];
        for (t = 0; t < observations; ++t) {
            b_old[t] = new int[kmeansParams.numClusters];
        }
        int[] prev_totals = new int[kmeansParams.numClusters];
        double[] mAll = new double[dimension];
        this.clusters = new Cluster[kmeansParams.numClusters];
        for (k = 0; k < kmeansParams.numClusters; ++k) {
            this.clusters[k] = new Cluster(dimension, kmeansParams.isDiagonalOutputCovariance);
        }
        for (k = 1; k <= kmeansParams.numClusters; ++k) {
            for (d = 1; d <= dimension; ++d) {
                this.clusters[k - 1].meanVector[d - 1] = 0.0;
            }
            for (t = 1; t <= observations; ++t) {
                b[t - 1][k - 1] = 0;
            }
        }
        mAll = MathUtils.mean(x, true);
        double[] dists = new double[observations];
        double[] tmp = new double[kmeansParams.numClusters + 1];
        double maxD = Double.MAX_VALUE;
        int maxInd = -1;
        for (k = 1; k <= kmeansParams.numClusters; ++k) {
            for (t = 1; t <= observations; ++t) {
                if (k > 1) {
                    for (i = 1; i <= k - 1; ++i) {
                        tmp[i - 1] = DistanceComputer.getNormalizedEuclideanDistance(this.clusters[i - 1].meanVector, x[t - 1], kmeansParams.globalVariances);
                    }
                    tmp[k - 1] = DistanceComputer.getNormalizedEuclideanDistance(mAll, x[t - 1], kmeansParams.globalVariances);
                    dists[t - 1] = MathUtils.mean(tmp, 0, k - 1);
                    continue;
                }
                dists[t - 1] = DistanceComputer.getNormalizedEuclideanDistance(mAll, x[t - 1], kmeansParams.globalVariances);
            }
            for (t = 1; t <= observations; ++t) {
                if (t != 1 && !(dists[t - 1] > maxD)) continue;
                maxD = dists[t - 1];
                maxInd = t;
            }
            for (d = 0; d < dimension; ++d) {
                this.clusters[k - 1].meanVector[d] = x[maxInd - 1][d];
            }
        }
        int[] tinyClusterInds = new int[kmeansParams.numClusters];
        int numTinyClusters = 0;
        double[] tmps = new double[kmeansParams.numClusters];
        this.totalObservationsInClusters = new int[kmeansParams.numClusters];
        this.clusterIndices = new int[observations];
        int iter = 0;
        boolean bCont = true;
        while (bCont) {
            for (t = 1; t <= observations; ++t) {
                for (i = 1; i <= kmeansParams.numClusters; ++i) {
                    double tmpDist = DistanceComputer.getNormalizedEuclideanDistance(this.clusters[i - 1].meanVector, x[t - 1], kmeansParams.globalVariances);
                    b[t - 1][i - 1] = 0;
                    if (i != 1 && !(tmpDist < minDist)) continue;
                    minDist = tmpDist;
                    ind = i;
                }
                for (i = 1; i <= kmeansParams.numClusters; ++i) {
                    if (i != ind) continue;
                    b[t - 1][i - 1] = 1;
                }
            }
            for (i = 1; i <= kmeansParams.numClusters; ++i) {
                this.totalObservationsInClusters[i - 1] = 0;
                tinyClusterInds[i - 1] = 0;
            }
            int c = 1;
            for (i = 1; i <= kmeansParams.numClusters; ++i) {
                for (d = 1; d <= dimension; ++d) {
                    m_new[i - 1][d - 1] = 0.0;
                }
                for (t = 1; t <= observations; ++t) {
                    if (b[t - 1][i - 1] != 1) continue;
                    for (d = 1; d <= dimension; ++d) {
                        m_new[i - 1][d - 1] = m_new[i - 1][d - 1] + x[t - 1][d - 1];
                    }
                    this.clusterIndices[t - 1] = i - 1;
                    int n = i - 1;
                    this.totalObservationsInClusters[n] = this.totalObservationsInClusters[n] + 1;
                }
                if (!((double)this.totalObservationsInClusters[i - 1] < (double)kmeansParams.minSamplesInOneCluster)) continue;
                tinyClusterInds[c - 1] = i;
                ++numTinyClusters;
                ++c;
            }
            c = 0;
            for (i = 0; i < this.totalObservationsInClusters.length; ++i) {
                tmps[i] = this.totalObservationsInClusters[i];
            }
            inds = MathUtils.quickSort(tmps, 0, kmeansParams.numClusters - 1);
            for (i = 1; i <= kmeansParams.numClusters; ++i) {
                if (this.totalObservationsInClusters[i - 1] >= kmeansParams.minSamplesInOneCluster) {
                    for (d = 1; d <= dimension; ++d) {
                        this.clusters[i - 1].meanVector[d - 1] = m_new[i - 1][d - 1] / (double)this.totalObservationsInClusters[i - 1];
                    }
                    continue;
                }
                for (d = 1; d <= dimension; ++d) {
                    double rnd = Math.random() * Math.abs(this.clusters[inds[kmeansParams.numClusters - c - 1]].meanVector[d - 1]) * 0.01;
                    this.clusters[i - 1].meanVector[d - 1] = this.clusters[inds[kmeansParams.numClusters - c - 1]].meanVector[d - 1] + rnd;
                }
                ++c;
            }
            for (i = 1; i <= kmeansParams.numClusters; ++i) {
                prev_totals[i - 1] = this.totalObservationsInClusters[i - 1];
            }
            int totChanged = 0;
            if (++iter > 1) {
                if (iter >= kmeansParams.maxIterations) {
                    bCont = false;
                }
                block26: for (t = 1; t <= observations; ++t) {
                    for (i = 1; i <= kmeansParams.numClusters; ++i) {
                        if (b_old[t - 1][i - 1] == b[t - 1][i - 1]) continue;
                        ++totChanged;
                        continue block26;
                    }
                }
                double changedPerc = (double)totChanged / (double)observations * 100.0;
                if (changedPerc < kmeansParams.minClusterChangePercent) {
                    bCont = false;
                }
            }
            for (t = 1; t <= observations; ++t) {
                for (int k2 = 1; k2 <= kmeansParams.numClusters; ++k2) {
                    b_old[t - 1][k2 - 1] = b[t - 1][k2 - 1];
                }
            }
        }
        double[][] tmpCov = null;
        double[] diag = null;
        for (i = 0; i < kmeansParams.numClusters; ++i) {
            if (this.totalObservationsInClusters[i] <= 0) continue;
            int[] indices = new int[this.totalObservationsInClusters[i]];
            int count = 0;
            for (t = 0; t < observations; ++t) {
                if (this.clusterIndices[t] != i) continue;
                indices[count++] = t;
            }
            if (kmeansParams.isDiagonalOutputCovariance) {
                tmpCov = MathUtils.covariance(x, this.clusters[i].meanVector, true, indices);
                diag = MathUtils.diagonal(tmpCov);
                for (d1 = 0; d1 < diag.length; ++d1) {
                    diag[d1] = Math.max(diag[d1], kmeansParams.minCovarianceAllowed);
                }
                System.arraycopy(diag, 0, this.clusters[i].covMatrix[0], 0, diag.length);
                this.clusters[i].invCovMatrix[0] = MathUtils.inverse(this.clusters[i].covMatrix[0]);
                continue;
            }
            this.clusters[i].covMatrix = MathUtils.covariance(x, this.clusters[i].meanVector, true, indices);
            for (d1 = 0; d1 < this.clusters[i].covMatrix.length; ++d1) {
                for (d2 = 0; d2 < this.clusters[i].covMatrix[d1].length; ++d2) {
                    this.clusters[i].covMatrix[d1][d2] = Math.max(this.clusters[i].covMatrix[d1][d2], kmeansParams.minCovarianceAllowed);
                }
            }
            this.clusters[i].invCovMatrix = MathUtils.inverse(this.clusters[i].covMatrix);
        }
        for (i = 0; i < kmeansParams.numClusters; ++i) {
            tmps[i] = this.totalObservationsInClusters[i];
        }
        inds = MathUtils.quickSort(tmps, 0, kmeansParams.numClusters - 1);
        int largestClusterInd = inds[kmeansParams.numClusters - 1];
        for (i = 0; i < kmeansParams.numClusters; ++i) {
            if (this.totalObservationsInClusters[i] >= kmeansParams.minSamplesInOneCluster) continue;
            System.arraycopy(this.clusters[largestClusterInd].meanVector, 0, this.clusters[i].meanVector, 0, dimension);
            if (kmeansParams.isDiagonalOutputCovariance) {
                System.arraycopy(this.clusters[largestClusterInd].covMatrix[0], 0, this.clusters[i].covMatrix[0], 0, dimension);
                System.arraycopy(this.clusters[largestClusterInd].invCovMatrix[0], 0, this.clusters[i].invCovMatrix[0], 0, dimension);
                continue;
            }
            for (int j = 0; j < dimension; ++j) {
                System.arraycopy(this.clusters[largestClusterInd].covMatrix[j], 0, this.clusters[i].covMatrix[j], 0, dimension);
                System.arraycopy(this.clusters[largestClusterInd].invCovMatrix[j], 0, this.clusters[i].invCovMatrix[j], 0, dimension);
            }
        }
        if (kmeansParams.isDiagonalOutputCovariance) {
            tmpCov = MathUtils.covariance(x, true);
            this.covMatrixGlobal = new double[1][tmpCov.length];
            this.covMatrixGlobal[0] = MathUtils.diagonal(tmpCov);
            for (d1 = 0; d1 < this.covMatrixGlobal[0].length; ++d1) {
                this.covMatrixGlobal[0][d1] = Math.max(this.covMatrixGlobal[0][d1], kmeansParams.minCovarianceAllowed);
            }
            this.invCovMatrixGlobal = new double[1][tmpCov.length];
            this.invCovMatrixGlobal[0] = MathUtils.inverse(this.covMatrixGlobal[0]);
        } else {
            this.covMatrixGlobal = MathUtils.covariance(x);
            for (d1 = 0; d1 < this.covMatrixGlobal[0].length; ++d1) {
                for (d2 = 0; d2 < this.covMatrixGlobal[d1].length; ++d2) {
                    this.covMatrixGlobal[d1][d2] = Math.max(this.covMatrixGlobal[d1][d2], kmeansParams.minCovarianceAllowed);
                }
            }
            this.invCovMatrixGlobal = MathUtils.inverse(this.covMatrixGlobal);
        }
    }

    public int getFeatureDimension() {
        if (this.clusters != null && this.clusters[0].meanVector != null) {
            return this.clusters[0].meanVector.length;
        }
        return 0;
    }

    public int getTotalClusters() {
        if (this.clusters != null) {
            return this.clusters.length;
        }
        return 0;
    }

    public boolean isDiagonalCovariance() {
        if (this.clusters != null) {
            return this.clusters[0].isDiagonalCovariance;
        }
        return false;
    }
}

