/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.fr;

import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.modules.JPhonemiser;
import marytts.util.MaryUtils;

public class Phonemiser
extends JPhonemiser {
    public Phonemiser() throws IOException, MaryConfigurationException {
        super("fr.");
    }

    @Override
    public String phonemise(String text, String pos, StringBuilder g2pMethod) {
        String phones;
        String result = this.userdictLookup(text = text.replaceAll("[0-9]+", ""), pos);
        if (result != null) {
            g2pMethod.append("userdict");
            return result;
        }
        result = this.lexiconLookup(text, pos);
        if (result != null) {
            g2pMethod.append("lexicon");
            return result;
        }
        String normalised = MaryUtils.normaliseUnicodeLetters(text, this.getLocale());
        if (!normalised.equals(text)) {
            result = this.userdictLookup(normalised, pos);
            if (result != null) {
                g2pMethod.append("userdict");
                return result;
            }
            result = this.lexiconLookup(normalised, pos);
            if (result != null) {
                g2pMethod.append("lexicon");
                return result;
            }
        }
        if ((result = this.lts.syllabify(phones = this.lts.predictPronunciation(text))) != null) {
            g2pMethod.append("rules");
            return result;
        }
        return null;
    }
}

