/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.en;

import java.util.Locale;
import marytts.datatypes.MaryXML;
import marytts.modules.phonemiser.Allophone;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

public class PronunciationModel
extends marytts.modules.PronunciationModel {
    public PronunciationModel() {
        super(Locale.ENGLISH);
    }

    @Override
    protected boolean postlexicalRules(Element token, AllophoneSet allophoneSet) {
        String word = MaryDomUtils.tokenText(token);
        if (word.equals("'s") || word.equals("'ve") || word.equals("'ll") || word.equals("'d")) {
            Element sentence = (Element)MaryDomUtils.getAncestor((Node)token, "s");
            if (sentence == null) {
                return false;
            }
            TreeWalker tw = MaryDomUtils.createTreeWalker(sentence, "ph");
            tw.setCurrentNode(token);
            Element currentSegment = (Element)tw.nextNode();
            if (currentSegment == null) {
                return false;
            }
            Element prevSegment = (Element)tw.previousNode();
            if (prevSegment == null) {
                return false;
            }
            String pname = prevSegment.getAttribute("p");
            Allophone prev = allophoneSet.getAllophone(pname);
            if (word.equals("'s")) {
                if ("fa".contains(prev.getFeature("ctype")) && "ap".contains(prev.getFeature("cplace"))) {
                    this.prependSchwa(currentSegment);
                    return true;
                }
                if (prev.getFeature("cvox").equals("-")) {
                    currentSegment.setAttribute("p", "s");
                    return true;
                }
            } else if (prev.isConsonant()) {
                this.prependSchwa(currentSegment);
                return true;
            }
        }
        return false;
    }

    private void prependSchwa(Element currentSegment) {
        Element syllable = (Element)currentSegment.getParentNode();
        assert (syllable != null);
        Element schwa = MaryXML.createElement(syllable.getOwnerDocument(), "ph");
        schwa.setAttribute("p", "@");
        syllable.insertBefore(schwa, currentSegment);
    }
}

